/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.provider.NamedElementItemProvider;
import org.eclipse.emf.henshin.provider.descriptors.NodeTypePropertyDescriptor;
import org.eclipse.emf.henshin.provider.util.IconUtil;

public class NodeItemProvider
extends NamedElementItemProvider {
    public NodeItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addActionPropertyDescriptor(object);
            this.addTypePropertyDescriptor(object);
            this.addIncomingPropertyDescriptor(object);
            this.addOutgoingPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addActionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_GraphElement_action_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_GraphElement_action_feature", "_UI_GraphElement_type"), (EStructuralFeature)HenshinPackage.Literals.GRAPH_ELEMENT__ACTION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new NodeTypePropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Node_type_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Node_type_feature", "_UI_Node_type")));
    }

    protected void addIncomingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Node_incoming_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Node_incoming_feature", "_UI_Node_type"), (EStructuralFeature)HenshinPackage.Literals.NODE__INCOMING, true, false, true, null, null, null));
    }

    protected void addOutgoingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Node_outgoing_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Node_outgoing_feature", "_UI_Node_type"), (EStructuralFeature)HenshinPackage.Literals.NODE__OUTGOING, true, false, true, null, null, null));
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(HenshinPackage.Literals.NODE__ATTRIBUTES);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        Node node = (Node)object;
        Node kernelNode = this.getKernelNode(node);
        if (kernelNode != null) {
            return this.getImage(kernelNode);
        }
        Object defaultImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Node.gif"));
        if (node.eContainer() == null) {
            return defaultImage;
        }
        boolean needsAttention = false;
        if (needsAttention |= node.getType() == null) {
            Object attentionOverlay = this.getResourceLocator().getImage("full/ovr16/Attn_ovr.png");
            defaultImage = IconUtil.getCompositeImage(defaultImage, attentionOverlay);
        }
        return defaultImage;
    }

    @Override
    public String getText(Object object) {
        return ((Node)object).toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Node.class)) {
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                break;
            }
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                break;
            }
            case 1: {
                Node node = (Node)notification.getNotifier();
                this.notifyEdges(node, notification);
            }
        }
        super.notifyChanged(notification);
    }

    private void notifyEdges(Node node, Notification notification) {
        ArrayList edgeList = new ArrayList(node.getIncoming());
        edgeList.addAll(node.getOutgoing());
        if (!edgeList.isEmpty()) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)edgeList.get(0), null);
            for (Edge edge : edgeList) {
                ViewerNotification notif = new ViewerNotification(notification, (Object)edge, false, true);
                adapter.fireNotifyChanged((Notification)notif);
            }
        }
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.NODE__ATTRIBUTES, HenshinFactory.eINSTANCE.createAttribute()));
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        Node node = (Node)owner;
        CompoundCommand cmpCmd = new CompoundCommand(Integer.MIN_VALUE);
        for (Node dependentNode : this.getDependentNodes(node)) {
            cmpCmd.append(this.createSetCommand(domain, (EObject)dependentNode, feature, value, index));
        }
        cmpCmd.append(super.createSetCommand(domain, owner, feature, value, index));
        return cmpCmd.unwrap();
    }

    private Node getKernelNode(Node node) {
        if (node.getGraph() != null && (node.getGraph().isLhs() || node.getGraph().isRhs())) {
            Rule rule = node.getGraph().getRule();
            return rule.getMultiMappings().getOrigin(node);
        }
        return null;
    }

    private Collection<Node> getDependentNodes(Node node) {
        if (node.getGraph().isLhs() || node.getGraph().isRhs()) {
            ArrayList<Node> result = new ArrayList<Node>();
            Rule rule = node.getGraph().getRule();
            for (Rule mRule : rule.getMultiRules()) {
                Node imgNode = this.getDependentNodeInRule(node, mRule);
                if (imgNode == null) continue;
                result.add(imgNode);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private Node getDependentNodeInRule(Node node, Rule rule) {
        for (Mapping m : rule.getMultiMappings()) {
            if (m.getOrigin() != node) continue;
            return m.getImage();
        }
        return null;
    }
}

