/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.HenshinFactory;

public class WrapFormulaInJunctionCommand
extends AbstractCommand {
    protected Formula formula;
    protected BinaryFormula junction;
    protected JunctionCreationStrategy strategy;
    protected Collection<?> affectedObjects;

    protected WrapFormulaInJunctionCommand(Formula formula) {
        this.formula = formula;
    }

    protected void setStrategy(JunctionCreationStrategy strategy) {
        this.strategy = strategy;
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        this.junction = this.strategy.createJunction();
        this.redo();
    }

    public void redo() {
        this.formula.eContainer().eSet(this.formula.eContainingFeature(), (Object)this.junction);
        this.junction.setLeft(this.formula);
        this.affectedObjects = Collections.singleton(this.junction);
    }

    public void undo() {
        this.junction.eContainer().eSet(this.junction.eContainingFeature(), (Object)this.formula);
        this.affectedObjects = Collections.singleton(this.junction);
    }

    public boolean canUndo() {
        return true;
    }

    public Collection<?> getAffectedObjects() {
        return this.affectedObjects;
    }

    public static WrapFormulaInJunctionCommand createWrapInAndCommand(Formula formula) {
        WrapFormulaInJunctionCommand cmd = new WrapFormulaInJunctionCommand(formula);
        cmd.setStrategy(cmd.new AndStrategy());
        return cmd;
    }

    public static WrapFormulaInJunctionCommand createWrapInOrCommand(Formula formula) {
        WrapFormulaInJunctionCommand cmd = new WrapFormulaInJunctionCommand(formula);
        cmd.setStrategy(cmd.new OrStrategy());
        return cmd;
    }

    protected class AndStrategy
    implements JunctionCreationStrategy {
        protected AndStrategy() {
        }

        @Override
        public BinaryFormula createJunction() {
            return HenshinFactory.eINSTANCE.createAnd();
        }
    }

    protected static interface JunctionCreationStrategy {
        public BinaryFormula createJunction();
    }

    protected class OrStrategy
    implements JunctionCreationStrategy {
        protected OrStrategy() {
        }

        @Override
        public BinaryFormula createJunction() {
            return HenshinFactory.eINSTANCE.createOr();
        }
    }
}

