/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.tool.action;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import laxcondition.Condition;
import laxcondition.util.extensions.LaxConditionSimplifier;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import nestedcondition.NestedconditionFactory;
import nestedcondition.Variable;
import nestedcondition.util.extensions.NestedConditionSimplifier;
import nestedconstraintmodel.NestedConstraintModel;
import nestedconstraintmodel.NestedconstraintmodelFactory;
import nestedconstraintmodel.NestedconstraintmodelPackage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.core.Completer;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.TranslatorResourceSet;
import org.eclipse.emf.henshin.ocl2ac.tool.commands.OCL2LaxCondCommand;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class OCL2GCAction
implements IObjectActionDelegate {
    private static final String OCLAS = ".oclas";
    private static final String ECORE = ".ecore";
    private Shell shell;
    private List<IFile> files = null;
    private IFile ecoreFile = null;
    private IFile oclasFile = null;

    public void run(IAction action) {
        if (this.checkFiles()) {
            Cursor oldCursor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getCursor();
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(new Cursor(null, 1));
            long start = System.currentTimeMillis();
            OCL2LaxCondCommand translator = new OCL2LaxCondCommand(this.oclasFile, this.ecoreFile);
            List<Condition> arrayListLaxConditions = translator.getSetofLaxConditions();
            System.out.println("NN: arrayListLaxConditions size is: " + arrayListLaxConditions.size());
            EPackage typeModel = translator.getTypeModel();
            this.simplifyLaxConditions(arrayListLaxConditions);
            List<NestedConstraint> arrayListNestedConstraints = this.completeLaxConditions(translator, arrayListLaxConditions);
            this.simplifyNextedConstraints(arrayListNestedConstraints);
            long stop = System.currentTimeMillis();
            long translationTime = stop - start;
            System.out.println("[#" + translationTime + ")]");
            NestedconstraintmodelPackage.eINSTANCE.eClass();
            NestedConstraintModel constraintmodel = NestedconstraintmodelFactory.eINSTANCE.createNestedConstraintModel();
            constraintmodel.setName(String.valueOf(typeModel.getName()) + "Constraints");
            constraintmodel.getNestedconstrainmodels().addAll(arrayListNestedConstraints);
            System.out.println("[# OCL Invariants is:(" + translator.invariants.size() + ")]");
            System.out.println("[# Resulted NGC is:(" + arrayListNestedConstraints.size() + ")]");
            Date date = new GregorianCalendar().getTime();
            this.persistNestedConstraintsModel(date, constraintmodel);
            this.shell.setCursor(oldCursor);
            MessageDialog.openInformation((Shell)this.shell, (String)"OCL2AC", (String)("The translation time is: (" + (double)translationTime / 1000.0 + ") second(s)."));
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Translation", (String)"Translation can not be executed on the input.");
        }
    }

    private void simplifyNextedConstraints(List<NestedConstraint> arrayListNestedConstraints) {
        for (NestedConstraint nestedconstrain : arrayListNestedConstraints) {
            try {
                NestedConditionSimplifier simplifierNGC = new NestedConditionSimplifier(nestedconstrain);
                simplifierNGC.simplify();
            }
            catch (Exception exception) {
                System.err.println("The nestedconstrain " + nestedconstrain.getName() + " is not simplified well");
            }
        }
    }

    private List<NestedConstraint> completeLaxConditions(OCL2LaxCondCommand translator, List<Condition> arrayListLaxConditions) {
        ArrayList<NestedConstraint> arrayListNestedConstraints = new ArrayList<NestedConstraint>();
        List<String> conditionVarNames = null;
        for (Condition condition : arrayListLaxConditions) {
            try {
                conditionVarNames = translator.mapCon2Var.get(condition);
                Completer completer = new Completer(condition);
                completer.complete();
                NestedConstraint nestedConstraint = completer.getConstraint();
                NestedCondition nestedCondition = nestedConstraint.getCondition();
                if (conditionVarNames != null) {
                    this.addVariables2Condition(nestedCondition, conditionVarNames);
                }
                arrayListNestedConstraints.add(nestedConstraint);
            }
            catch (Exception exception) {
                System.err.println("The condition " + condition.getName() + " is not completed well");
            }
        }
        return arrayListNestedConstraints;
    }

    private void simplifyLaxConditions(List<Condition> arrayListLaxConditions) {
        for (Condition condition : arrayListLaxConditions) {
            try {
                LaxConditionSimplifier simplifier = new LaxConditionSimplifier(condition);
                simplifier.simplify();
            }
            catch (Exception exception) {
                System.err.println("The condition " + condition.getName() + " is not simplified well");
            }
        }
    }

    private void addVariables2Condition(NestedCondition nestedCondition, List<String> conditionVarNames) {
        for (String v : conditionVarNames) {
            Variable conVar = NestedconditionFactory.eINSTANCE.createVariable();
            conVar.setName(v);
            if (nestedCondition.getVariables().contains((Object)conVar)) continue;
            nestedCondition.getVariables().add((Object)conVar);
        }
    }

    private void persistNestedConstraintsModel(Date date, NestedConstraintModel nestedConstraintModel) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String path = this.oclasFile.getParent().getLocation().toOSString();
        TranslatorResourceSet resourceSet = new TranslatorResourceSet(path);
        resourceSet.saveEObject((EObject)nestedConstraintModel, nestedConstraintModel.getName().concat("_" + sdf.format(date) + ".nestedconstraintmodel"));
        try {
            this.oclasFile.getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean checkFiles() {
        IFile file1 = this.files.get(0);
        IFile file2 = this.files.get(1);
        if (!file1.getName().endsWith(ECORE) && !file2.getName().endsWith(ECORE)) {
            return false;
        }
        if (!file1.getName().endsWith(OCLAS) && !file2.getName().endsWith(OCLAS)) {
            return false;
        }
        if (file1.getName().endsWith(ECORE)) {
            this.ecoreFile = file1;
            this.oclasFile = file2;
        } else {
            this.ecoreFile = file2;
            this.oclasFile = file1;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.files = new ArrayList<IFile>();
        if (selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            List objects = ss.toList();
            for (Object o : objects) {
                this.files.add((IFile)o);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

