/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.hashcodes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.hashcodes.LocalHashCodeHelper;

class ContextHashCodeHelper {
    private static final int CONTEXT_UPDATES = 8;
    private final Model model;
    private final EqualityHelper equalityHelper;
    private EObject[] objects;
    private Map<EObject, Integer> indizes;
    private int[] hashCodes;
    private int[] newHashCodes;
    private int[] crossReferences;

    ContextHashCodeHelper(Model model, EqualityHelper equalityHelper) {
        this.model = model;
        this.equalityHelper = equalityHelper;
    }

    void computeContextHashCodes() {
        this.extractObjects(this.model);
        this.extractCrossReferences();
        this.initContextHashCodes(this.model, this.equalityHelper);
        int i = 0;
        while (i < 8) {
            this.updateContextHashCodes();
            ++i;
        }
        EMap<EObject, Integer> map = this.model.getObjectHashCodes();
        map.clear();
        int i2 = 0;
        while (i2 < this.objects.length) {
            map.put((Object)this.objects[i2], (Object)this.hashCodes[i2]);
            ++i2;
        }
        this.objects = null;
        this.indizes = null;
        this.hashCodes = null;
        this.crossReferences = null;
    }

    protected void extractObjects(Model model) {
        this.objects = new EObject[model.getObjectCount()];
        this.indizes = new HashMap<EObject, Integer>();
        TreeIterator iterator = model.getResource().getAllContents();
        int index = 0;
        while (iterator.hasNext()) {
            this.objects[index] = (EObject)iterator.next();
            this.indizes.put(this.objects[index], index);
            ++index;
        }
    }

    protected void initContextHashCodes(Model model, EqualityHelper equalityHelper) {
        this.hashCodes = new int[this.objects.length];
        this.newHashCodes = new int[this.objects.length];
        int i = 0;
        while (i < this.objects.length) {
            int objectKey = 0;
            if (equalityHelper.getIdentityTypes().contains((Object)this.objects[i].eClass())) {
                Integer key = (Integer)model.getObjectKeysMap().get((Object)this.objects[i]);
                if (key == null) {
                    throw new RuntimeException("Missing object key for " + this.objects[i]);
                }
                objectKey = key;
            }
            this.hashCodes[i] = LocalHashCodeHelper.hashCode(this.objects[i], objectKey, equalityHelper);
            ++i;
        }
    }

    private void extractCrossReferences() {
        this.crossReferences = new int[this.objects.length * this.objects.length];
        int row = 0;
        while (row < this.objects.length) {
            int column;
            EObject object = this.objects[row];
            int mask = 1;
            EObject container = object.eContainer();
            if (container != null) {
                column = this.indizes.get(container);
                int n = row * this.objects.length + column;
                this.crossReferences[n] = this.crossReferences[n] | mask;
            }
            mask <<= 1;
            for (EReference reference : object.eClass().getEAllReferences()) {
                if (reference.isMany()) {
                    EList targets = (EList)object.eGet((EStructuralFeature)reference);
                    for (EObject target : targets) {
                        column = this.indizes.get(target);
                        int n = row * this.objects.length + column;
                        this.crossReferences[n] = this.crossReferences[n] | mask;
                    }
                } else {
                    EObject target = (EObject)object.eGet((EStructuralFeature)reference);
                    if (target != null) {
                        column = this.indizes.get(target);
                        int n = row * this.objects.length + column;
                        this.crossReferences[n] = this.crossReferences[n] | mask;
                    }
                }
                mask <<= 1;
            }
            ++row;
        }
    }

    protected void updateContextHashCodes() {
        int index = 0;
        while (index < this.objects.length) {
            this.newHashCodes[index] = this.hashCodes[index];
            int column = 0;
            while (column < this.objects.length) {
                int outgoingRefs = this.crossReferences[index * this.objects.length + column];
                int n = index;
                this.newHashCodes[n] = this.newHashCodes[n] + this.hashCodes[column] * outgoingRefs;
                ++column;
            }
            int row = 0;
            while (row < this.objects.length) {
                int incomingRefs = this.crossReferences[row * this.objects.length + index];
                int n = index;
                this.newHashCodes[n] = this.newHashCodes[n] + this.hashCodes[row] * incomingRefs;
                ++row;
            }
            ++index;
        }
        int[] dummy = this.newHashCodes;
        this.newHashCodes = this.hashCodes;
        this.hashCodes = dummy;
    }
}

