/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingIterator<T>
implements Iterator<T> {
    private List<T> lookaheadCache = new ArrayList<T>();
    private int currentIndex = 0;
    private Iterator<T> wrappedIterator;

    public CachingIterator(Iterator<T> wrappedIterator) {
        this.wrappedIterator = wrappedIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.lookaheadCache.isEmpty()) {
            return this.wrappedIterator.hasNext();
        }
        return true;
    }

    @Override
    public T next() {
        T next = null;
        if (this.hasNext()) {
            if (!this.lookaheadCache.isEmpty()) {
                next = this.lookaheadCache.get(0);
                this.lookaheadCache.remove(0);
            } else {
                next = this.wrappedIterator.next();
            }
            ++this.currentIndex;
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSize(int size) {
        if (size <= this.currentIndex + this.lookaheadCache.size()) {
            return true;
        }
        int lookahead = size - this.currentIndex - this.lookaheadCache.size();
        while (lookahead > 0 && this.wrappedIterator.hasNext()) {
            this.lookaheadCache.add(this.wrappedIterator.next());
            --lookahead;
        }
        return lookahead == 0;
    }
}

