/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.views.components;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.providers.IPropertiesEditionPartProvider;
import org.eclipse.emf.eef.runtime.impl.components.StandardPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.impl.notify.PropertiesValidationEditionEvent;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesEditionPartProviderService;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.views.CustomView;
import org.eclipse.emf.eef.views.ViewsPackage;
import org.eclipse.emf.eef.views.parts.CustomViewPropertiesEditionPart;
import org.eclipse.emf.eef.views.parts.ViewsViewsRepository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CustomViewBasePropertiesEditionComponent
extends StandardPropertiesEditionComponent {
    public static String BASE_PART = "Base";
    private String[] parts = new String[]{BASE_PART};
    private CustomView customView;
    protected CustomViewPropertiesEditionPart basePart;

    public CustomViewBasePropertiesEditionComponent(EObject customView, String editing_mode) {
        if (customView instanceof CustomView) {
            this.customView = (CustomView)customView;
            if ("Live".equals(editing_mode)) {
                this.semanticAdapter = this.initializeSemanticAdapter();
                this.customView.eAdapters().add((Object)this.semanticAdapter);
            }
        }
        this.editing_mode = editing_mode;
    }

    private AdapterImpl initializeSemanticAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(final Notification msg) {
                if (CustomViewBasePropertiesEditionComponent.this.basePart == null) {
                    CustomViewBasePropertiesEditionComponent.this.dispose();
                } else {
                    Runnable updateRunnable = new Runnable(){

                        public void run() {
                            CustomViewBasePropertiesEditionComponent.this.runUpdateRunnable(msg);
                        }
                    };
                    if (Display.getCurrent() == null) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(updateRunnable);
                    } else {
                        updateRunnable.run();
                    }
                }
            }
        };
    }

    protected void runUpdateRunnable(Notification msg) {
        if (ViewsPackage.eINSTANCE.getViewElement_Name().equals(msg.getFeature()) && this.basePart != null) {
            if (msg.getNewValue() != null) {
                this.basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)msg.getNewValue()));
            } else {
                this.basePart.setName("");
            }
        }
    }

    public Class translatePart(String key) {
        if (BASE_PART.equals(key)) {
            return ViewsViewsRepository.CustomView.class;
        }
        return super.translatePart(key);
    }

    public String[] partsList() {
        return this.parts;
    }

    public IPropertiesEditionPart getPropertiesEditionPart(int kind, String key) {
        if (this.customView != null && BASE_PART.equals(key)) {
            IPropertiesEditionPartProvider provider;
            if (this.basePart == null && (provider = PropertiesEditionPartProviderService.getInstance().getProvider(ViewsViewsRepository.class)) != null) {
                this.basePart = (CustomViewPropertiesEditionPart)provider.getPropertiesEditionPart(ViewsViewsRepository.CustomView.class, kind, (IPropertiesEditionComponent)this);
                this.addListener((IPropertiesEditionListener)this.basePart);
            }
            return (IPropertiesEditionPart)this.basePart;
        }
        return null;
    }

    public void setPropertiesEditionPart(Class key, int kind, IPropertiesEditionPart propertiesEditionPart) {
        if (key == ViewsViewsRepository.CustomView.class) {
            this.basePart = (CustomViewPropertiesEditionPart)propertiesEditionPart;
        }
    }

    public void initPart(Class key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.basePart != null && key == ViewsViewsRepository.CustomView.class) {
            ((IPropertiesEditionPart)this.basePart).setContext(elt, allResource);
            CustomView customView = (CustomView)elt;
            if (customView.getName() != null) {
                this.basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)customView.getName()));
            }
        }
        this.setInitializing(false);
    }

    public CompoundCommand getPropertiesEditionCommand(EditingDomain editingDomain) {
        CompoundCommand cc = new CompoundCommand();
        if (this.customView != null && this.basePart != null) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.customView, (Object)ViewsPackage.eINSTANCE.getViewElement_Name(), (Object)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)this.basePart.getName())));
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        cc.append((Command)IdentityCommand.INSTANCE);
        return cc;
    }

    public EObject getPropertiesEditionObject(EObject source) {
        if (source instanceof CustomView) {
            CustomView customViewToUpdate = (CustomView)source;
            customViewToUpdate.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)this.basePart.getName()));
            return customViewToUpdate;
        }
        return null;
    }

    public void firePropertiesChanged(IPropertiesEditionEvent event) {
        if (!this.isInitializing()) {
            Diagnostic valueDiagnostic = this.validateValue(event);
            if (1 == event.getState() && "Live".equals(this.editing_mode) && valueDiagnostic.getSeverity() == 0) {
                CompoundCommand command = new CompoundCommand();
                if (ViewsViewsRepository.CustomView.name == event.getAffectedEditor()) {
                    command.append(SetCommand.create((EditingDomain)this.liveEditingDomain, (Object)this.customView, (Object)ViewsPackage.eINSTANCE.getViewElement_Name(), (Object)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)((String)event.getNewValue()))));
                }
                if (!command.isEmpty() && !command.canExecute()) {
                    EEFRuntimePlugin.getDefault().logError("Cannot perform model change command.", null);
                } else {
                    this.liveEditingDomain.getCommandStack().execute((Command)command);
                }
            }
            if (valueDiagnostic.getSeverity() != 0 && valueDiagnostic instanceof BasicDiagnostic) {
                super.firePropertiesChanged((IPropertiesEditionEvent)new PropertiesValidationEditionEvent(event, valueDiagnostic));
            } else {
                Diagnostic validate = this.validate();
                super.firePropertiesChanged((IPropertiesEditionEvent)new PropertiesValidationEditionEvent(event, validate));
            }
            super.firePropertiesChanged(event);
        }
    }

    public boolean isRequired(String key, int kind) {
        return key == ViewsViewsRepository.CustomView.name;
    }

    public String getHelpContent(String key, int kind) {
        if (key == ViewsViewsRepository.CustomView.name) {
            return "The element name";
        }
        return super.getHelpContent(key, kind);
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            String newStringValue = event.getNewValue().toString();
            try {
                if (ViewsViewsRepository.CustomView.name == event.getAffectedEditor()) {
                    Object newValue = EcoreUtil.createFromString((EDataType)ViewsPackage.eINSTANCE.getViewElement_Name().getEAttributeType(), (String)newStringValue);
                    ret = Diagnostician.INSTANCE.validate(ViewsPackage.eINSTANCE.getViewElement_Name().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }

    public Diagnostic validate() {
        Diagnostic validate = Diagnostic.OK_INSTANCE;
        if ("Batch".equals(this.editing_mode)) {
            EObject copy = EcoreUtil.copy((EObject)this.customView);
            copy = this.getPropertiesEditionObject(copy);
            validate = EEFRuntimePlugin.getEEFValidator().validate(copy);
        } else if ("Live".equals(this.editing_mode)) {
            validate = EEFRuntimePlugin.getEEFValidator().validate((EObject)this.customView);
        }
        return validate;
    }

    public void dispose() {
        if (this.semanticAdapter != null) {
            this.customView.eAdapters().remove((Object)this.semanticAdapter);
        }
    }

    public String getTabText(String p_key) {
        return this.basePart.getTitle();
    }
}

