/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.toolkits.components;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.providers.IPropertiesEditionPartProvider;
import org.eclipse.emf.eef.runtime.impl.components.StandardPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.impl.notify.PropertiesValidationEditionEvent;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesEditionPartProviderService;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.toolkits.Toolkit;
import org.eclipse.emf.eef.toolkits.ToolkitsPackage;
import org.eclipse.emf.eef.toolkits.parts.ToolkitPropertiesEditionPart;
import org.eclipse.emf.eef.toolkits.parts.ToolkitsViewsRepository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ToolkitPropertiesEditionComponent
extends StandardPropertiesEditionComponent {
    public static String BASE_PART = "Base";
    private String[] parts = new String[]{BASE_PART};
    private Toolkit toolkit;
    protected ToolkitPropertiesEditionPart basePart;

    public ToolkitPropertiesEditionComponent(EObject toolkit, String editing_mode) {
        if (toolkit instanceof Toolkit) {
            this.toolkit = (Toolkit)toolkit;
            if ("Live".equals(editing_mode)) {
                this.semanticAdapter = this.initializeSemanticAdapter();
                this.toolkit.eAdapters().add((Object)this.semanticAdapter);
            }
        }
        this.editing_mode = editing_mode;
    }

    private AdapterImpl initializeSemanticAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(final Notification msg) {
                if (ToolkitPropertiesEditionComponent.this.basePart == null) {
                    ToolkitPropertiesEditionComponent.this.dispose();
                } else {
                    Runnable updateRunnable = new Runnable(){

                        public void run() {
                            ToolkitPropertiesEditionComponent.this.runUpdateRunnable(msg);
                        }
                    };
                    if (Display.getCurrent() == null) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(updateRunnable);
                    } else {
                        updateRunnable.run();
                    }
                }
            }
        };
    }

    protected void runUpdateRunnable(Notification msg) {
        if (ToolkitsPackage.eINSTANCE.getToolkit_Name().equals(msg.getFeature()) && this.basePart != null) {
            if (msg.getNewValue() != null) {
                this.basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)msg.getNewValue()));
            } else {
                this.basePart.setName("");
            }
        }
    }

    public Class translatePart(String key) {
        if (BASE_PART.equals(key)) {
            return ToolkitsViewsRepository.Toolkit.class;
        }
        return super.translatePart(key);
    }

    public String[] partsList() {
        return this.parts;
    }

    public IPropertiesEditionPart getPropertiesEditionPart(int kind, String key) {
        if (this.toolkit != null && BASE_PART.equals(key)) {
            IPropertiesEditionPartProvider provider;
            if (this.basePart == null && (provider = PropertiesEditionPartProviderService.getInstance().getProvider(ToolkitsViewsRepository.class)) != null) {
                this.basePart = (ToolkitPropertiesEditionPart)provider.getPropertiesEditionPart(ToolkitsViewsRepository.Toolkit.class, kind, (IPropertiesEditionComponent)this);
                this.addListener((IPropertiesEditionListener)this.basePart);
            }
            return (IPropertiesEditionPart)this.basePart;
        }
        return null;
    }

    public void setPropertiesEditionPart(Class key, int kind, IPropertiesEditionPart propertiesEditionPart) {
        if (key == ToolkitsViewsRepository.Toolkit.class) {
            this.basePart = (ToolkitPropertiesEditionPart)propertiesEditionPart;
        }
    }

    public void initPart(Class key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.basePart != null && key == ToolkitsViewsRepository.Toolkit.class) {
            ((IPropertiesEditionPart)this.basePart).setContext(elt, allResource);
            Toolkit toolkit = (Toolkit)elt;
            if (toolkit.getName() != null) {
                this.basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)toolkit.getName()));
            }
        }
        this.setInitializing(false);
    }

    public CompoundCommand getPropertiesEditionCommand(EditingDomain editingDomain) {
        CompoundCommand cc = new CompoundCommand();
        if (this.toolkit != null && this.basePart != null) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.toolkit, (Object)ToolkitsPackage.eINSTANCE.getToolkit_Name(), (Object)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)this.basePart.getName())));
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        cc.append((Command)IdentityCommand.INSTANCE);
        return cc;
    }

    public EObject getPropertiesEditionObject(EObject source) {
        if (source instanceof Toolkit) {
            Toolkit toolkitToUpdate = (Toolkit)source;
            toolkitToUpdate.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)this.basePart.getName()));
            return toolkitToUpdate;
        }
        return null;
    }

    public void firePropertiesChanged(IPropertiesEditionEvent event) {
        if (!this.isInitializing()) {
            Diagnostic valueDiagnostic = this.validateValue(event);
            if (1 == event.getState() && "Live".equals(this.editing_mode) && valueDiagnostic.getSeverity() == 0) {
                CompoundCommand command = new CompoundCommand();
                if (ToolkitsViewsRepository.Toolkit.name == event.getAffectedEditor()) {
                    command.append(SetCommand.create((EditingDomain)this.liveEditingDomain, (Object)this.toolkit, (Object)ToolkitsPackage.eINSTANCE.getToolkit_Name(), (Object)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)((String)event.getNewValue()))));
                }
                if (!command.isEmpty() && !command.canExecute()) {
                    EEFRuntimePlugin.getDefault().logError("Cannot perform model change command.", null);
                } else {
                    this.liveEditingDomain.getCommandStack().execute((Command)command);
                }
            }
            if (valueDiagnostic.getSeverity() != 0 && valueDiagnostic instanceof BasicDiagnostic) {
                super.firePropertiesChanged((IPropertiesEditionEvent)new PropertiesValidationEditionEvent(event, valueDiagnostic));
            } else {
                Diagnostic validate = this.validate();
                super.firePropertiesChanged((IPropertiesEditionEvent)new PropertiesValidationEditionEvent(event, validate));
            }
            super.firePropertiesChanged(event);
        }
    }

    public boolean isRequired(String key, int kind) {
        return key == ToolkitsViewsRepository.Toolkit.name;
    }

    public String getHelpContent(String key, int kind) {
        if (key == ToolkitsViewsRepository.Toolkit.name) {
            return "The name of the toolkit";
        }
        return super.getHelpContent(key, kind);
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            String newStringValue = event.getNewValue().toString();
            try {
                if (ToolkitsViewsRepository.Toolkit.name == event.getAffectedEditor()) {
                    Object newValue = EcoreUtil.createFromString((EDataType)ToolkitsPackage.eINSTANCE.getToolkit_Name().getEAttributeType(), (String)newStringValue);
                    ret = Diagnostician.INSTANCE.validate(ToolkitsPackage.eINSTANCE.getToolkit_Name().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }

    public Diagnostic validate() {
        Diagnostic validate = Diagnostic.OK_INSTANCE;
        if ("Batch".equals(this.editing_mode)) {
            EObject copy = EcoreUtil.copy((EObject)this.toolkit);
            copy = this.getPropertiesEditionObject(copy);
            validate = EEFRuntimePlugin.getEEFValidator().validate(copy);
        } else if ("Live".equals(this.editing_mode)) {
            validate = EEFRuntimePlugin.getEEFValidator().validate((EObject)this.toolkit);
        }
        return validate;
    }

    public void dispose() {
        if (this.semanticAdapter != null) {
            this.toolkit.eAdapters().remove((Object)this.semanticAdapter);
        }
    }

    public String getTabText(String p_key) {
        return this.basePart.getTitle();
    }
}

