/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.jface.preference.IPreferenceStore;

public final class ResolutionUtil {
    private ResolutionUtil() {
    }

    public static CrossReferenceResolutionScope getResolutionScope() {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("org.eclipse.emf.compare.ide.ui.preference.disableResolving")) {
            return CrossReferenceResolutionScope.SELF;
        }
        String stringValue = store.getString("org.eclipse.emf.compare.ide.ui.preference.resolutionScope");
        return CrossReferenceResolutionScope.valueOf(stringValue);
    }

    public static boolean isInterruptedOrCanceled(IProgressMonitor monitor) {
        return Thread.currentThread().isInterrupted() || monitor.isCanceled();
    }

    public static IFile getFileAt(URI uri) {
        StringBuilder path = new StringBuilder();
        List segments = uri.segmentsList();
        if (uri.isPlatformResource()) {
            segments = segments.subList(1, segments.size());
        }
        for (String segment : segments) {
            path.append(URI.decode((String)segment)).append('/');
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path.toString()));
    }
}

