/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements;

import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.tests.framework.EMFCompareTestConfiguration;
import org.eclipse.emf.compare.ide.ui.tests.framework.ResolutionStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitTestSupport;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitCompare;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.AbstractGitStatement;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.internal.statements.InternalGitTestSupport;
import org.junit.runners.model.FrameworkMethod;

public class GitCompareStatement
extends AbstractGitStatement {
    private final String path;

    public GitCompareStatement(Object testObject, FrameworkMethod test, ResolutionStrategyID resolutionStrategy, EMFCompareTestConfiguration configuration, String path) {
        super(testObject, test, resolutionStrategy, configuration);
        this.path = this.normalizePath(path);
    }

    public void evaluate() throws Throwable {
        this.setEMFComparePreferences();
        GitCompare compare = (GitCompare)this.test.getAnnotation(GitCompare.class);
        String localBranch = InternalGitTestSupport.normalizeBranch(compare.local());
        String remoteBranch = InternalGitTestSupport.normalizeBranch(compare.remote());
        String fileToCompare = this.normalizePath(compare.file());
        String containerProject = compare.containerProject();
        GitTestSupport gitTestsSupport = new GitTestSupport();
        try {
            gitTestsSupport.setup();
            gitTestsSupport.createRepositoryFromPath(this.test.getMethod().getDeclaringClass(), this.path);
            Comparison comparison = gitTestsSupport.compare(localBranch, remoteBranch, fileToCompare, containerProject);
            Class<?>[] parameters = this.test.getMethod().getParameterTypes();
            if (parameters[parameters.length - 1].getName().equals(GitTestSupport.class.getName())) {
                this.test.invokeExplosively(this.testObject, new Object[]{comparison, gitTestsSupport});
            } else {
                this.test.invokeExplosively(this.testObject, new Object[]{comparison});
            }
        }
        finally {
            this.restoreEMFComparePreferences();
            gitTestsSupport.tearDown();
        }
    }
}

