/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class FeatureMapsConflictsMergeTest {
    private IndividualDiffInputData input = new IndividualDiffInputData();
    private final BatchMerger batchMerger = new BatchMerger(IMerger.RegistryImpl.createStandaloneInstance());

    @Test
    public void testConflictContainmentLeftAddRightAddWithSameKey_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftAddRightAddWithSameKeyScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftAddRightAddWithSameKeyScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftAddRightAddWithSameKeyScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EObject leftMapNode2 = this.getNodeNamed(left, "mapNode2");
        Assert.assertNotNull((Object)leftMapNode2);
        Object leftMapNode2FirstKey = leftMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode2FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode2FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode2FirstKey).get(0));
        EObject rightMapNode2 = this.getNodeNamed(right, "mapNode2");
        Assert.assertNotNull((Object)rightMapNode2);
        Object rightMapNode2FirstKey = rightMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode2FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode2FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode2FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        Object leftMapNode2Map = leftMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode2Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode2Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode2Map).get(eSFFirstKey, 0, true));
        Object rightMapNode2Map = rightMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode2Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode2Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode2Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftAddRightAddWithSameKey_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftAddRightAddWithSameKeyScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftAddRightAddWithSameKeyScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftAddRightAddWithSameKeyScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EObject leftMapNode2 = this.getNodeNamed(left, "mapNode2");
        Assert.assertNotNull((Object)leftMapNode2);
        Object leftMapNode2FirstKey = leftMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode2FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode2FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode2FirstKey).get(0));
        EObject rightMapNode2 = this.getNodeNamed(right, "mapNode2");
        Assert.assertNotNull((Object)rightMapNode2);
        Object rightMapNode2FirstKey = rightMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode2FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode2FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode2FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        Object leftMapNode2Map = leftMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode2Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode2Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode2Map).get(eSFFirstKey, 0, true));
        Object rightMapNode2Map = rightMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode2Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode2Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode2Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftAddRightAddWithSameKey_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftAddRightAddWithSameKeyScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftAddRightAddWithSameKeyScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftAddRightAddWithSameKeyScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EObject leftMapNode2 = this.getNodeNamed(left, "mapNode2");
        Assert.assertNotNull((Object)leftMapNode2);
        Object leftMapNode2FirstKey = leftMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode2FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode2FirstKey).isEmpty());
        EObject rightMapNode2 = this.getNodeNamed(right, "mapNode2");
        Assert.assertNotNull((Object)rightMapNode2);
        Object rightMapNode2FirstKey = rightMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode2FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode2FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        Object leftMapNode2Map = leftMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode2Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode2Map).isEmpty());
        Object rightMapNode2Map = rightMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode2Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode2Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftAddRightAddWithSameKey_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftAddRightAddWithSameKeyScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftAddRightAddWithSameKeyScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftAddRightAddWithSameKeyScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EObject leftMapNode2 = this.getNodeNamed(left, "mapNode2");
        Assert.assertNotNull((Object)leftMapNode2);
        Object leftMapNode2FirstKey = leftMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode2FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode2FirstKey).isEmpty());
        EObject rightMapNode2 = this.getNodeNamed(right, "mapNode2");
        Assert.assertNotNull((Object)rightMapNode2);
        Object rightMapNode2FirstKey = rightMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode2FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode2FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        Object leftMapNode2Map = leftMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode2Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode2Map).isEmpty());
        Object rightMapNode2Map = rightMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode2Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode2Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftAddRightAddWithDifferentKey_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftAddRightAddWithDifferentKeyScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftAddRightAddWithDifferentKeyScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftAddRightAddWithDifferentKeyScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftAddRightAddWithDifferentKey_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftAddRightAddWithDifferentKeyScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftAddRightAddWithDifferentKeyScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftAddRightAddWithDifferentKeyScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftAddRightAddWithDifferentKey_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftAddRightAddWithDifferentKeyScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftAddRightAddWithDifferentKeyScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftAddRightAddWithDifferentKeyScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFSecondKey = leftMapNode1.eClass().getEStructuralFeature("secondKey");
        Object leftMapNode1SecondKey = leftMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(leftMapNode1SecondKey instanceof List));
        Assert.assertTrue((boolean)((List)leftMapNode1SecondKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1SecondKey = rightMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(rightMapNode1SecondKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1SecondKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1SecondKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFSecondKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftAddRightAddWithDifferentKey_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftAddRightAddWithDifferentKeyScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftAddRightAddWithDifferentKeyScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftAddRightAddWithDifferentKeyScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFSecondKey = leftMapNode1.eClass().getEStructuralFeature("secondKey");
        Object leftMapNode1SecondKey = leftMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(leftMapNode1SecondKey instanceof List));
        Assert.assertTrue((boolean)((List)leftMapNode1SecondKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1SecondKey = rightMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(rightMapNode1SecondKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode1SecondKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1SecondKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFSecondKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftKeyChangeRightDelete_Left_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftKeyChangeRightDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftKeyChangeRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftKeyChangeRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFSecondKey = leftMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object leftMapNode1SecondKey = leftMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(leftMapNode1SecondKey instanceof List));
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1SecondKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1SecondKey = rightMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(rightMapNode1SecondKey instanceof List));
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1SecondKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFSecondKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFSecondKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftKeyChangeRightDelete_Right_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftKeyChangeRightDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftKeyChangeRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftKeyChangeRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFSecondKey = leftMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object leftMapNode1SecondKey = leftMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(leftMapNode1SecondKey instanceof List));
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1SecondKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFSecondKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftKeyChangeRightDelete_Left_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftKeyChangeRightDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftKeyChangeRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftKeyChangeRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFSecondKey = leftMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object leftMapNode1SecondKey = leftMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(leftMapNode1SecondKey instanceof List));
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1SecondKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1SecondKey = rightMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(rightMapNode1SecondKey instanceof List));
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1SecondKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFSecondKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFSecondKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftKeyChangeRightDelete_Right_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftKeyChangeRightDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftKeyChangeRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftKeyChangeRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFSecondKey = leftMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object leftMapNode1SecondKey = leftMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(leftMapNode1SecondKey instanceof List));
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1SecondKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFSecondKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftKeyChangeRightDelete_Left_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftKeyChangeRightDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftKeyChangeRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftKeyChangeRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftKeyChangeRightDelete_Right_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftKeyChangeRightDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftKeyChangeRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftKeyChangeRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftKeyChangeRightDelete_Left_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftKeyChangeRightDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftKeyChangeRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftKeyChangeRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftKeyChangeRightDelete_Right_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftKeyChangeRightDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftKeyChangeRightDeleteScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftKeyChangeRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)leftMapNode1FirstKey).isEmpty());
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)rightMapNode1FirstKey).isEmpty());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)leftMapNode1Map).isEmpty());
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)rightMapNode1Map).isEmpty());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmenLeftMoveRightMove_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftMoveRightMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftMoveRightMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftMoveRightMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode2 = this.getNodeNamed(left, "mapNode2");
        Assert.assertNotNull((Object)leftMapNode2);
        EStructuralFeature eSFFirstKey = leftMapNode2.eClass().getEStructuralFeature("firstKey");
        Object leftMapNode2FirstKey = leftMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode2FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode2FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode2FirstKey).get(0));
        EObject rightMapNode2 = this.getNodeNamed(right, "mapNode2");
        Assert.assertNotNull((Object)rightMapNode2);
        Object rightMapNode2FirstKey = rightMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode2FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode2FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode2FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode2.eClass().getEStructuralFeature("map");
        Object leftMapNode2Map = leftMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode2Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode2Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode2Map).get(eSFFirstKey, 0, true));
        Object rightMapNode2Map = rightMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode2Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode2Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode2Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmenLeftMoveRightMove_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftMoveRightMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftMoveRightMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftMoveRightMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode2 = this.getNodeNamed(left, "mapNode2");
        Assert.assertNotNull((Object)leftMapNode2);
        EStructuralFeature eSFFirstKey = leftMapNode2.eClass().getEStructuralFeature("firstKey");
        Object leftMapNode2FirstKey = leftMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode2FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode2FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode2FirstKey).get(0));
        EObject rightMapNode2 = this.getNodeNamed(right, "mapNode2");
        Assert.assertNotNull((Object)rightMapNode2);
        Object rightMapNode2FirstKey = rightMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode2FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode2FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode2FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode2.eClass().getEStructuralFeature("map");
        Object leftMapNode2Map = leftMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode2Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode2Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode2Map).get(eSFFirstKey, 0, true));
        Object rightMapNode2Map = rightMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode2Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode2Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode2Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmenLeftMoveRightMove_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftMoveRightMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftMoveRightMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftMoveRightMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode3 = this.getNodeNamed(left, "mapNode3");
        Assert.assertNotNull((Object)leftMapNode3);
        EStructuralFeature eSFFirstKey = leftMapNode3.eClass().getEStructuralFeature("firstKey");
        Object leftMapNode3FirstKey = leftMapNode3.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode3FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode3FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode3FirstKey).get(0));
        EObject rightMapNode3 = this.getNodeNamed(right, "mapNode3");
        Assert.assertNotNull((Object)rightMapNode3);
        Object rightMapNode3FirstKey = rightMapNode3.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode3FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode3FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode3FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode3.eClass().getEStructuralFeature("map");
        Object leftMapNode3Map = leftMapNode3.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode3Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode3Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode3Map).get(eSFFirstKey, 0, true));
        Object rightMapNode3Map = rightMapNode3.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode3Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode3Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode3Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmenLeftMoveRightMove_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftMoveRightMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftMoveRightMoveScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftMoveRightMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode3 = this.getNodeNamed(left, "mapNode3");
        Assert.assertNotNull((Object)leftMapNode3);
        EStructuralFeature eSFFirstKey = leftMapNode3.eClass().getEStructuralFeature("firstKey");
        Object leftMapNode3FirstKey = leftMapNode3.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode3FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftMapNode3FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode3FirstKey).get(0));
        EObject rightMapNode3 = this.getNodeNamed(right, "mapNode3");
        Assert.assertNotNull((Object)rightMapNode3);
        Object rightMapNode3FirstKey = rightMapNode3.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode3FirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightMapNode3FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode3FirstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode3.eClass().getEStructuralFeature("map");
        Object leftMapNode3Map = leftMapNode3.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode3Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMapNode3Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode3Map).get(eSFFirstKey, 0, true));
        Object rightMapNode3Map = rightMapNode3.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode3Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMapNode3Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode3Map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftMoveOrderRightMoveOrder_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftMoveOrderRightMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftMoveOrderRightMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftMoveOrderRightMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftMoveOrderRightMoveOrder_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftMoveOrderRightMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftMoveOrderRightMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftMoveOrderRightMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftMoveOrderRightMoveOrder_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftMoveOrderRightMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftMoveOrderRightMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftMoveOrderRightMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(2));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 2, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictContainmentLeftMoveOrderRightMoveOrder_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftConflictLeftMoveOrderRightMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightConflictLeftMoveOrderRightMoveOrderScope();
        Resource origin = this.input.getFeatureMapContainmentOriginConflictLeftMoveOrderRightMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(2));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 2, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentLeftMoveOrderRightMoveOrder_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentLeftMoveOrderRightMoveOrder_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(1));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 1, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)4L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentLeftMoveOrderRightMoveOrder_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(ReferenceChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(2));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 2, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testConflictNonContainmentLeftMoveOrderRightMoveOrder_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        Resource origin = this.input.getFeatureMapNonContainmentOriginConflictLeftMoveOrderRightMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.instanceOf(FeatureMapChange.class)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftMapNode1FirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)leftMapNode1FirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftMapNode1FirstKey).get(0));
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        Object rightMapNode1FirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightMapNode1FirstKey instanceof List));
        Assert.assertEquals((long)3L, (long)((List)rightMapNode1FirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightMapNode1FirstKey).get(2));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMapNode1Map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)leftMapNode1Map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMapNode1Map).get(eSFFirstKey, 0, true));
        Object rightMapNode1Map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMapNode1Map instanceof BasicFeatureMap));
        Assert.assertEquals((long)3L, (long)((BasicFeatureMap)rightMapNode1Map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMapNode1Map).get(eSFFirstKey, 2, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    private EObject getNodeNamed(Resource res, String name) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)res, (boolean)false);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }
}

