/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.conflict.data.ConflictInputData;
import org.eclipse.emf.compare.tests.equi.data.EquiInputData;
import org.eclipse.emf.compare.tests.fullcomparison.data.identifier.IdentifierMatchInputData;
import org.eclipse.emf.compare.tests.merge.data.TwoWayMergeInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.junit.Test;

public class MultipleMergeTest {
    private ConflictInputData conflictInput = new ConflictInputData();
    private EquiInputData equivalenceInput = new EquiInputData();
    private TwoWayMergeInputData twoWayInput = new TwoWayMergeInputData();
    private BatchMerger batchMerger = new BatchMerger(IMerger.RegistryImpl.createStandaloneInstance());

    @Test
    public void testComplexUseCaseLtoR1() throws IOException {
        Resource left = this.conflictInput.getComplexLeft();
        Resource origin = this.conflictInput.getComplexOrigin();
        Resource right = this.conflictInput.getComplexRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        ReferenceChange rightAdOfNode9 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.added((String)"Root.Node9")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(rightAdOfNode9), (Monitor)new BasicMonitor());
        ReferenceChange rightMoveOfNode1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.moved((String)"Root.Node1", (String)"containmentRef1")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(rightMoveOfNode1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(rightMoveOfNode1, false, 1);
        ReferenceChange rightAddOfNode0 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.added((String)"Root.Node0")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(rightAddOfNode0), (Monitor)new BasicMonitor());
        ReferenceChange rightMoveOfNode6 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.moved((String)"Root.Node6", (String)"containmentRef1")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(rightMoveOfNode6), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(rightMoveOfNode6, false, 4);
        ReferenceChange rightDeleteOfNode5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.removed((String)"Root.Node5")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(rightDeleteOfNode5), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(rightDeleteOfNode5, false, -1);
        ReferenceChange leftAddOfNode8 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.added((String)"Root.Node8")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(leftAddOfNode8), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftAddOfNode8, false, 1);
        ReferenceChange leftAddOfNode9 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.added((String)"Root.Node9")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(leftAddOfNode9), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftAddOfNode9, false, 2);
        ReferenceChange leftMoveOfNode1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.moved((String)"Root.Node1", (String)"containmentRef1")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(leftMoveOfNode1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftMoveOfNode1, false, 5);
        ReferenceChange leftAddOfNode0 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.added((String)"Root.Node0")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(leftAddOfNode0), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftAddOfNode0, false, 6);
        ReferenceChange leftDeleteOfNode5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"Root.Node5")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(leftDeleteOfNode5), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftDeleteOfNode5, false, -1);
        ReferenceChange leftDeleteOfNode6 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"Root.Node6")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(leftDeleteOfNode6), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftDeleteOfNode6, false, -1);
        ReferenceChange diff7 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"Root.Node7")));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff7), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(diff7, false, -1);
        EObject leftContainer = diff7.getMatch().getLeft();
        EObject rightContainer = diff7.getMatch().getRight();
        List<EObject> leftContents = MultipleMergeTest.getAsList(leftContainer, diff7.getReference());
        List<EObject> rightContents = MultipleMergeTest.getAsList(rightContainer, diff7.getReference());
        MultipleMergeTest.assertEqualContents(comparison, leftContents, rightContents);
    }

    @Test
    public void testComplexUseCaseRtoL1() throws IOException {
        Resource left = this.conflictInput.getComplexLeft();
        Resource origin = this.conflictInput.getComplexOrigin();
        Resource right = this.conflictInput.getComplexRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        ReferenceChange leftDeleteOfNode6 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"Root.Node6")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(leftDeleteOfNode6), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftDeleteOfNode6, true, 5);
        ReferenceChange leftAddOfNode9 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.added((String)"Root.Node9")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(leftAddOfNode9), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftAddOfNode9, true, -1);
        ReferenceChange leftDeleteOfNode5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"Root.Node5")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(leftDeleteOfNode5), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftDeleteOfNode5, true, -1);
        ReferenceChange leftAddOfNode0 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.added((String)"Root.Node0")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(leftAddOfNode0), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftAddOfNode0, true, -1);
        ReferenceChange leftMoveOfNode1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.moved((String)"Root.Node1", (String)"containmentRef1")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(leftMoveOfNode1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftMoveOfNode1, true, 1);
        ReferenceChange rightMoveOfNode6 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.moved((String)"Root.Node6", (String)"containmentRef1")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(rightMoveOfNode6), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(rightMoveOfNode6, true, 2);
        ReferenceChange rightAddOfNode9 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.added((String)"Root.Node9")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(rightAddOfNode9), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(rightAddOfNode9, true, 4);
        ReferenceChange rightAddOfNode0 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.added((String)"Root.Node0")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(rightAddOfNode0), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(rightAddOfNode0, true, 6);
        ReferenceChange rightMoveOfNode1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.moved((String)"Root.Node1", (String)"containmentRef1")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(rightMoveOfNode1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(rightMoveOfNode1, true, 6);
        ReferenceChange rightDeleteOfNode5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.removed((String)"Root.Node5")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(rightDeleteOfNode5), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(rightDeleteOfNode5, true, -1);
        ReferenceChange leftAddOfNode8 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.added((String)"Root.Node8")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(leftAddOfNode8), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftAddOfNode8, false, -1);
        ReferenceChange leftDeleteOfNode7 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.removed((String)"Root.Node7")));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(leftDeleteOfNode7), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertValueIndexIs(leftDeleteOfNode7, false, 7);
        EObject leftContainer = leftDeleteOfNode7.getMatch().getLeft();
        EObject rightContainer = leftDeleteOfNode7.getMatch().getRight();
        List<EObject> leftContents = MultipleMergeTest.getAsList(leftContainer, leftDeleteOfNode7.getReference());
        List<EObject> rightContents = MultipleMergeTest.getAsList(rightContainer, leftDeleteOfNode7.getReference());
        MultipleMergeTest.assertEqualContents(comparison, leftContents, rightContents);
    }

    @Test
    public void testEquivalenceA1LtoR() throws IOException {
        Resource left = this.equivalenceInput.getA1Left();
        Resource right = this.equivalenceInput.getA1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", null, (String)"Requirements.B"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", null, (String)"Requirements.A"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D"));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.D", (String)"source", null, (String)"Requirements.C"));
        ReferenceChange diff5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F"));
        ReferenceChange diff6 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.F", (String)"source", (String)"Requirements.E"));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff1, false, false);
        MultipleMergeTest.assertMerged(comparison, diff2, false, false);
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff3), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff3, false, false);
        MultipleMergeTest.assertMerged(comparison, diff4, false, false);
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff5), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff5, false, false);
        MultipleMergeTest.assertMerged(comparison, diff6, false, false);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceA1RtoL() throws IOException {
        Resource left = this.equivalenceInput.getA1Left();
        Resource right = this.equivalenceInput.getA1Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", null, (String)"Requirements.B"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", null, (String)"Requirements.A"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D"));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.D", (String)"source", null, (String)"Requirements.C"));
        ReferenceChange diff5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F"));
        ReferenceChange diff6 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.F", (String)"source", (String)"Requirements.E"));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertDiscarded(comparison, diff1, true, true);
        MultipleMergeTest.assertDiscarded(comparison, diff2, true, true);
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff3), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertDiscarded(comparison, diff3, true, true);
        MultipleMergeTest.assertDiscarded(comparison, diff4, true, true);
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff5), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertDiscarded(comparison, diff5, true, true);
        MultipleMergeTest.assertDiscarded(comparison, diff6, true, true);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceA4LtoR() throws IOException {
        Resource left = this.equivalenceInput.getA4Left();
        Resource right = this.equivalenceInput.getA4Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.B", (String)"source", (String)"Requirements.A"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.B", (String)"destination", (String)"Requirements.A"));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"source", (String)"Requirements.B"));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff1, false, false);
        MultipleMergeTest.assertMerged(comparison, diff2, false, false);
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff3), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff3, false, false);
        MultipleMergeTest.assertMerged(comparison, diff4, false, false);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceA4RtoL() throws IOException {
        Resource left = this.equivalenceInput.getA4Left();
        Resource right = this.equivalenceInput.getA4Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.B", (String)"source", (String)"Requirements.A"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.B", (String)"destination", (String)"Requirements.A"));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.A", (String)"source", (String)"Requirements.B"));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertDiscarded(comparison, diff1, true, true);
        MultipleMergeTest.assertDiscarded(comparison, diff2, true, true);
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff3), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertDiscarded(comparison, diff3, true, true);
        MultipleMergeTest.assertDiscarded(comparison, diff4, true, true);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceA5LtoR() throws IOException {
        Resource left = this.equivalenceInput.getA5Left();
        Resource right = this.equivalenceInput.getA5Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)12L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", null, (String)"Requirements.B"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", null, (String)"Requirements.A"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D"));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.D", (String)"source", null, (String)"Requirements.C"));
        ReferenceChange diff5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F"));
        ReferenceChange diff6 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.F", (String)"source", (String)"Requirements.E"));
        ReferenceChange diff7 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.A"));
        ReferenceChange diff8 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B"));
        ReferenceChange diff9 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C"));
        ReferenceChange diff10 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.D"));
        ReferenceChange diff11 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.E"));
        ReferenceChange diff12 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.F"));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff1, false, false);
        MultipleMergeTest.assertMerged(comparison, diff2, false, false);
        Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff7.getState());
        Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff8.getState());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff3), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff3, false, false);
        MultipleMergeTest.assertMerged(comparison, diff4, false, false);
        Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff9.getState());
        Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff10.getState());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff5), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff5, false, false);
        MultipleMergeTest.assertMerged(comparison, diff6, false, false);
        Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff11.getState());
        Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff12.getState());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceA5RtoL() throws IOException {
        Resource left = this.equivalenceInput.getA5Left();
        Resource right = this.equivalenceInput.getA5Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)12L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", null, (String)"Requirements.B"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", null, (String)"Requirements.A"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.C", (String)"destination", (String)"Requirements.D"));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.D", (String)"source", null, (String)"Requirements.C"));
        ReferenceChange diff5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.E", (String)"destination", (String)"Requirements.F"));
        ReferenceChange diff6 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements.F", (String)"source", (String)"Requirements.E"));
        ReferenceChange diff7 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.A"));
        ReferenceChange diff8 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B"));
        ReferenceChange diff9 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C"));
        ReferenceChange diff10 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.D"));
        ReferenceChange diff11 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.E"));
        ReferenceChange diff12 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.F"));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertDiscarded(comparison, diff1, true, true);
        MultipleMergeTest.assertDiscarded(comparison, diff2, true, true);
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff7.getState());
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff8.getState());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff3), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertDiscarded(comparison, diff3, true, true);
        MultipleMergeTest.assertDiscarded(comparison, diff4, true, true);
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff9.getState());
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff10.getState());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff5), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertDiscarded(comparison, diff5, true, true);
        MultipleMergeTest.assertDiscarded(comparison, diff6, true, true);
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff11.getState());
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff12.getState());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff7), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff8), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff9), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff10), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff11), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff12), (Monitor)new BasicMonitor());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC2LtoR1() throws IOException {
        Resource left = this.equivalenceInput.getC2Left();
        Resource right = this.equivalenceInput.getC2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", (String)"Requirements.C"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", null, (String)"Requirements.A"));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff2), (Monitor)new BasicMonitor());
        Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff1.getState());
        MultipleMergeTest.assertMerged(comparison, diff2, false, false);
        MultipleMergeTest.assertMerged(comparison, diff3, true, false);
        MultipleMergeTest.assertMerged(comparison, diff4, false, false);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC2LtoR2() throws IOException {
        Resource left = this.equivalenceInput.getC2Left();
        Resource right = this.equivalenceInput.getC2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", (String)"Requirements.C"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", null, (String)"Requirements.A"));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff1.getState());
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff2.getState());
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff3.getState());
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff4.getState());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff2), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff2, false, false);
        MultipleMergeTest.assertMerged(comparison, diff3, true, false);
        MultipleMergeTest.assertMerged(comparison, diff4, false, false);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC2RtoL() throws IOException {
        Resource left = this.equivalenceInput.getC2Left();
        Resource right = this.equivalenceInput.getC2Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", (String)"Requirements.C"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", null, (String)"Requirements.A"));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff2), (Monitor)new BasicMonitor());
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff1.getState());
        MultipleMergeTest.assertDiscarded(comparison, diff3, false, true);
        MultipleMergeTest.assertDiscarded(comparison, diff4, true, true);
        EObject nodeA = diff2.getMatch().getLeft();
        EObject nodeB = diff3.getMatch().getLeft();
        Assert.assertEquals((Object)"A", (Object)nodeA.eGet(nodeA.eClass().getEStructuralFeature("name")));
        Assert.assertEquals((Object)"B", (Object)nodeB.eGet(nodeB.eClass().getEStructuralFeature("name")));
        Assert.assertSame((Object)nodeB, (Object)nodeA.eGet((EStructuralFeature)diff2.getReference()));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC4LtoR() throws IOException {
        Resource left = this.equivalenceInput.getC4Left();
        Resource right = this.equivalenceInput.getC4Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)5L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", (String)"Requirements.C"));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null));
        ReferenceChange diff5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", null, (String)"Requirements.A"));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff1, false, false);
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff2.getState());
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff3.getState());
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff4.getState());
        Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff5.getState());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff2), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertMerged(comparison, diff2, true, false);
        MultipleMergeTest.assertMerged(comparison, diff3, false, false);
        Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff4.getState());
        Assert.assertNull((Object)diff4.getMatch().getLeft());
        Assert.assertNull((Object)diff4.getMatch().getRight());
        MultipleMergeTest.assertMerged(comparison, diff5, false, false);
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC4RtoL() throws IOException {
        Resource left = this.equivalenceInput.getC4Left();
        Resource right = this.equivalenceInput.getC4Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)5L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.C"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.removedFromReference((String)"Requirements", (String)"containmentRef1", (String)"Requirements.B"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.A", (String)"destination", (String)"Requirements.B", (String)"Requirements.C"));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.B", (String)"source", (String)"Requirements.A", null));
        ReferenceChange diff5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Requirements.C", (String)"source", null, (String)"Requirements.A"));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        MultipleMergeTest.assertDiscarded(comparison, diff1, true, true);
        MultipleMergeTest.assertDiscarded(comparison, diff2, false, true);
        Assert.assertSame((Object)DifferenceState.DISCARDED, (Object)diff3.getState());
        EObject nodeA = diff3.getMatch().getLeft();
        EObject nodeB = diff4.getMatch().getLeft();
        Assert.assertSame((Object)nodeB, (Object)nodeA.eGet((EStructuralFeature)diff3.getReference()));
        MultipleMergeTest.assertDiscarded(comparison, diff4, false, true);
        Assert.assertSame((Object)DifferenceState.DISCARDED, (Object)diff5.getState());
        Assert.assertNull((Object)diff5.getMatch().getLeft());
        Assert.assertNull((Object)diff5.getMatch().getRight());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC5LtoR() throws IOException {
        Resource left = this.equivalenceInput.getC5Left();
        Resource right = this.equivalenceInput.getC5Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)5L, (long)differences.size());
        ReferenceChange diff1 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Root.Node1", (String)"source", (String)"Root.Node4", (String)"Root.Node3"));
        ReferenceChange diff2 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Root.Node3", (String)"destination", null, (String)"Root.Node1"));
        ReferenceChange diff3 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Root.Node4", (String)"destination", (String)"Root.Node1", null));
        ReferenceChange diff4 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.added((String)"Root.Node3"));
        ReferenceChange diff5 = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.removed((String)"Root.Node4"));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff3), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff1), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff2), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff4), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff5), (Monitor)new BasicMonitor());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC5RtoL() throws IOException {
        Resource left = this.equivalenceInput.getC5Left();
        Resource right = this.equivalenceInput.getC5Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        ReferenceChange unsetDiff = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Root.Node4", (String)"destination", null, (String)"Root.Node1"));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(unsetDiff), (Monitor)new BasicMonitor());
        for (Diff diff : differences) {
            if (diff == unsetDiff) continue;
            this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC6LtoR() throws IOException {
        Resource left = this.equivalenceInput.getC6Left();
        Resource right = this.equivalenceInput.getC6Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        ReferenceChange unsetDiff = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Root.Node4", (String)"destination", (String)"Root.Node1", null));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(unsetDiff), (Monitor)new BasicMonitor());
        for (Diff diff : differences) {
            if (diff == unsetDiff) continue;
            this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC6RtoL() throws IOException {
        Resource left = this.equivalenceInput.getC6Left();
        Resource right = this.equivalenceInput.getC6Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        ReferenceChange unsetDiff = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Root.Node4", (String)"destination", null, (String)"Root.Node1"));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(unsetDiff), (Monitor)new BasicMonitor());
        for (Diff diff : differences) {
            if (diff == unsetDiff) continue;
            this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testOneToOneRefMergeL2R() throws IOException {
        Resource left = this.twoWayInput.getOneToOneMergeL2RLeft();
        Resource right = this.twoWayInput.getOneToOneRefMergeL2RRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        ReferenceChange setCSourceDiff = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Root.c", (String)"source", (String)"Root.d", (String)"Root.c"));
        ReferenceChange setDSourceDiff = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Root.d", (String)"source", (String)"Root.c", null));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(setCSourceDiff), (Monitor)new BasicMonitor());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)setDSourceDiff.getState());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testOneToOneRefMergeR2L() throws IOException {
        Resource left = this.twoWayInput.getOneToOneMergeR2LLeft();
        Resource right = this.twoWayInput.getOneToOneRefMergeR2LRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        ReferenceChange setCSourceDiff = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Root.c", (String)"source", (String)"Root.c", (String)"Root.d"));
        ReferenceChange setDSourceDiff = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.changedReference((String)"Root.d", (String)"source", null, (String)"Root.c"));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(setCSourceDiff), (Monitor)new BasicMonitor());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)setDSourceDiff.getState());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC7LtoR() throws IOException {
        Resource left = this.equivalenceInput.getC7Left();
        Resource right = this.equivalenceInput.getC7Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        ReferenceChange deleteDiff = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.removedFromReference((String)"Root.a", (String)"destination", (String)"Root.a"));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(deleteDiff), (Monitor)new BasicMonitor());
        for (Diff diff : differences) {
            if (diff == deleteDiff) continue;
            this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testEquivalenceC7RtoL() throws IOException {
        Resource left = this.equivalenceInput.getC7Left();
        Resource right = this.equivalenceInput.getC7Right();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        ReferenceChange deleteDiff = (ReferenceChange)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.addedToReference((String)"Root.b", (String)"destination", (String)"Root.a"));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(deleteDiff), (Monitor)new BasicMonitor());
        for (Diff diff : differences) {
            if (diff == deleteDiff) continue;
            this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testFeatureMapDependencyL2R() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.twoWayInput.getFeatureMapDependencyL2RLeft((ResourceSet)resourceSet);
        Resource right = this.twoWayInput.getFeatureMapDependencyL2RRight((ResourceSet)resourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)comparison.getDifferences().size());
        FeatureMapChange addFirstKey = (FeatureMapChange)Iterators.find(differences.iterator(), (Predicate)Predicates.instanceOf(FeatureMapChange.class));
        Assert.assertNotNull((Object)addFirstKey);
        this.batchMerger.copyAllLeftToRight(Arrays.asList(addFirstKey), (Monitor)new BasicMonitor());
        for (Diff diff : differences) {
            if (diff == addFirstKey) continue;
            this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testRemoveFeatureMapR2L() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.twoWayInput.getRemoveFeatureMapR2LLeft((ResourceSet)resourceSet);
        Resource right = this.twoWayInput.getRemoveFeatureMapR2LRight((ResourceSet)resourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)5L, (long)comparison.getDifferences().size());
        UnmodifiableIterator featureMapChangesIt = Iterators.filter(differences.iterator(), (Predicate)Predicates.instanceOf(FeatureMapChange.class));
        ArrayList featureMapChanges = Lists.newArrayList((Iterator)featureMapChangesIt);
        Assert.assertEquals((long)2L, (long)featureMapChanges.size());
        for (Diff diff : featureMapChanges) {
            this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
        for (Diff diff : differences) {
            if (featureMapChanges.contains(diff)) continue;
            this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void testMergeAllDiffsTwice() throws IOException {
        IdentifierMatchInputData inputData = new IdentifierMatchInputData();
        Resource left = inputData.getExtlibraryLeft();
        Resource origin = inputData.getExtlibraryOrigin();
        Resource right = inputData.getExtlibraryRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertFalse((boolean)differences.isEmpty());
        for (Diff diff : differences) {
            ComparisonUtil.getSubDiffs((boolean)true).apply((Object)diff);
            this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
            ComparisonUtil.getSubDiffs((boolean)true).apply((Object)diff);
            this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
    }

    private static <T extends EObject> void assertEqualContents(Comparison comparison, List<T> list1, List<T> list2) {
        int size = list1.size();
        Assert.assertEquals((long)size, (long)list2.size());
        int i = 0;
        while (i < size) {
            EObject eObject1 = (EObject)list1.get(i);
            EObject eObject2 = (EObject)list2.get(i);
            Match match = comparison.getMatch(eObject1);
            if (match.getLeft() == eObject1) {
                Assert.assertEquals((Object)match.getRight(), (Object)eObject2);
            } else {
                Assert.assertEquals((Object)match.getRight(), (Object)eObject1);
                Assert.assertEquals((Object)match.getLeft(), (Object)eObject2);
            }
            ++i;
        }
    }

    private static void assertMerged(Comparison comparison, ReferenceChange referenceChange, boolean unset, boolean rightToLeft) {
        Assert.assertSame((Object)referenceChange.getState(), (Object)DifferenceState.MERGED);
        MultipleMergeTest.checkFinalState(comparison, referenceChange, unset, rightToLeft);
    }

    private static void assertDiscarded(Comparison comparison, ReferenceChange referenceChange, boolean unset, boolean rightToLeft) {
        Assert.assertSame((Object)referenceChange.getState(), (Object)DifferenceState.DISCARDED);
        MultipleMergeTest.checkFinalState(comparison, referenceChange, unset, rightToLeft);
    }

    private static void checkFinalState(Comparison comparison, ReferenceChange referenceChange, boolean unset, boolean rightToLeft) {
        EObject container = rightToLeft ? referenceChange.getMatch().getLeft() : referenceChange.getMatch().getRight();
        EReference ref = referenceChange.getReference();
        Match valueMatch = comparison.getMatch(referenceChange.getValue());
        if (unset && ref.isContainment()) {
            Assert.assertNull((Object)valueMatch);
        } else if (ref.isMany()) {
            List refValue = (List)container.eGet((EStructuralFeature)ref);
            if (rightToLeft && unset) {
                Assert.assertTrue((!refValue.contains(valueMatch.getLeft()) ? 1 : 0) != 0);
            } else if (rightToLeft) {
                Assert.assertTrue((boolean)refValue.contains(valueMatch.getLeft()));
            } else if (unset) {
                Assert.assertTrue((!refValue.contains(valueMatch.getRight()) ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((boolean)refValue.contains(valueMatch.getRight()));
            }
        } else {
            EObject refValue = (EObject)container.eGet((EStructuralFeature)ref);
            if (unset) {
                Assert.assertSame(null, (Object)refValue);
            } else if (rightToLeft) {
                Assert.assertSame((Object)valueMatch.getLeft(), (Object)refValue);
            } else {
                Assert.assertSame((Object)valueMatch.getRight(), (Object)refValue);
            }
        }
    }

    private static void assertValueIndexIs(ReferenceChange diff, boolean rightToLeft, int expectedIndex) {
        Match containerMatch = diff.getMatch();
        Match valueMatch = containerMatch.getComparison().getMatch(diff.getValue());
        if (rightToLeft) {
            if (expectedIndex != -1) {
                Assert.assertNotNull((Object)valueMatch.getLeft());
                Assert.assertSame((Object)containerMatch.getLeft().eResource(), (Object)valueMatch.getLeft().eResource());
                EObject addedToLeft = valueMatch.getLeft();
                List<EObject> values = MultipleMergeTest.getAsList(containerMatch.getLeft(), diff.getReference());
                Assert.assertEquals((long)expectedIndex, (long)values.indexOf(addedToLeft));
            } else {
                Assert.assertTrue((valueMatch == null || valueMatch.getLeft() == null ? 1 : 0) != 0);
            }
        } else if (expectedIndex != -1) {
            Assert.assertNotNull((Object)valueMatch.getRight());
            Assert.assertSame((Object)containerMatch.getRight().eResource(), (Object)valueMatch.getRight().eResource());
            EObject addedToRight = valueMatch.getRight();
            List<EObject> values = MultipleMergeTest.getAsList(containerMatch.getRight(), diff.getReference());
            Assert.assertEquals((long)expectedIndex, (long)values.indexOf(addedToRight));
        } else {
            Assert.assertTrue((valueMatch == null || valueMatch.getRight() == null ? 1 : 0) != 0);
        }
    }

    private static List<EObject> getAsList(EObject object, EReference feature) {
        if (object != null) {
            Object value = object.eGet((EStructuralFeature)feature, false);
            ImmutableList asList = value instanceof List ? (ImmutableList)value : (value instanceof Iterable ? ImmutableList.copyOf((Iterable)((Iterable)value)) : (value != null ? ImmutableList.of((Object)((EObject)value)) : Collections.emptyList()));
            return asList;
        }
        return Collections.emptyList();
    }
}

