/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeNodeItemProviderSpec;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.AbstractTestTreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.data.ecore.a1.EcoreA1InputData;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestReferenceChangeTreeNodeItemProviderSpec
extends AbstractTestTreeNodeItemProviderAdapter {
    private static TreeNodeItemProviderSpec itemProvider;

    @Override
    @Before
    public void before() throws IOException {
        super.before();
        itemProvider = (TreeNodeItemProviderSpec)this.treeItemProviderAdapterFactory.createTreeNodeAdapter();
    }

    static TreeNode getEcoreA1_EPackageMatch() throws IOException {
        Comparison comparison = TestReferenceChangeTreeNodeItemProviderSpec.getComparison(new EcoreA1InputData());
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData((EObject)comparison);
        treeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemProvider.getChildren((Object)treeNode);
        Iterable matches = Iterables.filter((Iterable)children, (Predicate)matchTreeNode);
        return (TreeNode)matches.iterator().next();
    }

    @Test
    public void testGetChildren_AudioVisualItem() throws IOException {
        TreeNode ePackageMatch = TestReferenceChangeTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        MatchNode audioVisualItemNode = (MatchNode)ePackageMatch.getChildren().get(3);
        this.checkMatch(audioVisualItemNode, DifferenceSource.RIGHT, "AudioVisualItem");
        EList audioVisualChildren = audioVisualItemNode.getChildren();
        Assert.assertEquals((long)3L, (long)audioVisualChildren.size());
        TreeNode node = (TreeNode)audioVisualChildren.get(0);
        this.checkRefChange(node, DifferenceSource.RIGHT, DifferenceKind.ADD, "eSuperTypes");
        this.checkNoChild(node);
        node = (TreeNode)audioVisualChildren.get(1);
        Assert.assertTrue((boolean)(node instanceof MatchNode));
        Assert.assertEquals((long)2L, (long)node.getChildren().size());
        TreeNode childNode = (TreeNode)node.getChildren().get(0);
        this.checkRefChange(childNode, DifferenceSource.RIGHT, DifferenceKind.DELETE, "eStructuralFeatures");
        this.checkNoChild(childNode);
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkRefChange(childNode, DifferenceSource.RIGHT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild(childNode);
        node = (TreeNode)audioVisualChildren.get(2);
        Assert.assertTrue((boolean)(node instanceof MatchNode));
        Assert.assertEquals((long)2L, (long)node.getChildren().size());
        childNode = (TreeNode)node.getChildren().get(0);
        this.checkAttChange(childNode, DifferenceSource.LEFT, DifferenceKind.CHANGE, "name", "length");
        this.checkNoChild(childNode);
        childNode = (TreeNode)node.getChildren().get(1);
        this.checkAttChange(childNode, DifferenceSource.RIGHT, DifferenceKind.CHANGE, "name", "minutes");
        this.checkNoChild(childNode);
    }

    @Test
    public void testGetChildren_Book() throws IOException {
        TreeNode ePackageMatch = TestReferenceChangeTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        MatchNode bookNode = (MatchNode)ePackageMatch.getChildren().get(0);
        this.checkMatch(bookNode, DifferenceSource.RIGHT, "Book");
        EList bookChildren = bookNode.getChildren();
        Assert.assertEquals((long)3L, (long)bookChildren.size());
        TreeNode diffNode = (TreeNode)bookChildren.get(0);
        this.checkRefChange(diffNode, DifferenceSource.RIGHT, DifferenceKind.ADD, "eSuperTypes");
        this.checkNoChild(diffNode);
        MatchNode titleMatchNode = (MatchNode)bookChildren.get(1);
        Assert.assertEquals((long)2L, (long)titleMatchNode.getChildren().size());
        diffNode = (TreeNode)titleMatchNode.getChildren().get(0);
        this.checkRefChange(diffNode, DifferenceSource.RIGHT, DifferenceKind.DELETE, "eStructuralFeatures");
        this.checkNoChild(diffNode);
        diffNode = (TreeNode)titleMatchNode.getChildren().get(1);
        this.checkRefChange(diffNode, DifferenceSource.RIGHT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild(diffNode);
        MatchNode subtitleMatchNode = (MatchNode)bookChildren.get(2);
        Assert.assertEquals((long)2L, (long)subtitleMatchNode.getChildren().size());
        diffNode = (TreeNode)subtitleMatchNode.getChildren().get(0);
        this.checkRefChange(diffNode, DifferenceSource.RIGHT, DifferenceKind.ADD, "eStructuralFeatures");
        this.checkNoChild(diffNode);
        diffNode = (TreeNode)subtitleMatchNode.getChildren().get(1);
        this.checkRefChange(diffNode, DifferenceSource.RIGHT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild(diffNode);
    }

    @Test
    public void testGetChildren_Borrowable() throws IOException {
        TreeNode ePackageMatch = TestReferenceChangeTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        MatchNode borrowableNode = (MatchNode)ePackageMatch.getChildren().get(2);
        this.checkMatch(borrowableNode, DifferenceSource.LEFT, "Borrowable");
        this.checkMatch(borrowableNode, DifferenceSource.RIGHT, "Lendable");
        Assert.assertEquals((long)1L, (long)borrowableNode.getChildren().size());
        TreeNode node = (TreeNode)borrowableNode.getChildren().get(0);
        this.checkAttChange(node, DifferenceSource.LEFT, DifferenceKind.CHANGE, "name", "Borrowable");
    }

    @Test
    public void testGetChildren_BookCategory() throws IOException {
        TreeNode ePackageMatch = TestReferenceChangeTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        MatchNode bookCategoryNode = (MatchNode)ePackageMatch.getChildren().get(1);
        this.checkMatch(bookCategoryNode, DifferenceSource.RIGHT, "BookCategory");
        EList bookCategoryChildren = bookCategoryNode.getChildren();
        Assert.assertEquals((long)4L, (long)bookCategoryChildren.size());
        MatchNode matchNode = (MatchNode)bookCategoryChildren.get(0);
        Assert.assertEquals((long)1L, (long)matchNode.getChildren().size());
        Match match = matchNode.getMatch();
        Assert.assertEquals((Object)"Encyclopedia", (Object)this.safeEGet(match.getLeft(), "name"));
        DiffNode diffNode = (DiffNode)matchNode.getChildren().get(0);
        Assert.assertTrue((boolean)diffNode.getChildren().isEmpty());
        ReferenceChange diff = (ReferenceChange)diffNode.getDiff();
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff.getSource());
        matchNode = (MatchNode)bookCategoryChildren.get(1);
        Assert.assertEquals((long)1L, (long)matchNode.getChildren().size());
        match = matchNode.getMatch();
        Assert.assertEquals((Object)"Dictionary", (Object)this.safeEGet(match.getLeft(), "name"));
        diffNode = (DiffNode)matchNode.getChildren().get(0);
        Assert.assertTrue((boolean)diffNode.getChildren().isEmpty());
        diff = (ReferenceChange)diffNode.getDiff();
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff.getSource());
        matchNode = (MatchNode)bookCategoryChildren.get(2);
        Assert.assertEquals((long)1L, (long)matchNode.getChildren().size());
        match = matchNode.getMatch();
        Assert.assertEquals((Object)"Manga", (Object)this.safeEGet(match.getRight(), "name"));
        diffNode = (DiffNode)matchNode.getChildren().get(0);
        Assert.assertTrue((boolean)diffNode.getChildren().isEmpty());
        diff = (ReferenceChange)diffNode.getDiff();
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff.getKind());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)diff.getSource());
        matchNode = (MatchNode)bookCategoryChildren.get(3);
        Assert.assertEquals((long)1L, (long)matchNode.getChildren().size());
        match = matchNode.getMatch();
        Assert.assertEquals((Object)"Manhwa", (Object)this.safeEGet(match.getRight(), "name"));
        diffNode = (DiffNode)matchNode.getChildren().get(0);
        Assert.assertTrue((boolean)diffNode.getChildren().isEmpty());
        diff = (ReferenceChange)diffNode.getDiff();
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff.getKind());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)diff.getSource());
    }

    @Test
    public void testGetChildren_Magazine1() throws IOException {
        TreeNode ePackageMatch = TestReferenceChangeTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        MatchNode magazine1Node = (MatchNode)ePackageMatch.getChildren().get(6);
        this.checkMatch(magazine1Node, DifferenceSource.LEFT, "Magazine");
        Assert.assertEquals((long)4L, (long)magazine1Node.getChildren().size());
        DiffNode node = (DiffNode)magazine1Node.getChildren().get(0);
        this.checkRefChange((TreeNode)node, DifferenceSource.LEFT, DifferenceKind.ADD, "eClassifiers");
        this.checkNoChild((TreeNode)node);
        Assert.assertNull((Object)node.getDiff().getConflict());
        node = (DiffNode)magazine1Node.getChildren().get(1);
        this.checkRefChange((TreeNode)node, DifferenceSource.LEFT, DifferenceKind.ADD, "eSuperTypes");
        this.checkNoChild((TreeNode)node);
        Assert.assertNull((Object)node.getDiff().getConflict());
        MatchNode matchNode = (MatchNode)magazine1Node.getChildren().get(2);
        Assert.assertEquals((long)2L, (long)matchNode.getChildren().size());
        node = (DiffNode)matchNode.getChildren().get(0);
        this.checkRefChange((TreeNode)node, DifferenceSource.LEFT, DifferenceKind.ADD, "eStructuralFeatures");
        this.checkNoChild((TreeNode)node);
        Assert.assertNull((Object)node.getDiff().getConflict());
        node = (DiffNode)matchNode.getChildren().get(1);
        this.checkRefChange((TreeNode)node, DifferenceSource.LEFT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild((TreeNode)node);
        Assert.assertNull((Object)node.getDiff().getConflict());
        matchNode = (MatchNode)magazine1Node.getChildren().get(3);
        Assert.assertEquals((long)2L, (long)matchNode.getChildren().size());
        node = (DiffNode)matchNode.getChildren().get(0);
        this.checkRefChange((TreeNode)node, DifferenceSource.LEFT, DifferenceKind.ADD, "eStructuralFeatures");
        this.checkNoChild((TreeNode)node);
        Assert.assertNull((Object)node.getDiff().getConflict());
        node = (DiffNode)matchNode.getChildren().get(1);
        this.checkRefChange((TreeNode)node, DifferenceSource.LEFT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild((TreeNode)node);
        Assert.assertNull((Object)node.getDiff().getConflict());
    }

    @Test
    public void testGetChildren_Magazine2() throws IOException {
        TreeNode ePackageMatch = TestReferenceChangeTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        MatchNode magazine2Node = (MatchNode)ePackageMatch.getChildren().get(8);
        this.checkMatch(magazine2Node, DifferenceSource.RIGHT, "Magazine");
        Assert.assertEquals((long)2L, (long)magazine2Node.getChildren().size());
        DiffNode node = (DiffNode)magazine2Node.getChildren().get(0);
        this.checkRefChange((TreeNode)node, DifferenceSource.RIGHT, DifferenceKind.ADD, "eClassifiers");
        this.checkNoChild((TreeNode)node);
        Assert.assertNull((Object)node.getDiff().getConflict());
        node = (DiffNode)magazine2Node.getChildren().get(1);
        this.checkRefChange((TreeNode)node, DifferenceSource.RIGHT, DifferenceKind.ADD, "eSuperTypes");
        this.checkNoChild((TreeNode)node);
        Assert.assertNotNull((Object)node.getDiff().getConflict());
    }

    @Test
    public void testGetChildren_Periodical() throws IOException {
        TreeNode ePackageMatch = TestReferenceChangeTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        MatchNode periodicalNode = (MatchNode)ePackageMatch.getChildren().get(7);
        this.checkMatch(periodicalNode, DifferenceSource.RIGHT, "Periodical");
        EList periodicalChildren = periodicalNode.getChildren();
        Assert.assertEquals((long)5L, (long)periodicalChildren.size());
        TreeNode node0 = (TreeNode)periodicalChildren.get(0);
        this.checkRefChange(node0, DifferenceSource.LEFT, DifferenceKind.DELETE, "eClassifiers");
        this.checkNoChild(node0);
        Assert.assertNotNull((Object)((Diff)node0.getData()).getConflict());
        TreeNode node1 = (TreeNode)periodicalChildren.get(1);
        this.checkRefChange(node1, DifferenceSource.LEFT, DifferenceKind.DELETE, "eSuperTypes");
        this.checkNoChild(node1);
        TreeNode node2 = (TreeNode)periodicalChildren.get(2);
        this.checkRefChange(node2, DifferenceSource.RIGHT, DifferenceKind.ADD, "eSuperTypes");
        this.checkNoChild(node2);
        Assert.assertNotNull((Object)((Diff)node2.getData()).getConflict());
        Assert.assertSame((Object)((Diff)node0.getData()).getConflict(), (Object)((Diff)node2.getData()).getConflict());
        TreeNode node3 = (TreeNode)periodicalChildren.get(3);
        Assert.assertTrue((boolean)(node3 instanceof MatchNode));
        Assert.assertEquals((long)2L, (long)node3.getChildren().size());
        DiffNode childNode = (DiffNode)node3.getChildren().get(0);
        this.checkRefChange((TreeNode)childNode, DifferenceSource.LEFT, DifferenceKind.DELETE, "eStructuralFeatures");
        this.checkNoChild((TreeNode)childNode);
        Assert.assertNull((Object)childNode.getDiff().getConflict());
        childNode = (DiffNode)node3.getChildren().get(1);
        this.checkRefChange((TreeNode)childNode, DifferenceSource.LEFT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild((TreeNode)childNode);
        Assert.assertNull((Object)childNode.getDiff().getConflict());
        TreeNode node4 = (TreeNode)periodicalChildren.get(4);
        Assert.assertTrue((boolean)(node4 instanceof MatchNode));
        Assert.assertEquals((long)4L, (long)node4.getChildren().size());
        childNode = (DiffNode)node4.getChildren().get(0);
        this.checkRefChange((TreeNode)childNode, DifferenceSource.LEFT, DifferenceKind.DELETE, "eStructuralFeatures");
        this.checkNoChild((TreeNode)childNode);
        Conflict conflict = childNode.getDiff().getConflict();
        Assert.assertNotNull((Object)conflict);
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)conflict.getKind());
        childNode = (DiffNode)node4.getChildren().get(1);
        this.checkRefChange((TreeNode)childNode, DifferenceSource.RIGHT, DifferenceKind.DELETE, "eStructuralFeatures");
        this.checkNoChild((TreeNode)childNode);
        Assert.assertNotNull((Object)childNode.getDiff().getConflict());
        Assert.assertSame((Object)conflict, (Object)childNode.getDiff().getConflict());
        childNode = (DiffNode)node4.getChildren().get(2);
        this.checkRefChange((TreeNode)childNode, DifferenceSource.LEFT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild((TreeNode)childNode);
        Conflict conflict2 = childNode.getDiff().getConflict();
        Assert.assertNotNull((Object)conflict2);
        Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)conflict2.getKind());
        Assert.assertNotSame((Object)conflict, (Object)conflict2);
        childNode = (DiffNode)node4.getChildren().get(3);
        this.checkRefChange((TreeNode)childNode, DifferenceSource.RIGHT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild((TreeNode)childNode);
        Assert.assertNotNull((Object)childNode.getDiff().getConflict());
        Assert.assertSame((Object)conflict2, (Object)childNode.getDiff().getConflict());
    }

    @Test
    public void testGetChildren_Person() throws IOException {
        TreeNode ePackageMatch = TestReferenceChangeTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        MatchNode personNode = (MatchNode)ePackageMatch.getChildren().get(5);
        this.checkMatch(personNode, DifferenceSource.LEFT, "Person");
        EList personChildren = personNode.getChildren();
        Assert.assertEquals((long)3L, (long)personChildren.size());
        TreeNode fullNameNode = (TreeNode)personChildren.get(0);
        Assert.assertEquals((long)2L, (long)fullNameNode.getChildren().size());
        DiffNode diffNode = (DiffNode)fullNameNode.getChildren().get(0);
        this.checkRefChange((TreeNode)diffNode, DifferenceSource.LEFT, DifferenceKind.ADD, "eStructuralFeatures");
        this.checkNoChild((TreeNode)diffNode);
        Assert.assertNull((Object)diffNode.getDiff().getConflict());
        diffNode = (DiffNode)fullNameNode.getChildren().get(1);
        this.checkRefChange((TreeNode)diffNode, DifferenceSource.LEFT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild((TreeNode)diffNode);
        Assert.assertNull((Object)diffNode.getDiff().getConflict());
        TreeNode firstNameNode = (TreeNode)personChildren.get(1);
        Assert.assertEquals((long)2L, (long)firstNameNode.getChildren().size());
        diffNode = (DiffNode)firstNameNode.getChildren().get(0);
        this.checkRefChange((TreeNode)diffNode, DifferenceSource.LEFT, DifferenceKind.DELETE, "eStructuralFeatures");
        this.checkNoChild((TreeNode)diffNode);
        Assert.assertNull((Object)diffNode.getDiff().getConflict());
        diffNode = (DiffNode)firstNameNode.getChildren().get(1);
        this.checkRefChange((TreeNode)diffNode, DifferenceSource.LEFT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild((TreeNode)diffNode);
        Assert.assertNull((Object)diffNode.getDiff().getConflict());
        TreeNode lastNameNode = (TreeNode)personChildren.get(2);
        Assert.assertEquals((long)3L, (long)lastNameNode.getChildren().size());
        diffNode = (DiffNode)lastNameNode.getChildren().get(0);
        this.checkRefChange((TreeNode)diffNode, DifferenceSource.LEFT, DifferenceKind.DELETE, "eStructuralFeatures");
        this.checkNoChild((TreeNode)diffNode);
        Conflict conflict = diffNode.getDiff().getConflict();
        Assert.assertNotNull((Object)conflict);
        diffNode = (DiffNode)lastNameNode.getChildren().get(1);
        this.checkRefChange((TreeNode)diffNode, DifferenceSource.LEFT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild((TreeNode)diffNode);
        Assert.assertNull((Object)diffNode.getDiff().getConflict());
        diffNode = (DiffNode)lastNameNode.getChildren().get(2);
        this.checkAttChange((TreeNode)diffNode, DifferenceSource.RIGHT, DifferenceKind.CHANGE, "name", "familyName");
        this.checkNoChild((TreeNode)diffNode);
        Assert.assertSame((Object)conflict, (Object)diffNode.getDiff().getConflict());
    }

    @Test
    public void testGetChildren_TitledItem() throws IOException {
        TreeNode ePackageMatch = TestReferenceChangeTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        MatchNode titledItemNode = (MatchNode)ePackageMatch.getChildren().get(9);
        this.checkMatch(titledItemNode, DifferenceSource.RIGHT, "TitledItem");
        Assert.assertEquals((long)2L, (long)titledItemNode.getChildren().size());
        DiffNode node = (DiffNode)titledItemNode.getChildren().get(0);
        this.checkRefChange((TreeNode)node, DifferenceSource.RIGHT, DifferenceKind.ADD, "eClassifiers");
        this.checkNoChild((TreeNode)node);
        Assert.assertNull((Object)node.getDiff().getConflict());
        MatchNode titleMatchNode = (MatchNode)titledItemNode.getChildren().get(1);
        Assert.assertEquals((long)2L, (long)titleMatchNode.getChildren().size());
        node = (DiffNode)titleMatchNode.getChildren().get(0);
        this.checkRefChange((TreeNode)node, DifferenceSource.RIGHT, DifferenceKind.ADD, "eStructuralFeatures");
        this.checkNoChild((TreeNode)node);
        Assert.assertNull((Object)node.getDiff().getConflict());
        node = (DiffNode)titleMatchNode.getChildren().get(1);
        this.checkRefChange((TreeNode)node, DifferenceSource.RIGHT, DifferenceKind.CHANGE, "eType");
        this.checkNoChild((TreeNode)node);
        Assert.assertNull((Object)node.getDiff().getConflict());
    }

    private Object safeEGet(EObject o, String name) {
        return o.eGet(o.eClass().getEStructuralFeature(name));
    }

    protected void checkMatch(MatchNode node, DifferenceSource side, String value) {
        Assert.assertEquals((Object)value, (Object)this.safeEGet(MatchUtil.getMatchedObject((Match)node.getMatch(), (DifferenceSource)side), "name"));
    }

    protected void checkDiffNode(TreeNode node, Class<?> clazz, DifferenceSource src, DifferenceKind kind) {
        Assert.assertTrue((boolean)(node instanceof DiffNode));
        Diff diff = ((DiffNode)node).getDiff();
        Assert.assertTrue((boolean)clazz.isAssignableFrom(diff.getClass()));
        Assert.assertSame((Object)src, (Object)diff.getSource());
        Assert.assertSame((Object)kind, (Object)diff.getKind());
    }

    protected void checkRefChange(TreeNode node, DifferenceSource src, DifferenceKind kind, String refName) {
        this.checkDiffNode(node, ReferenceChange.class, src, kind);
        ReferenceChange diff = (ReferenceChange)((DiffNode)node).getDiff();
        Assert.assertEquals((Object)refName, (Object)diff.getReference().getName());
    }

    protected void checkAttChange(TreeNode node, DifferenceSource src, DifferenceKind kind, String refName, Object value) {
        this.checkDiffNode(node, AttributeChange.class, src, kind);
        AttributeChange diff = (AttributeChange)((DiffNode)node).getDiff();
        Assert.assertEquals((Object)refName, (Object)diff.getAttribute().getName());
        Assert.assertEquals((Object)value, (Object)diff.getValue());
    }

    protected void checkNoChild(TreeNode node) {
        Assert.assertTrue((boolean)node.getChildren().isEmpty());
    }
}

