/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tooltip;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.ResourceLocationChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.internal.merge.IMergeData;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.provider.ISemanticObjectLabelProvider;
import org.eclipse.emf.compare.provider.ITooltipLabelProvider;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public abstract class AbstractTooltipProvider<T extends Diff>
extends AdapterImpl
implements ITooltipLabelProvider {
    private static final String LINE_SEPARATOR = "\n";
    protected ComposedAdapterFactory adapterFactory;
    protected IItemLabelProvider labelProvider;

    public boolean isAdapterForType(Object type) {
        if (type == ITooltipLabelProvider.class) {
            return true;
        }
        return super.isAdapterForType(type);
    }

    @Deprecated
    protected String acceptAndChanged(String value) {
        return this.acceptAndChanged(value, false);
    }

    protected String acceptAndChanged(String value, boolean isLeftToRight) {
        String accept = EMFCompareEditMessages.getString("ContextualTooltip.acceptChange");
        String modify = isLeftToRight ? EMFCompareEditMessages.getString("ContextualTooltip.readonly.rightChanged") : EMFCompareEditMessages.getString("ContextualTooltip.readonly.leftChanged");
        StringBuilder builder = new StringBuilder();
        builder.append(accept).append(LINE_SEPARATOR).append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    protected boolean isFromLeft(T diff) {
        return diff.getSource().equals((Object)DifferenceSource.LEFT);
    }

    protected boolean isMirrored(T diff) {
        Comparison comparison = ComparisonUtil.getComparison(diff);
        if (comparison != null) {
            IMergeData mergeData = (IMergeData)EcoreUtil.getExistingAdapter((Notifier)comparison, IMergeData.class);
            return mergeData != null && mergeData.isMirrored();
        }
        return false;
    }

    protected boolean isLeftToRight(T diff, MergeMode mode) {
        IMergeData mergeData;
        Comparison comparison = ComparisonUtil.getComparison(diff);
        if (comparison != null && (mergeData = (IMergeData)EcoreUtil.getExistingAdapter((Notifier)comparison, IMergeData.class)) != null) {
            if (mergeData.isMirrored()) {
                return mode.isLeftToRight(mergeData.isRightEditable(), mergeData.isLeftEditable());
            }
            return mode.isLeftToRight(mergeData.isLeftEditable(), mergeData.isRightEditable());
        }
        return mode.isLeftToRight(true, true);
    }

    @Deprecated
    protected String acceptAndUnchanged(String value) {
        return this.acceptAndUnchanged(value, false);
    }

    protected String acceptAndUnchanged(String value, boolean isLeftToRight) {
        String accept = EMFCompareEditMessages.getString("ContextualTooltip.acceptChange");
        String modify = isLeftToRight ? EMFCompareEditMessages.getString("ContextualTooltip.readonly.rightUnchanged") : EMFCompareEditMessages.getString("ContextualTooltip.readonly.leftUnchanged");
        StringBuilder builder = new StringBuilder();
        builder.append(accept).append(LINE_SEPARATOR).append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    @Deprecated
    protected String rejectAndChanged(String value) {
        return this.rejectAndChanged(value, false);
    }

    protected String rejectAndChanged(String value, boolean isLeftToRight) {
        String accept = EMFCompareEditMessages.getString("ContextualTooltip.rejectChange");
        String modify = isLeftToRight ? EMFCompareEditMessages.getString("ContextualTooltip.readonly.rightChanged") : EMFCompareEditMessages.getString("ContextualTooltip.readonly.leftChanged");
        StringBuilder builder = new StringBuilder();
        builder.append(accept).append(LINE_SEPARATOR).append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    @Deprecated
    protected String rejectAndUnchanged(String value) {
        return this.rejectAndUnchanged(value, false);
    }

    protected String rejectAndUnchanged(String value, boolean isLeftToRight) {
        String accept = EMFCompareEditMessages.getString("ContextualTooltip.rejectChange");
        String modify = isLeftToRight ? EMFCompareEditMessages.getString("ContextualTooltip.readonly.rightUnchanged") : EMFCompareEditMessages.getString("ContextualTooltip.readonly.leftUnchanged");
        StringBuilder builder = new StringBuilder();
        builder.append(accept).append(LINE_SEPARATOR).append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    protected String rightUnchanged(String value) {
        String modify = EMFCompareEditMessages.getString("ContextualTooltip.editable.rightUnchanged");
        StringBuilder builder = new StringBuilder();
        builder.append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    protected String rightChanged(String value) {
        String modify = EMFCompareEditMessages.getString("ContextualTooltip.editable.rightChanged");
        StringBuilder builder = new StringBuilder();
        builder.append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    protected String getLabel(EObject eObject) {
        Adapter adapter;
        if (eObject != null && (adapter = this.adapterFactory.getRootAdapterFactory().adapt((Notifier)eObject, ISemanticObjectLabelProvider.class)) instanceof ISemanticObjectLabelProvider) {
            return ((ISemanticObjectLabelProvider)adapter).getSemanticObjectLabel(eObject);
        }
        return null;
    }

    private String getPreviousValue(EStructuralFeature eStructuralFeature, EObject eObject) {
        Object ancestor = null;
        if (eObject != null) {
            ancestor = ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)eStructuralFeature);
        }
        String value = "";
        if (ancestor instanceof EObject) {
            value = this.getLabelFromObject((EObject)ancestor);
        } else if (ancestor != null) {
            value = ancestor.toString();
        }
        return value;
    }

    protected String getLabelFromObject(EObject eObject) {
        if (eObject == null) {
            return "";
        }
        return this.labelProvider.getText((Object)eObject);
    }

    protected String setDeleteNonContainmentTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.left.leftToRight", value) : EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.right.leftToRight", value);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.left.rightToLeft", value) : EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.right.rightToLeft", value);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.delete.nonContainment.left.accept"), value);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.delete.nonContainment.right.accept"), value);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.left.reject", value);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.delete.nonContainment.right.reject"), value);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    protected String setAddNonContainmentTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.left.leftToRight", value) : EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.right.leftToRight", value);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.left.rightToLeft", value) : EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.right.rightToLeft", value);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.add.nonContainment.left.accept"), value);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.add.nonContainment.right.accept"), value);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.add.nonContainment.left.reject"), value);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.add.nonContainment.right.reject"), value);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    protected String setMovePositionTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        String containerValue = this.getLabel((EObject)diff.getMatch());
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.move.position.left.leftToRight", value) : EMFCompareEditMessages.getString("ContextualTooltip.move.position.right.leftToRight", value);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.move.position.left.rightToLeft", value) : EMFCompareEditMessages.getString("ContextualTooltip.move.position.right.rightToLeft", value);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment() ? EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.position.left.container.accept"), value, containerValue) : EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.position.left.accept"), value);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                String body = diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment() ? EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.position.right.container.accept"), value, containerValue) : EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.position.right.accept"), value);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.position.left.reject"), value);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                String body = diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment() ? EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.position.right.container.reject"), value, containerValue) : EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.move.position.right.reject"), value);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    protected String setSetTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        EStructuralFeature eStructuralFeature = MatchUtil.getStructuralFeature(diff);
        Match match = diff.getMatch();
        EObject left = match.getLeft();
        EObject right = match.getRight();
        String rightValue = this.getPreviousValue(eStructuralFeature, left);
        String leftValue = this.getPreviousValue(eStructuralFeature, right);
        String containerName = "";
        if (isFromLeft && left != null) {
            containerName = left.eClass().getName();
        } else if (!isFromLeft && right != null) {
            containerName = right.eClass().getName();
        }
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        String structuralFeatureName = eStructuralFeature.getName();
        switch (mode) {
            case LEFT_TO_RIGHT: 
            case RIGHT_TO_LEFT: {
                String key = "ContextualTooltip.set.";
                boolean isLeftToRightMode = mode == MergeMode.LEFT_TO_RIGHT;
                String singleSideValue = null;
                String effectiveLeft = this.getDirectionalValue(mirrored ^ isLeftToRightMode, leftValue, rightValue);
                String effectiveRight = this.getDirectionalValue(mirrored ^ isLeftToRightMode, rightValue, leftValue);
                key = isFromLeft != mirrored ? (isLeftToRightMode ? String.valueOf(key) + "left.leftToRight" : String.valueOf(key) + "left.rightToLeft") : (isLeftToRightMode ? String.valueOf(key) + "right.leftToRight" : String.valueOf(key) + "right.rightToLeft");
                if (effectiveLeft.isEmpty()) {
                    key = String.valueOf(key) + ".empty";
                    singleSideValue = effectiveRight;
                } else if (effectiveRight.isEmpty()) {
                    key = String.valueOf(key) + ".empty";
                    singleSideValue = effectiveLeft;
                }
                String body = singleSideValue != null ? EMFCompareEditMessages.getString(key, structuralFeatureName, containerName, singleSideValue) : EMFCompareEditMessages.getString(key, structuralFeatureName, containerName, effectiveLeft, effectiveRight);
                if (isLeftToRightMode) {
                    tooltip = this.rightChanged(body);
                    break;
                }
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                String effectiveLeft = this.getDirectionalValue(isLeftToRight == mirrored, leftValue, rightValue);
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.set.left.accept"), effectiveLeft, structuralFeatureName, containerName);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                String effectiveRight = this.getDirectionalValue(isLeftToRight == mirrored, rightValue, leftValue);
                String body = effectiveLeft.isEmpty() ? EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.set.right.accept.empty"), structuralFeatureName, containerName, effectiveRight) : EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.set.right.accept"), structuralFeatureName, containerName, effectiveRight, effectiveLeft);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                String effectiveLeft = this.getDirectionalValue(isLeftToRight == mirrored, leftValue, rightValue);
                String effectiveRight = this.getDirectionalValue(isLeftToRight == mirrored, rightValue, leftValue);
                String previousValue = null;
                if (match.getComparison().isThreeWay()) {
                    previousValue = this.getPreviousValue(eStructuralFeature, match.getOrigin());
                }
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    if (previousValue == null) {
                        previousValue = effectiveRight;
                    }
                    String body = previousValue.isEmpty() ? EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.set.left.reject.empty"), structuralFeatureName, containerName, effectiveLeft) : EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.set.left.reject"), structuralFeatureName, containerName, previousValue, effectiveLeft);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                if (previousValue == null) {
                    previousValue = effectiveLeft;
                }
                String body = previousValue.isEmpty() ? EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.set.right.reject.empty"), structuralFeatureName, containerName) : EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.set.right.reject"), previousValue, structuralFeatureName, containerName);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    protected String getDirectionalKey(boolean isLeftToRight, String key) {
        if (isLeftToRight) {
            return String.valueOf(key) + ".leftToRight";
        }
        return key;
    }

    protected String getDirectionalValue(boolean isLeftToRight, String leftValue, String rightValue) {
        if (isLeftToRight) {
            return rightValue;
        }
        return leftValue;
    }

    protected String setUnsetTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        EStructuralFeature structuralFeature = MatchUtil.getStructuralFeature(diff);
        String structuralFeatureName = structuralFeature.getName();
        String containerName = "";
        Match match = diff.getMatch();
        if (isFromLeft && match.getLeft() != null) {
            containerName = match.getLeft().eClass().getName();
        } else if (!isFromLeft && match.getRight() != null) {
            containerName = match.getRight().eClass().getName();
        }
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.unset.left.leftToRight", structuralFeatureName, containerName, value) : EMFCompareEditMessages.getString("ContextualTooltip.unset.right.leftToRight", structuralFeatureName, containerName, value);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.unset.left.rightToLeft", structuralFeatureName, containerName, value) : EMFCompareEditMessages.getString("ContextualTooltip.unset.right.rightToLeft", structuralFeatureName, containerName, value);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.unset.left.accept"), structuralFeatureName, containerName);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.unset.right.accept"), structuralFeatureName, containerName, value);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.unset.left.reject"), structuralFeatureName, containerName, value);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                String body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.unset.right.reject"), structuralFeatureName, containerName, value);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    protected String setResourceLocationChangeTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        if (diff instanceof ResourceAttachmentChange) {
            return "not supported yet";
        }
        if (!(diff instanceof ResourceLocationChange)) {
            return "";
        }
        ResourceLocationChange change = (ResourceLocationChange)diff;
        String oldValue = change.getBaseLocation();
        String newValue = change.getChangedLocation();
        boolean mirrored = this.isMirrored(diff);
        boolean isLeftToRight = this.isLeftToRight(diff, mode);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.rlc.left.leftToRight", newValue) : EMFCompareEditMessages.getString("ContextualTooltip.rlc.right.leftToRight", oldValue);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft != mirrored ? EMFCompareEditMessages.getString("ContextualTooltip.rlc.left.rightToLeft", oldValue) : EMFCompareEditMessages.getString("ContextualTooltip.rlc.right.rightToLeft", newValue);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                String body;
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rlc.left.accept"), newValue);
                    tooltip = this.acceptAndUnchanged(body, isLeftToRight);
                    break;
                }
                body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rlc.right.accept"), newValue);
                tooltip = this.acceptAndChanged(body, isLeftToRight);
                break;
            }
            case REJECT: {
                String body;
                if ((isFromLeft ^ isLeftToRight) != mirrored) {
                    body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rlc.left.reject"), oldValue);
                    tooltip = this.rejectAndChanged(body, isLeftToRight);
                    break;
                }
                body = EMFCompareEditMessages.getString(this.getDirectionalKey(isLeftToRight, "ContextualTooltip.rlc.right.reject"), oldValue);
                tooltip = this.rejectAndUnchanged(body, isLeftToRight);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }
}

