/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.uml2.internal.postprocessor.extension.stereotype.UMLStereotypedElementChangeFactory;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.uml2.uml.Element;

public class StereotypedElementChangePostProcessor
implements IPostProcessor {
    private UMLStereotypedElementChangeFactory factory = new UMLStereotypedElementChangeFactory();

    public void postMatch(Comparison comparison, Monitor monitor) {
        HashMap<Match, Map<URI, Match>> leftApplications = new HashMap<Match, Map<URI, Match>>();
        HashMap<Match, Map<URI, Match>> rightApplications = new HashMap<Match, Map<URI, Match>>();
        this.mapStereotypeApplications(comparison, leftApplications, rightApplications);
        for (Map.Entry left : leftApplications.entrySet()) {
            EObject base = (EObject)left.getKey();
            Map right = (Map)rightApplications.get(base);
            if (right == null) continue;
            for (Map.Entry next : ((Map)left.getValue()).entrySet()) {
                Match rightMatch = (Match)right.get(next.getKey());
                if (rightMatch == null) continue;
                ((Match)next.getValue()).setRight(rightMatch.getRight());
                EcoreUtil.remove((EObject)rightMatch);
            }
        }
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
        if (comparison.isThreeWay()) {
            AttributeDiffEngine engine = new AttributeDiffEngine();
            for (Match next : comparison.getMatches()) {
                if (next.getOrigin() != null || next.getLeft() == null || next.getRight() == null || !this.isStereotypeApplication(next.getLeft())) continue;
                engine.checkForDifferences(next, monitor);
            }
        }
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        for (Diff difference : comparison.getDifferences()) {
            Match match;
            Diff stereotypedElementChange;
            if (!this.factory.handles(difference) || (stereotypedElementChange = this.factory.create(difference)).getRefinedBy().isEmpty() || (match = this.factory.getParentMatch(difference)) == null) continue;
            match.getDifferences().add((Object)stereotypedElementChange);
        }
    }

    protected void mapStereotypeApplications(Comparison comparison, Map<Match, Map<URI, Match>> leftApplications, Map<Match, Map<URI, Match>> rightApplications) {
        for (Match next : comparison.getMatches()) {
            Match base;
            if (next.getLeft() != null && next.getRight() == null) {
                base = comparison.getMatch((EObject)this.getBaseElement(next.getLeft()));
                if (base == null) continue;
                StereotypedElementChangePostProcessor.put(leftApplications, base, StereotypedElementChangePostProcessor.getStereotypeURI(next.getLeft()), next);
                continue;
            }
            if (next.getRight() == null || next.getLeft() != null || (base = comparison.getMatch((EObject)this.getBaseElement(next.getRight()))) == null) continue;
            StereotypedElementChangePostProcessor.put(rightApplications, base, StereotypedElementChangePostProcessor.getStereotypeURI(next.getRight()), next);
        }
    }

    private static URI getStereotypeURI(EObject stereotypeApplication) {
        return EcoreUtil.getURI((EObject)stereotypeApplication.eClass());
    }

    private static <K, L, V> V put(Map<K, Map<L, V>> mapOfMaps, K key1, L key2, V value) {
        Map<L, V> map = mapOfMaps.get(key1);
        if (map == null) {
            map = new HashMap<L, V>();
            mapOfMaps.put(key1, map);
        }
        return map.put(key2, value);
    }

    protected boolean isStereotypeApplication(EObject object) {
        return this.getBaseElement(object) != null;
    }

    protected Element getBaseElement(EObject object) {
        Element result = null;
        if (object.eContainer() == null) {
            result = UMLCompareUtil.getBaseElement(object);
        }
        return result;
    }

    protected class AttributeDiffEngine
    extends DefaultDiffEngine {
        protected void checkForDifferences(Match match, Monitor monitor) {
            if (monitor.isCanceled()) {
                throw new ComparisonCanceledException();
            }
            FeatureFilter featureFilter = this.createFeatureFilter();
            Iterator attributes = featureFilter.getAttributesToCheck(match);
            while (attributes.hasNext()) {
                EAttribute attribute = (EAttribute)attributes.next();
                boolean considerOrdering = featureFilter.checkForOrderingChanges((EStructuralFeature)attribute);
                this.computeDifferences(match, attribute, considerOrdering);
            }
            for (Match submatch : match.getSubmatches()) {
                this.checkForDifferences(submatch, monitor);
            }
        }

        protected void computeDifferences(Match match, EAttribute attribute, boolean checkOrdering) {
            boolean shortcut;
            boolean bl = shortcut = match.getLeft() == null || match.getRight() == null;
            if (shortcut && FeatureMapUtil.isFeatureMap((EStructuralFeature)attribute) && FeatureMapUtil.isMany((EObject)match.getLeft(), (EStructuralFeature)attribute)) {
                shortcut = false;
            }
            if (shortcut) {
                return;
            }
            if (attribute.isMany()) {
                if (match.getComparison().isThreeWay()) {
                    this.computeMultiValuedFeatureDifferencesThreeWay(match, (EStructuralFeature)attribute, checkOrdering);
                } else {
                    this.computeMultiValuedFeatureDifferencesTwoWay(match, (EStructuralFeature)attribute, checkOrdering);
                }
            } else {
                this.computeSingleValuedAttributeDifferences(match, attribute);
            }
        }
    }
}

