/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.framework;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.scope.FilterComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.junit.Assert;

public class EMFCompareAssert {
    public static void assertAllMatched(List<EObject> eObjects, Comparison comparison, IComparisonScope scope) {
        Predicate<? super EObject> scopeFilter = scope instanceof FilterComparisonScope ? EMFCompareAssert.getResourceChildrenFilteringPredicate((FilterComparisonScope)scope) : Predicates.alwaysTrue();
        for (EObject eObject : eObjects) {
            Match match = comparison.getMatch(eObject);
            Assert.assertTrue((String)(eObject + " has no match"), (match != null || !scopeFilter.apply((Object)eObject) ? 1 : 0) != 0);
        }
    }

    public static void assertChangedReference(List<Diff> differences, String qualifiedName, String referenceName, String fromQualifiedName, String toQualifiedName, DifferenceSource side) {
        Predicate changedReferenceOnSide = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)side), (Predicate)EMFComparePredicates.changedReference((String)qualifiedName, (String)referenceName, (String)fromQualifiedName, (String)toQualifiedName));
        Diff matchingDiff = EMFCompareAssert.removeFirst(differences.iterator(), changedReferenceOnSide);
        Assert.assertNotNull((Object)matchingDiff);
    }

    public static void assertRemovedFromReference(List<Diff> differences, String qualifiedName, String referenceName, String removedValueQualifiedName, DifferenceSource side) {
        Predicate removedFromReferenceOnSide = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)side), (Predicate)EMFComparePredicates.removedFromReference((String)qualifiedName, (String)referenceName, (String)removedValueQualifiedName));
        Diff matchingDiff = EMFCompareAssert.removeFirst(differences.iterator(), removedFromReferenceOnSide);
        Assert.assertNotNull((Object)matchingDiff);
    }

    public static void assertAddedToReference(List<Diff> differences, String qualifiedName, String referenceName, String addedValueQualifiedName, DifferenceSource side) {
        Predicate addedToReferenceOnSide = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)side), (Predicate)EMFComparePredicates.addedToReference((String)qualifiedName, (String)referenceName, (String)addedValueQualifiedName));
        Diff matchingDiff = EMFCompareAssert.removeFirst(differences.iterator(), addedToReferenceOnSide);
        Assert.assertNotNull((Object)matchingDiff);
    }

    public static void assertChangedAttribute(List<Diff> differences, String qualifiedName, String attributeName, Object fromValue, Object toValue, DifferenceSource side) {
        Predicate changedAttributeOnSide = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)side), (Predicate)EMFComparePredicates.changedAttribute((String)qualifiedName, (String)attributeName, (Object)fromValue, (Object)toValue));
        Diff matchingDiff = EMFCompareAssert.removeFirst(differences.iterator(), changedAttributeOnSide);
        Assert.assertNotNull((Object)matchingDiff);
    }

    public static void assertAdded(List<Diff> differences, String qualifiedName, DifferenceSource side) {
        Predicate addedOnSide = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)side), (Predicate)EMFComparePredicates.added((String)qualifiedName));
        Diff matchingDiff = EMFCompareAssert.removeFirst(differences.iterator(), addedOnSide);
        Assert.assertNotNull((Object)matchingDiff);
    }

    public static void assertRemoved(List<Diff> differences, String qualifiedName, DifferenceSource side) {
        Predicate removedOnSide = Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)side), (Predicate)EMFComparePredicates.removed((String)qualifiedName));
        Diff matchingDiff = EMFCompareAssert.removeFirst(differences.iterator(), removedOnSide);
        Assert.assertNotNull((Object)matchingDiff);
    }

    private static Predicate<? super EObject> getResourceChildrenFilteringPredicate(FilterComparisonScope scope) {
        String fieldName = "resourceContentFilter";
        try {
            Field field = FilterComparisonScope.class.getDeclaredField("resourceContentFilter");
            field.setAccessible(true);
            return (Predicate)field.get(scope);
        }
        catch (Exception e) {
            Assert.fail((String)("Could not retrieve the filtering predicate of " + scope.getClass().getName()));
            return null;
        }
    }

    private static <T> T removeFirst(Iterator<T> iterator, Predicate<? super T> predicate) {
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (!predicate.apply(element)) continue;
            iterator.remove();
            return element;
        }
        return null;
    }
}

