/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.Action;

public class UndoAction
extends Action {
    protected ICompareEditingDomain domain;

    public UndoAction(ICompareEditingDomain domain) {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item", new Object[]{""}));
        this.setEditingDomain(domain);
    }

    public UndoAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item", new Object[]{""}));
    }

    public void run() {
        this.domain.getCommandStack().undo();
    }

    public void setEditingDomain(ICompareEditingDomain domain) {
        this.domain = domain;
        if (domain != null) {
            this.update();
        }
    }

    public void update() {
        this.setEnabled(this.domain.getCommandStack().canUndo());
        Command undoCommand = this.domain.getCommandStack().getUndoCommand();
        if (undoCommand != null && undoCommand.getLabel() != null) {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item", new Object[]{undoCommand.getLabel()}));
        } else {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item", new Object[]{""}));
        }
        if (undoCommand != null && undoCommand.getDescription() != null) {
            this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item_description", new Object[]{undoCommand.getDescription()}));
        } else {
            this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item_simple_description"));
        }
    }
}

