/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text;

import java.util.EventObject;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text.EMFCompareTextMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.AttributeChangeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class EMFCompareTextMergeViewer
extends TextMergeViewer {
    private static final String BUNDLE_NAME = EMFCompareTextMergeViewer.class.getName();
    private final ICompareEditingDomain fEditingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN");
    private DynamicObject fDynamicObject;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;

    public EMFCompareTextMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.setContentProvider((IContentProvider)new EMFCompareTextMergeViewerContentProvider(configuration));
    }

    protected void copy(boolean leftToRight) {
        Object input = this.getInput();
        if (input instanceof AttributeChangeNode) {
            AttributeChange attributeChange = ((AttributeChangeNode)((Object)input)).getTarget();
            Comparison comparison = attributeChange.getMatch().getComparison();
            Command copyCommand = this.fEditingDomain.createCopyAllNonConflictingCommand((List)comparison.getDifferences(), leftToRight);
            this.fEditingDomain.getCommandStack().execute(copyCommand);
            this.refresh();
        }
    }

    protected void copyDiff(boolean leftToRight) {
        Object input = this.getInput();
        if (input instanceof AttributeChangeNode) {
            AttributeChange attributeChange = ((AttributeChangeNode)((Object)input)).getTarget();
            Command copyCommand = this.fEditingDomain.createCopyCommand((Diff)attributeChange, leftToRight);
            this.fEditingDomain.getCommandStack().execute(copyCommand);
            this.refresh();
        }
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    public DynamicObject getDynamicObject() {
        if (this.fDynamicObject == null) {
            this.fDynamicObject = new DynamicObject((Object)this);
        }
        return this.fDynamicObject;
    }

    protected final MergeSourceViewer getLeftSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fLeft");
    }

    protected final MergeSourceViewer getRightSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fRight");
    }

    protected final void setHandlerService(CompareHandlerService service) {
        this.getDynamicObject().set("fHandlerService", service);
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        CompareHandlerService handlerService = CompareHandlerService.createFor((ICompareContainer)this.getCompareConfiguration().getContainer(), (Shell)this.getLeftSourceViewer().getSourceViewer().getControl().getShell());
        this.setHandlerService(handlerService);
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc.isRightEditable()) {
            Action copyLeftToRight = new Action(){

                public void run() {
                    EMFCompareTextMergeViewer.this.copyDiff(true);
                    EMFCompareTextMergeViewer.this.navigate(true);
                }
            };
            Utilities.initAction((IAction)copyLeftToRight, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffLeftToRight.");
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)copyLeftToRight);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            handlerService.registerAction((IAction)copyLeftToRight, "org.eclipse.compare.copyLeftToRight");
        }
        if (cc.isLeftEditable()) {
            Action copyRightToLeft = new Action(){

                public void run() {
                    EMFCompareTextMergeViewer.this.copyDiff(false);
                    EMFCompareTextMergeViewer.this.navigate(true);
                }
            };
            Utilities.initAction((IAction)copyRightToLeft, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffRightToLeft.");
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)copyRightToLeft);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            handlerService.registerAction((IAction)copyRightToLeft, "org.eclipse.compare.copyRightToLeft");
        }
        Action nextDiff = new Action(){

            public void run() {
                EMFCompareTextMergeViewer.this.endOfContentReached(true);
            }
        };
        Utilities.initAction((IAction)nextDiff, (ResourceBundle)this.getResourceBundle(), (String)"action.NextDiff.");
        ActionContributionItem contributionNextDiff = new ActionContributionItem((IAction)nextDiff);
        contributionNextDiff.setVisible(true);
        toolBarManager.appendToGroup("navigation", (IContributionItem)contributionNextDiff);
        Action previousDiff = new Action(){

            public void run() {
                EMFCompareTextMergeViewer.this.endOfContentReached(false);
            }
        };
        Utilities.initAction((IAction)previousDiff, (ResourceBundle)this.getResourceBundle(), (String)"action.PrevDiff.");
        ActionContributionItem contributionPreviousDiff = new ActionContributionItem((IAction)previousDiff);
        contributionPreviousDiff.setVisible(true);
        toolBarManager.appendToGroup("navigation", (IContributionItem)contributionPreviousDiff);
        ICompareEditingDomain domain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN");
        final UndoAction undoAction = new UndoAction(domain);
        final RedoAction redoAction = new RedoAction(domain);
        domain.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                undoAction.update();
                redoAction.update();
                EMFCompareTextMergeViewer.this.setLeftDirty(EMFCompareTextMergeViewer.this.fEditingDomain.getCommandStack().isLeftSaveNeeded());
                EMFCompareTextMergeViewer.this.setRightDirty(EMFCompareTextMergeViewer.this.fEditingDomain.getCommandStack().isRightSaveNeeded());
                EMFCompareTextMergeViewer.this.refresh();
            }
        });
        handlerService.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)undoAction);
        handlerService.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)redoAction);
    }

    protected void endOfContentReached(boolean next) {
        ICompareNavigator navigator;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected void navigate(boolean next) {
        ICompareNavigator navigator;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected void setEditable(ISourceViewer sourceViewer, boolean state) {
        sourceViewer.setEditable(false);
    }

    protected ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(BUNDLE_NAME);
    }
}

