/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diagram.DiagramDiff;
import org.eclipse.emf.compare.diagram.NodeChange;
import org.eclipse.emf.compare.diagram.ide.ui.DMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.GraphicalMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.decoration.DeleteGhostImageFigure;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramDiffAccessor;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramNodeAccessor;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.DiagramCompareContentMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.DiagramMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.DiffNode;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class DiagramContentMergeViewer
extends DiagramCompareContentMergeViewer {
    private Map<IFigure, Phantom> phantomsMap = new HashMap<IFigure, Phantom>();
    private Map<IFigure, IFigure> containerMap = new HashMap<IFigure, IFigure>();
    private Map<IFigure, Integer> phantomSelection = new HashMap<IFigure, Integer>();
    private static final String BUNDLE_NAME = DiagramContentMergeViewer.class.getName();
    private final ComposedAdapterFactory fAdapterFactory;
    private Predicate<Diff> diffsForPhantoms = Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), (Predicate)Predicates.instanceOf(NodeChange.class));

    public DiagramContentMergeViewer(Composite parent, CompareConfiguration config) {
        super(parent, 0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new DiagramCompareContentMergeViewer.GMFModelContentMergeContentProvider(config, this.fComparison));
    }

    protected void handleDispose(DisposeEvent event) {
        this.fAdapterFactory.dispose();
        super.handleDispose(event);
    }

    public GraphicalMergeViewer getAncestorMergeViewer() {
        return (GraphicalMergeViewer)super.getAncestorMergeViewer();
    }

    public GraphicalMergeViewer getLeftMergeViewer() {
        return (GraphicalMergeViewer)super.getLeftMergeViewer();
    }

    public GraphicalMergeViewer getRightMergeViewer() {
        return (GraphicalMergeViewer)super.getRightMergeViewer();
    }

    protected void copyDiff(boolean leftToRight) {
        Object elt;
        if (this.getInput() instanceof DiffNode) {
            Command command = this.getEditingDomain().createCopyCommand(((DiffNode)this.getInput()).getTarget(), leftToRight);
            this.getEditingDomain().getCommandStack().execute(command);
            if (leftToRight) {
                this.setRightDirty(true);
            } else {
                this.setLeftDirty(true);
            }
            this.refresh();
            return;
        }
        IStructuredSelection selection = leftToRight ? (IStructuredSelection)this.getLeftMergeViewer().getSelection() : (IStructuredSelection)this.getRightMergeViewer().getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof GraphicalEditPart && (elt = ((GraphicalEditPart)firstElement).getModel()) instanceof EObject) {
            EList differences = this.getComparison().getDifferences((EObject)elt);
            Command command = this.getEditingDomain().createCopyAllNonConflictingCommand((List)differences, leftToRight);
            this.getEditingDomain().getCommandStack().execute(command);
            if (leftToRight) {
                this.setRightDirty(true);
            } else {
                this.setLeftDirty(true);
            }
            this.refresh();
        }
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected DMergeViewer createMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side, DiagramCompareContentMergeViewer master) {
        DiagramMergeViewer mergeTreeViewer = new DiagramMergeViewer(parent, side);
        return mergeTreeViewer;
    }

    protected void paintCenter(GC g) {
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        super.updateContent(ancestor, left, right);
        if (left instanceof IDiagramNodeAccessor) {
            IFigure figureRef;
            Phantom phantom;
            IDiagramNodeAccessor input = (IDiagramNodeAccessor)left;
            Collection deleteDiffs = Collections2.filter(input.getAllDiffs(), this.diffsForPhantoms);
            if (this.phantomsMap.isEmpty()) {
                IFigure ref;
                this.fLeft.flush();
                ((DiagramMergeViewer)this.fLeft).getGraphicalViewer().flush();
                this.fRight.flush();
                ((DiagramMergeViewer)this.fRight).getGraphicalViewer().flush();
                this.fAncestor.flush();
                ((DiagramMergeViewer)this.fAncestor).getGraphicalViewer().flush();
                for (DiagramDiff diagramDiff : deleteDiffs) {
                    View viewRef = (View)diagramDiff.getView();
                    ref = this.getReferenceFigureValue(input.getComparison(), diagramDiff);
                    Diagram diagram = viewRef.getDiagram();
                    IMergeViewer.MergeViewerSide targetSide = this.getTargetSide(input.getComparison(), viewRef);
                    Diagram targetDiagram = (Diagram)this.getMatchView(input.getComparison(), (View)diagram, targetSide);
                    DiagramMergeViewer targetViewer = this.getViewer(targetSide);
                    IFigure targetLayer = LayerManager.Helper.find((EditPart)targetViewer.getEditPart((View)targetDiagram)).getLayer((Object)"Scalable Layers");
                    IFigure ghost = this.createGhostFigure(ref, targetSide, viewRef.eContainer() instanceof BasicCompartment);
                    this.phantomsMap.put(ref, new Phantom(ghost, targetLayer));
                    View parentViewRef = (View)this.getMatchView(diagramDiff.getMatch(), this.getSide(input.getComparison(), viewRef));
                    if (parentViewRef == null) continue;
                    IFigure parentRefFigure = this.getFigure(input.getComparison(), parentViewRef);
                    View parentTargetView = (View)this.getMatchView(diagramDiff.getMatch(), this.getSide((Diff)diagramDiff));
                    if (parentTargetView == null) continue;
                    IFigure parentTargetFigure = this.getFigure(input.getComparison(), parentTargetView);
                    this.containerMap.put(parentRefFigure, parentTargetFigure);
                }
                for (Map.Entry entry : this.phantomsMap.entrySet()) {
                    ref = (IFigure)entry.getKey();
                    Phantom target2 = (Phantom)entry.getValue();
                    IFigure ghost = target2.figure;
                    IFigure targetLayer = target2.layer;
                    IFigure parentGhost = this.findMatchingParentGhost(ref);
                    if (parentGhost != null) {
                        this.addToParent(ref, ghost, parentGhost);
                        continue;
                    }
                    IFigure parent = this.findMatchingParent(ref);
                    if (parent != null) {
                        this.addToParent(ref, ghost, parent);
                        continue;
                    }
                    targetLayer.add(ghost);
                }
            }
            this.resetPhantomSelections();
            if (input instanceof IDiagramDiffAccessor && (phantom = this.phantomsMap.get(figureRef = this.getReferenceFigure(input.getComparison(), (View)((IDiagramDiffAccessor)left).getDiff().getView()))) != null) {
                int oldLineWidth = ((Shape)phantom.figure).getLineWidth();
                this.phantomSelection.put(phantom.figure, oldLineWidth);
                ((Shape)phantom.figure).setLineWidth(oldLineWidth + 2);
            }
        }
    }

    private void addToParent(IFigure ref, IFigure ghost, IFigure parent) {
        parent.add(ghost);
        Rectangle copyRef = ref.getBounds().getCopy();
        ref.getParent().translateToAbsolute((Translatable)copyRef);
        ghost.setBounds(copyRef);
    }

    private void resetPhantomSelections() {
        for (Map.Entry<IFigure, Integer> entry : this.phantomSelection.entrySet()) {
            IFigure fig = entry.getKey();
            int oldValue = entry.getValue();
            ((Shape)fig).setLineWidth(oldValue);
        }
        this.phantomSelection.clear();
    }

    private IFigure getReferenceFigureValue(Comparison comparison, DiagramDiff diff) {
        View viewRef = (View)diff.getView();
        return this.getReferenceFigure(comparison, viewRef);
    }

    private IMergeViewer.MergeViewerSide getTargetSide(Comparison comparison, View viewRef) {
        Match matchViewRef = comparison.getMatch((EObject)viewRef);
        IMergeViewer.MergeViewerSide side = null;
        side = matchViewRef.getLeft() == null ? IMergeViewer.MergeViewerSide.LEFT : IMergeViewer.MergeViewerSide.RIGHT;
        return side;
    }

    private IFigure findMatchingParentGhost(IFigure figure) {
        IFigure parent = figure.getParent();
        if (parent != null) {
            Phantom parentTarget = this.phantomsMap.get(parent);
            if (parentTarget == null) {
                return this.findMatchingParentGhost(parent);
            }
            return parentTarget.figure;
        }
        return parent;
    }

    private IFigure findMatchingParent(IFigure figure) {
        IFigure parent = figure.getParent();
        if (parent != null) {
            IFigure parentTarget = this.containerMap.get(parent);
            if (parentTarget == null) {
                return this.findMatchingParent(parent);
            }
            return parentTarget;
        }
        return parent;
    }

    private DiagramMergeViewer getViewer(IMergeViewer.MergeViewerSide side) {
        switch (side) {
            case LEFT: {
                return (DiagramMergeViewer)this.fLeft;
            }
            case RIGHT: {
                return (DiagramMergeViewer)this.fRight;
            }
            case ANCESTOR: {
                return (DiagramMergeViewer)this.fAncestor;
            }
        }
        return null;
    }

    private EObject getMatchView(Comparison comparison, View view, IMergeViewer.MergeViewerSide side) {
        Match match = comparison.getMatch((EObject)view);
        return this.getMatchView(match, side);
    }

    private EObject getMatchView(Match match, IMergeViewer.MergeViewerSide side) {
        switch (side) {
            case LEFT: {
                return match.getLeft();
            }
            case RIGHT: {
                return match.getRight();
            }
            case ANCESTOR: {
                return match.getOrigin();
            }
        }
        return null;
    }

    private IFigure getReferenceFigure(Comparison comparison, View view) {
        Match match;
        IMergeViewer.MergeViewerSide originSide = null;
        originSide = this.getMatchView(comparison, view, IMergeViewer.MergeViewerSide.ANCESTOR) != null ? IMergeViewer.MergeViewerSide.ANCESTOR : ((match = comparison.getMatch((EObject)view)).getLeft() != null ? IMergeViewer.MergeViewerSide.LEFT : IMergeViewer.MergeViewerSide.RIGHT);
        EObject origin = this.getMatchView(comparison, view, originSide);
        if (origin instanceof View) {
            return this.getFigure(comparison, (View)origin);
        }
        return null;
    }

    private IFigure getFigure(Comparison comparison, View view) {
        IMergeViewer.MergeViewerSide side = this.getSide(comparison, view);
        GraphicalEditPart originEditPart = (GraphicalEditPart)this.getViewer(side).getEditPart(view);
        return originEditPart.getFigure();
    }

    private IFigure createGhostFigure(IFigure ref, IMergeViewer.MergeViewerSide side, boolean isEltOfList) {
        Rectangle rect = ref.getBounds().getCopy();
        Object ghost = null;
        if (isEltOfList) {
            ghost = new Polyline();
            ghost.addPoint(new Point(rect.x, rect.y - 1));
            ghost.addPoint(new Point(rect.x + rect.width, rect.y - 1));
            ghost.setBackgroundColor(new Color((Device)Display.getCurrent(), new RGB(255, 0, 0)));
            ((Shape)ghost).setLineWidth(2);
        } else {
            ghost = new DeleteGhostImageFigure();
            ghost.setBounds(rect);
        }
        rect.performScale(((DiagramRootEditPart)this.getViewer(side).getGraphicalViewer().getRootEditPart()).getZoomManager().getZoom());
        ghost.setForegroundColor(new Color((Device)Display.getCurrent(), new RGB(255, 0, 0)));
        ((Shape)ghost).setAlpha(150);
        return ghost;
    }

    private IMergeViewer.MergeViewerSide getSide(Diff diff) {
        if (diff.getSource() == DifferenceSource.LEFT) {
            return IMergeViewer.MergeViewerSide.LEFT;
        }
        return IMergeViewer.MergeViewerSide.RIGHT;
    }

    private IMergeViewer.MergeViewerSide getSide(Comparison comparison, View view) {
        Match match = comparison.getMatch((EObject)view);
        if (match.getLeft() == view) {
            return IMergeViewer.MergeViewerSide.LEFT;
        }
        if (match.getRight() == view) {
            return IMergeViewer.MergeViewerSide.RIGHT;
        }
        if (match.getOrigin() == view) {
            return IMergeViewer.MergeViewerSide.ANCESTOR;
        }
        return null;
    }

    private class Phantom {
        public IFigure figure;
        public IFigure layer;

        public Phantom(IFigure figure, IFigure layer) {
            this.figure = figure;
            this.layer = layer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PhantomsManager {
        private Map<IFigure, MatchFigure> relevantFigures = new HashMap<IFigure, MatchFigure>();
        private List<MatchFigure> matchedFigures = new ArrayList<MatchFigure>();
        private Map<IFigure, IFigure> phantoms = new HashMap<IFigure, IFigure>();

        PhantomsManager() {
        }

        public void initCacheFigures(Comparison comparison) {
            List<Match> matches = this.getAllMatches(comparison);
            for (Match match : matches) {
                this.createMatchFigure(match);
            }
            for (MatchFigure matchFigure : this.matchedFigures) {
                this.createParentMatchFigures(matchFigure);
            }
        }

        public void initPhantoms(Comparison comparison, Collection<Diff> deleteDifferences) {
            for (DiagramDiff diagramDiff : deleteDifferences) {
                Map<IMergeViewer.MergeViewerSide, IFigure> figures = this.getFigures(comparison, diagramDiff);
                View refView = (View)diagramDiff.getView();
                Match match = comparison.getMatch((EObject)refView);
                IMergeViewer.MergeViewerSide refSide = this.getReferenceSide(match);
                IFigure refFigure = figures.get(refSide);
                MatchFigure matchFigure = new MatchFigure(figures.get(IMergeViewer.MergeViewerSide.ANCESTOR), figures.get(IMergeViewer.MergeViewerSide.LEFT), figures.get(IMergeViewer.MergeViewerSide.RIGHT));
                IMergeViewer.MergeViewerSide targetSide = DiagramContentMergeViewer.this.getTargetSide(comparison, refView);
                IFigure ghost = DiagramContentMergeViewer.this.createGhostFigure(refFigure, targetSide, refView.eContainer() instanceof BasicCompartment);
                matchFigure.setGhost(targetSide, ghost);
                this.relevantFigures.put(refFigure, matchFigure);
                this.relevantFigures.put(ghost, matchFigure);
                this.phantoms.put(refFigure, ghost);
            }
        }

        public void attachPhantoms() {
            for (Map.Entry<IFigure, IFigure> entry : this.phantoms.entrySet()) {
                IFigure refFigure = entry.getKey();
                MatchFigure matchFigure = this.relevantFigures.get(refFigure);
                MatchFigure matchFigureParent = this.relevantFigures.get(refFigure.getParent());
                IFigure ghost = matchFigure.ghost;
                if (ghost == null) continue;
                IFigure targetParent = matchFigureParent.getFigure(matchFigure.getSide(ghost));
                IFigure targetLayer = LayerManager.Helper.find((EditPart)DiagramContentMergeViewer.this.getViewer(matchFigure.getSide(ghost)).getEditPart(null)).getLayer((Object)"Scalable Layers");
                if (targetParent instanceof FreeformLayeredPane) {
                    targetLayer.add(ghost);
                    continue;
                }
                targetParent.add(ghost);
            }
        }

        private IMergeViewer.MergeViewerSide getReferenceSide(Match match) {
            EObject origin = match.getOrigin();
            if (origin != null) {
                return IMergeViewer.MergeViewerSide.ANCESTOR;
            }
            EObject left = match.getLeft();
            EObject right = match.getRight();
            if (left != null) {
                return IMergeViewer.MergeViewerSide.LEFT;
            }
            if (right != null) {
                return IMergeViewer.MergeViewerSide.RIGHT;
            }
            return null;
        }

        private ViewSide getReferenceView(Match match) {
            switch (this.getReferenceSide(match)) {
                case ANCESTOR: {
                    return new ViewSide(IMergeViewer.MergeViewerSide.ANCESTOR, (View)match.getOrigin());
                }
                case LEFT: {
                    return new ViewSide(IMergeViewer.MergeViewerSide.LEFT, (View)match.getLeft());
                }
                case RIGHT: {
                    return new ViewSide(IMergeViewer.MergeViewerSide.RIGHT, (View)match.getRight());
                }
            }
            return null;
        }

        private List<Match> getAllMatches(Comparison comparison) {
            ArrayList<Match> result = new ArrayList<Match>();
            for (Match match : comparison.getMatches()) {
                result.add(match);
                result.addAll(Lists.newArrayList((Iterable)match.getAllSubmatches()));
            }
            return result;
        }

        private List<Match> getDeepestMatches(Comparison comparison) {
            ArrayList<Match> result = new ArrayList<Match>();
            for (Match match : comparison.getMatches()) {
                result.addAll(this.getDeepestMatches(match));
            }
            return result;
        }

        /*
         * Unable to fully structure code
         */
        private List<Match> getDeepestMatches(Match match) {
            block1: {
                result = new ArrayList<Match>();
                subMatches = match.getAllSubmatches().iterator();
                if (subMatches.hasNext()) ** GOTO lbl11
                result.add(match);
                break block1;
lbl-1000:
                // 1 sources

                {
                    subMatch = (Match)subMatches.next();
                    if (!subMatch.getSubmatches().isEmpty()) continue;
                    result.add(subMatch);
lbl11:
                    // 3 sources

                    ** while (subMatches.hasNext())
                }
            }
            return result;
        }

        private Map<IMergeViewer.MergeViewerSide, IFigure> getFigures(Comparison comparison, DiagramDiff diff) {
            HashMap<IMergeViewer.MergeViewerSide, IFigure> result = new HashMap<IMergeViewer.MergeViewerSide, IFigure>();
            View view = (View)diff.getView();
            Match match = comparison.getMatch((EObject)view);
            View origin = (View)match.getOrigin();
            result.putAll(this.getFigure(comparison, origin));
            View left = (View)match.getLeft();
            result.putAll(this.getFigure(comparison, left));
            View right = (View)match.getRight();
            result.putAll(this.getFigure(comparison, right));
            return result;
        }

        private IFigure getFigure(ViewSide viewSide) {
            GraphicalEditPart originEditPart = (GraphicalEditPart)DiagramContentMergeViewer.this.getViewer(viewSide.side).getEditPart(viewSide.view);
            return originEditPart.getFigure();
        }

        private Map<IMergeViewer.MergeViewerSide, IFigure> getFigure(Comparison comparison, View view) {
            HashMap<IMergeViewer.MergeViewerSide, IFigure> result = new HashMap<IMergeViewer.MergeViewerSide, IFigure>();
            if (view != null) {
                IMergeViewer.MergeViewerSide side = DiagramContentMergeViewer.this.getSide(comparison, view);
                GraphicalEditPart editPart = (GraphicalEditPart)DiagramContentMergeViewer.this.getViewer(side).getEditPart(view);
                result.put(side, editPart.getFigure());
            }
            return result;
        }

        private MatchFigure createMatchFigure(Match match) {
            IFigure originFigure = null;
            IFigure leftFigure = null;
            IFigure rightFigure = null;
            if (match.getOrigin() != null) {
                originFigure = this.getFigure(new ViewSide(IMergeViewer.MergeViewerSide.ANCESTOR, (View)match.getOrigin()));
            }
            if (match.getLeft() != null) {
                leftFigure = this.getFigure(new ViewSide(IMergeViewer.MergeViewerSide.LEFT, (View)match.getLeft()));
            }
            if (match.getRight() != null) {
                rightFigure = this.getFigure(new ViewSide(IMergeViewer.MergeViewerSide.RIGHT, (View)match.getRight()));
            }
            MatchFigure matchFigure = this.createMatchFigure(originFigure, leftFigure, rightFigure);
            this.matchedFigures.add(matchFigure);
            matchFigure.match = match;
            return matchFigure;
        }

        private MatchFigure createMatchFigure(IFigure origin, IFigure left, IFigure right) {
            MatchFigure matchFigure = new MatchFigure(origin, left, right);
            if (origin != null) {
                this.relevantFigures.put(origin, matchFigure);
            }
            if (left != null) {
                this.relevantFigures.put(left, matchFigure);
            }
            if (right != null) {
                this.relevantFigures.put(right, matchFigure);
            }
            return matchFigure;
        }

        private void createParentMatchFigures(MatchFigure matchFigure) {
            IFigure origin = matchFigure.origin;
            IFigure left = matchFigure.left;
            IFigure right = matchFigure.right;
            while (this.createParentMatchFigure(origin, left, right)) {
                if (origin != null) {
                    origin = origin.getParent();
                }
                if (left != null) {
                    left = left.getParent();
                }
                if (right == null) continue;
                right = right.getParent();
            }
        }

        private boolean createParentMatchFigure(IFigure origin, IFigure left, IFigure right) {
            IFigure originParent = null;
            IFigure leftParent = null;
            IFigure rightParent = null;
            if (left != null && ((leftParent = left.getParent()) == null || this.relevantFigures.get(leftParent) != null)) {
                return false;
            }
            if (right != null && ((rightParent = right.getParent()) == null || this.relevantFigures.get(rightParent) != null)) {
                return false;
            }
            if (origin != null && ((originParent = origin.getParent()) == null || this.relevantFigures.get(originParent) != null)) {
                return false;
            }
            this.createMatchFigure(originParent, leftParent, rightParent);
            return true;
        }

        private IFigure getFigure(MatchFigure matchFigure, IMergeViewer.MergeViewerSide side) {
            switch (side) {
                case LEFT: {
                    return matchFigure.left;
                }
                case RIGHT: {
                    return matchFigure.right;
                }
                case ANCESTOR: {
                    return matchFigure.origin;
                }
            }
            return null;
        }

        final class MatchFigure {
            public IFigure origin;
            public IFigure left;
            public IFigure right;
            public Match match;
            public IFigure ghost;

            public MatchFigure(IFigure origin, IFigure left, IFigure right) {
                this.origin = origin;
                this.left = left;
                this.right = right;
            }

            public MatchFigure(IFigure origin, IFigure left, IFigure right, Match match) {
                this.origin = origin;
                this.left = left;
                this.right = right;
                this.match = match;
            }

            public void setGhost(IMergeViewer.MergeViewerSide side, IFigure ghost) {
                this.ghost = ghost;
                switch (side) {
                    case ANCESTOR: {
                        this.origin = ghost;
                        break;
                    }
                    case LEFT: {
                        this.left = ghost;
                        break;
                    }
                    case RIGHT: {
                        this.right = ghost;
                    }
                }
            }

            public IMergeViewer.MergeViewerSide getSide(IFigure figure) {
                if (figure == this.origin) {
                    return IMergeViewer.MergeViewerSide.ANCESTOR;
                }
                if (figure == this.left) {
                    return IMergeViewer.MergeViewerSide.LEFT;
                }
                if (figure == this.right) {
                    return IMergeViewer.MergeViewerSide.RIGHT;
                }
                return null;
            }

            public IFigure getFigure(IMergeViewer.MergeViewerSide side) {
                switch (side) {
                    case ANCESTOR: {
                        return this.origin;
                    }
                    case LEFT: {
                        return this.left;
                    }
                    case RIGHT: {
                        return this.right;
                    }
                }
                return null;
            }
        }

        final class ViewSide {
            public IMergeViewer.MergeViewerSide side;
            public View view;

            public ViewSide(IMergeViewer.MergeViewerSide side, View view) {
                this.side = side;
                this.view = view;
            }
        }
    }
}

