/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.accessor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramNodeAccessor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramIDEMatchAccessorImpl
implements IDiagramNodeAccessor,
ITypedElement,
IStreamContentAccessor {
    private Match fMatch;
    private IMergeViewer.MergeViewerSide fSide;
    protected Comparison fComparison;

    public DiagramIDEMatchAccessorImpl(Match match, IMergeViewer.MergeViewerSide side) {
        this.fMatch = match;
        this.fSide = side;
        this.fComparison = match.getComparison();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Image getImage() {
        return null;
    }

    public String getType() {
        return "diagramcompare_match";
    }

    public InputStream getContents() throws CoreException {
        return new ByteArrayInputStream(new byte[]{32});
    }

    @Override
    public EObject getEObject(IMergeViewer.MergeViewerSide side) {
        return this.getEObject(this.fMatch, side);
    }

    protected EObject getEObject(Match match, IMergeViewer.MergeViewerSide side) {
        switch (side) {
            case LEFT: {
                return match.getLeft();
            }
            case RIGHT: {
                return match.getRight();
            }
            case ANCESTOR: {
                return match.getOrigin();
            }
        }
        return null;
    }

    @Override
    public Diagram getDiagram(IMergeViewer.MergeViewerSide side) {
        Diagram diagram;
        EObject obj = this.getEObject(side);
        if (obj != null) {
            return this.getDiagram(obj);
        }
        obj = this.getEObject(this.getOpposite(side));
        if (obj != null && (diagram = this.getDiagram(obj)) != null) {
            Match diagramMatch = this.fComparison.getMatch((EObject)diagram);
            return (Diagram)this.getEObject(diagramMatch, side);
        }
        return null;
    }

    @Override
    public Diagram getOwnedDiagram() {
        return this.getDiagram(this.fSide);
    }

    @Override
    public View getOwnedView() {
        View result = (View)this.getEObject(this.fSide);
        if (result == null) {
            result = this.getDiagram(this.fSide);
        }
        return result;
    }

    protected Diagram getDiagram(EObject obj) {
        if (obj instanceof Diagram) {
            return (Diagram)obj;
        }
        if (obj instanceof View) {
            return ((View)obj).getDiagram();
        }
        return null;
    }

    @Override
    public Comparison getComparison() {
        return this.fComparison;
    }

    @Override
    public IMergeViewer.MergeViewerSide getOriginSide() {
        EObject origin = this.getEObject(IMergeViewer.MergeViewerSide.ANCESTOR);
        if (origin == null) {
            return this.getOpposite(this.fSide);
        }
        return IMergeViewer.MergeViewerSide.ANCESTOR;
    }

    @Override
    public IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    @Override
    public List<Diff> getAllDiffs() {
        return this.fComparison.getDifferences();
    }

    private IMergeViewer.MergeViewerSide getOpposite(IMergeViewer.MergeViewerSide side) {
        if (side == IMergeViewer.MergeViewerSide.LEFT) {
            return IMergeViewer.MergeViewerSide.RIGHT;
        }
        return IMergeViewer.MergeViewerSide.LEFT;
    }
}

