/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.FeatureMap;

final class EObjectUtil {
    private EObjectUtil() {
    }

    public static String getLabel(EObject object) {
        String ret = null;
        if (object == null) {
            ret = "<null>";
        } else {
            Object value;
            EObject eObject = object;
            EClass eClass = eObject.eClass();
            ret = String.valueOf(eClass.getName()) + "@" + Integer.toHexString(object.hashCode());
            EStructuralFeature feature = EObjectUtil.getLabelFeature(eClass);
            if (feature != null && (value = eObject.eGet(feature)) != null) {
                ret = String.valueOf(ret) + " " + value.toString();
            }
        }
        return ret;
    }

    private static EStructuralFeature getLabelFeature(EClass eClass) {
        if (eClass == EcorePackage.Literals.ENAMED_ELEMENT) {
            return EcorePackage.Literals.ENAMED_ELEMENT__NAME;
        }
        EAttribute result = null;
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            if (eAttribute.isMany() || eAttribute.getEType().getInstanceClass() == FeatureMap.Entry.class) continue;
            if ("name".equalsIgnoreCase(eAttribute.getName())) {
                result = eAttribute;
                break;
            }
            if (result == null) {
                result = eAttribute;
                continue;
            }
            if (eAttribute.getEAttributeType().getInstanceClass() != String.class || result.getEAttributeType().getInstanceClass() == String.class) continue;
            result = eAttribute;
        }
        return result;
    }
}

