/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.accessor.IAccessorFactory;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffContainer;
import org.eclipse.jface.util.SafeRunnable;

public abstract class AbstractEDiffNode
extends AbstractEDiffContainer
implements ICompareInput {
    private final ListenerList fListener = new ListenerList();

    public AbstractEDiffNode(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.fListener.add((Object)listener);
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.fListener.remove((Object)listener);
    }

    protected void fireChange() {
        if (this.fListener != null) {
            Object[] listeners = this.fListener.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)listeners[i];
                SafeRunnable runnable = new SafeRunnable(){

                    public void run() throws Exception {
                        listener.compareInputChanged((ICompareInput)AbstractEDiffNode.this);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
                ++i;
            }
        }
    }

    public void copy(boolean leftToRight) {
    }

    protected IAccessorFactory getAccessorFactoryForTarget() {
        IAccessorFactory.Registry factoryRegistry = EMFCompareIDEUIPlugin.getDefault().getAccessorFactoryRegistry();
        return factoryRegistry.getHighestRankingFactory(this.getTarget());
    }

    public ITypedElement getAncestor() {
        IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
        if (accessorFactory != null) {
            return accessorFactory.createAncestor(this.getAdapterFactory(), this.getTarget());
        }
        return null;
    }

    public ITypedElement getLeft() {
        IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
        if (accessorFactory != null) {
            return accessorFactory.createLeft(this.getAdapterFactory(), this.getTarget());
        }
        return null;
    }

    public ITypedElement getRight() {
        IAccessorFactory accessorFactory = this.getAccessorFactoryForTarget();
        if (accessorFactory != null) {
            return accessorFactory.createRight(this.getAdapterFactory(), this.getTarget());
        }
        return null;
    }
}

