/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff.internal.extension;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.uml2.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.diff.internal.extension.IDiffExtensionFactory;
import org.eclipse.emf.compare.util.CompareSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.UML2Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiffExtensionFactory
implements IDiffExtensionFactory {
    private final Predicate<Diff> REFINING_PREDICATE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return AbstractDiffExtensionFactory.this.isPartOfRefiningDifference(diff);
        }
    };
    private final Predicate<Diff> REQUIRES_ADD_DISCRIMINANT_PREDICATE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return AbstractDiffExtensionFactory.this.getExtensionKind().isInstance(diff) && ((UMLDiff)diff).getKind().equals((Object)DifferenceKind.ADD);
        }
    };
    private final Predicate<Diff> REQUIRES_CHANGE_DISCRIMINANT_PREDICATE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return AbstractDiffExtensionFactory.this.getExtensionKind().isInstance(diff) && ((UMLDiff)diff).getKind().equals((Object)DifferenceKind.CHANGE);
        }
    };
    private CompareSwitch<DifferenceKind> differenceKindCompareSwitch = new CompareSwitch<DifferenceKind>(){

        public DifferenceKind caseAttributeChange(AttributeChange object) {
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionAdd(object)) {
                return DifferenceKind.ADD;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionDelete(object)) {
                return DifferenceKind.DELETE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionChange(object)) {
                return DifferenceKind.CHANGE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionMove(object)) {
                return DifferenceKind.MOVE;
            }
            return (DifferenceKind)super.caseAttributeChange(object);
        }

        public DifferenceKind caseReferenceChange(ReferenceChange object) {
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionAdd(object)) {
                return DifferenceKind.ADD;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionDelete(object)) {
                return DifferenceKind.DELETE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionChange(object)) {
                return DifferenceKind.CHANGE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionMove(object)) {
                return DifferenceKind.MOVE;
            }
            return (DifferenceKind)super.caseReferenceChange(object);
        }

        public DifferenceKind caseResourceAttachmentChange(ResourceAttachmentChange object) {
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionAdd(object)) {
                return DifferenceKind.ADD;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionDelete(object)) {
                return DifferenceKind.DELETE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionChange(object)) {
                return DifferenceKind.CHANGE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionMove(object)) {
                return DifferenceKind.MOVE;
            }
            return (DifferenceKind)super.caseResourceAttachmentChange(object);
        }
    };

    @Override
    public boolean handles(Diff input) {
        return this.getRelatedExtensionKind(input) != null && !this.isExtensionAlreadyExist(input) && !this.isChangeOnAddOrDelete(input);
    }

    @Override
    public Diff create(Diff input) {
        UMLDiff ret = this.createExtension();
        EObject discriminant = this.getDiscriminantFromDiff(input);
        DifferenceKind extensionKind = this.getRelatedExtensionKind(input);
        ret.setDiscriminant(discriminant);
        ret.setKind(extensionKind);
        if (discriminant != null) {
            if (input instanceof ResourceAttachmentChange && ret instanceof StereotypeApplicationChange) {
                ret.getRefinedBy().addAll((Collection)input.getMatch().getDifferences());
            } else if (extensionKind == DifferenceKind.DELETE) {
                ret.getRefinedBy().add((Object)input);
            } else {
                this.fillRefiningDifferences(input.getMatch().getComparison(), ret, discriminant);
            }
        }
        if (extensionKind == DifferenceKind.ADD || extensionKind == DifferenceKind.DELETE) {
            if (input instanceof ReferenceChange) {
                ret.setEReference(((ReferenceChange)input).getReference());
            } else if (input instanceof ResourceAttachmentChange && ret instanceof StereotypeApplicationChange) {
                EList candidates = input.getMatch().getDifferences();
                for (Diff candidate : candidates) {
                    if (!(candidate instanceof ReferenceChange)) continue;
                    ret.setEReference(((ReferenceChange)candidate).getReference());
                }
            }
        }
        return ret;
    }

    protected void fillRefiningDifferences(Comparison comparison, UMLDiff diffExtension, EObject discriminant) {
        for (EObject elt : this.getPotentialChangedValuesFromDiscriminant(discriminant)) {
            this.beRefinedByCrossReferences(comparison, elt, diffExtension, this.REFINING_PREDICATE);
        }
    }

    @Override
    public void fillRequiredDifferences(Comparison comparison, UMLDiff extension) {
        EObject discriminant;
        if (this.getExtensionKind().isInstance(extension) && (discriminant = extension.getDiscriminant()) != null) {
            if (extension.getKind().equals((Object)DifferenceKind.CHANGE)) {
                extension.getRequires().addAll(this.findCrossReferences(comparison, discriminant, this.REQUIRES_ADD_DISCRIMINANT_PREDICATE));
            } else if (extension.getKind().equals((Object)DifferenceKind.DELETE)) {
                extension.getRequires().addAll(this.findCrossReferences(comparison, discriminant, this.REQUIRES_CHANGE_DISCRIMINANT_PREDICATE));
            }
        }
    }

    @Override
    public Match getParentMatch(Diff input) {
        EObject discriminant;
        if (this.getRelatedExtensionKind(input) == DifferenceKind.CHANGE && (discriminant = this.getDiscriminantFromDiff(input)) != null) {
            Match match = input.getMatch().getComparison().getMatch(discriminant);
            if (match.eContainer() instanceof Match) {
                return (Match)match.eContainer();
            }
            return match;
        }
        return input.getMatch();
    }

    protected abstract UMLDiff createExtension();

    protected boolean isPartOfRefiningDifference(Diff diff) {
        return diff instanceof ReferenceChange && this.getRelatedExtensionKind(diff) == DifferenceKind.CHANGE;
    }

    private boolean isExtensionAlreadyExist(Diff input) {
        for (Diff diff : input.getRefines()) {
            if (!(diff instanceof UMLDiff) || !((UMLDiff)diff).getDiscriminant().equals(this.getDiscriminantFromDiff(input))) continue;
            return true;
        }
        return false;
    }

    private boolean isChangeOnAddOrDelete(Diff input) {
        if (this.getRelatedExtensionKind(input) == DifferenceKind.CHANGE) {
            EObject discriminant;
            Comparison comparison = input.getMatch().getComparison();
            if (!Collections2.filter((Collection)comparison.getMatch(discriminant = this.getDiscriminantFromDiff(input)).getDifferences(), (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class)).isEmpty()) {
                return true;
            }
            EList candidates = comparison.getDifferences(discriminant);
            for (Diff diff : candidates) {
                DifferenceKind relatedExtensionKind;
                if (diff == input || (relatedExtensionKind = this.getRelatedExtensionKind(diff)) != DifferenceKind.ADD && relatedExtensionKind != DifferenceKind.DELETE || this.getDiscriminantFromDiff(diff) != discriminant) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract EObject getDiscriminantFromDiff(Diff var1);

    protected abstract List<EObject> getPotentialChangedValuesFromDiscriminant(EObject var1);

    protected DifferenceKind getRelatedExtensionKind(Diff input) {
        return (DifferenceKind)this.differenceKindCompareSwitch.doSwitch((EObject)input);
    }

    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionAdd(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionAdd(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(ResourceAttachmentChange input) {
        return false;
    }

    protected EStructuralFeature.Setting getInverseReferences(EObject object, Predicate<EStructuralFeature.Setting> predicate) {
        Iterator crossReferences = UML2Util.getInverseReferences((EObject)object).iterator();
        try {
            return (EStructuralFeature.Setting)Iterators.find(crossReferences, predicate);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected final List<Diff> findCrossReferences(Comparison comparison, EObject lookup, Predicate<Diff> p) {
        ArrayList<Diff> result = new ArrayList<Diff>();
        for (Diff diff : comparison.getDifferences(lookup)) {
            if (!p.apply((Object)diff)) continue;
            result.add(diff);
        }
        return result;
    }

    protected final void beRefinedByCrossReferences(Comparison comparison, EObject lookup, UMLDiff refinedExtension, Predicate<Diff> p) {
        for (Diff diffElement : this.findCrossReferences(comparison, lookup, p)) {
            refinedExtension.getRefinedBy().add((Object)diffElement);
        }
    }
}

