/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.provider.ConflictItemProvider;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictItemProviderSpec
extends ConflictItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private static Function<Diff, Iterable<Diff>> getSubDiffs = new Function<Diff, Iterable<Diff>>(){

        public Iterable<Diff> apply(Diff diff) {
            Match matchOfValue;
            Match match;
            if (diff instanceof ReferenceChange && !(match = diff.getMatch()).equals(matchOfValue = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff).getValue())) && match.getSubmatches().contains((Object)matchOfValue)) {
                Iterable subDiffs = matchOfValue.getAllDifferences();
                return ImmutableSet.copyOf((Iterable)subDiffs);
            }
            return ImmutableSet.of();
        }
    };

    public ConflictItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    @Override
    public Object getImage(Object object) {
        if (((Conflict)object).getKind() == ConflictKind.PSEUDO) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/PseudoConflict"));
        }
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Conflict"));
    }

    public Collection<?> getChildren(Object object) {
        Conflict conflict = (Conflict)object;
        EList differences = conflict.getDifferences();
        LinkedHashSet filteredDifferences = Sets.newLinkedHashSet();
        for (Diff diff : differences) {
            boolean subdiff = false;
            for (Diff diffParent : differences) {
                if (diff.equals(diffParent) || !Iterables.contains((Iterable)((Iterable)getSubDiffs.apply((Object)diffParent)), (Object)diff)) continue;
                subdiff = true;
                break;
            }
            if (subdiff) continue;
            filteredDifferences.add(diff);
        }
        return filteredDifferences;
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        Conflict conflict = (Conflict)object;
        int size = conflict.getDifferences().size();
        String kind = conflict.getKind().getName().toLowerCase();
        ComposedStyledString ret = new ComposedStyledString(String.valueOf(kind.substring(0, 1).toUpperCase()) + kind.substring(1) + " " + EMFCompareEditMessages.getString("conflict"));
        ret.append(" [" + size + " " + EMFCompareEditMessages.getString("difference"), IStyledString.Style.DECORATIONS_STYLER);
        if (size > 1) {
            ret.append(EMFCompareEditMessages.getString("plural"), IStyledString.Style.DECORATIONS_STYLER);
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    @Override
    public String getDescription(Object object) {
        Conflict conflict = (Conflict)object;
        int size = conflict.getDifferences().size() - 1;
        String ret = String.valueOf(conflict.getKind().getName()) + " conflict with " + size + " other difference";
        if (size > 1) {
            ret = String.valueOf(ret) + "s";
        }
        return ret;
    }
}

