/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.m2m.atl.emftvm.util.EnumLiteral;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConversionList
extends LazyList<Object> {
    public EnumConversionList(Collection<Object> dataSource) {
        super(dataSource);
    }

    protected final Object convert(Object object) {
        if (object instanceof Enumerator) {
            return new EnumLiteral(object.toString());
        }
        return object;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.dataSource == null) {
            return Collections.unmodifiableCollection(this.cache).iterator();
        }
        return new EnumConversionIterator();
    }

    @Override
    public int size() {
        if (this.dataSource == null) {
            return this.cache.size();
        }
        return ((Collection)this.dataSource).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumConversionList cache() {
        Collection collection = this.cache;
        synchronized (collection) {
            if (this.dataSource != null) {
                this.cache.clear();
                for (Object o : this.dataSource) {
                    this.cache.add(this.convert(o));
                }
                assert (this.cache.size() == ((Collection)this.dataSource).size());
                this.dataSource = null;
            }
        }
        return this;
    }

    @Override
    protected void createCache() {
        if (this.dataSource == null) {
            this.cache = Collections.emptyList();
            this.occurrences = Collections.emptyMap();
        } else {
            this.cache = new ArrayList(((Collection)this.dataSource).size());
        }
        assert (this.cache instanceof List);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EnumConversionIterator
    extends LazyCollection.CachingIterator {
        public EnumConversionIterator() {
            super(EnumConversionList.this.dataSource.iterator());
        }

        @Override
        public Object next() {
            Object next = EnumConversionList.this.convert(this.inner.next());
            this.updateCache(next);
            return next;
        }
    }
}

