/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.text.AtlCodeReader;
import org.eclipse.swt.widgets.Display;

public final class AtlReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final String RULE_BLOCK_START = "rule";
    private static final String HELPER_BLOCK_START = "helper";
    protected final Map<Annotation, Position> addedAnnotations = new HashMap<Annotation, Position>();
    protected final Map<Annotation, Position> currentAnnotations = new HashMap<Annotation, Position>();
    protected final List<Annotation> deletedAnnotations = new ArrayList<Annotation>();
    protected final AtlEditor editor;
    protected final Map<Annotation, Position> modifiedAnnotations = new HashMap<Annotation, Position>();
    private IDocument document;
    private int offset;
    private AtlCodeReader reader = new AtlCodeReader();

    public AtlReconcilingStrategy(AtlEditor editor) {
        this.editor = editor;
    }

    public void initialReconcile() {
        this.offset = 0;
        this.computePositions();
        this.updateFoldingStructure();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion partition) {
        this.offset = partition.getOffset();
        this.computePositions();
        this.updateFoldingStructure();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    private void computePositions() {
        this.deletedAnnotations.clear();
        this.modifiedAnnotations.clear();
        this.addedAnnotations.clear();
        this.deletedAnnotations.addAll(this.currentAnnotations.keySet());
        for (Map.Entry<Annotation, Position> entry : this.currentAnnotations.entrySet()) {
            Position position = entry.getValue();
            if (position.getOffset() + position.getLength() >= this.offset) continue;
            this.deletedAnnotations.remove(entry.getKey());
        }
        try {
            boolean eof = this.seekChars(new char[]{RULE_BLOCK_START.charAt(0), HELPER_BLOCK_START.charAt(0)});
            int startOffset = this.offset;
            while (!eof) {
                ++this.offset;
                if (RULE_BLOCK_START.equals(this.document.get(startOffset, RULE_BLOCK_START.length()))) {
                    eof = this.seekChars(new char[]{'{'});
                    ++this.offset;
                    IRegion region = this.editor.getBracketMatcher().match(this.document, this.offset);
                    if (region != null) {
                        this.offset = region.getOffset() + region.getLength();
                        eof = this.seekChars(new char[]{'\n'});
                        int endOffset = this.offset + 1;
                        if (this.document.getNumberOfLines(startOffset, endOffset - startOffset) > 2) {
                            this.createOrUpdateAnnotation(startOffset, endOffset - startOffset, false);
                        }
                    }
                } else if (HELPER_BLOCK_START.equals(this.document.get(startOffset, HELPER_BLOCK_START.length()))) {
                    ++this.offset;
                    eof = this.seekChars(new char[]{RULE_BLOCK_START.charAt(0), HELPER_BLOCK_START.charAt(0)});
                    while (!(eof || RULE_BLOCK_START.equals(this.document.get(this.offset, RULE_BLOCK_START.length())) || HELPER_BLOCK_START.equals(this.document.get(this.offset, HELPER_BLOCK_START.length())))) {
                        ++this.offset;
                        eof = this.seekChars(new char[]{RULE_BLOCK_START.charAt(0), HELPER_BLOCK_START.charAt(0)});
                    }
                    eof = this.backwardSeekChars(new char[]{';'}, startOffset);
                    eof = this.seekChars(new char[]{'\n'});
                    int endOffset = this.offset + 1;
                    if (this.document.getNumberOfLines(startOffset, endOffset - startOffset) > 2) {
                        this.createOrUpdateAnnotation(startOffset, endOffset - startOffset, false);
                    }
                }
                eof = this.seekChars(new char[]{RULE_BLOCK_START.charAt(0), HELPER_BLOCK_START.charAt(0)});
                startOffset = this.offset;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {}
        Iterator<Annotation> iterator = this.deletedAnnotations.iterator();
        while (iterator.hasNext()) {
            this.currentAnnotations.remove(iterator.next());
        }
    }

    private boolean seekChars(char[] startChars) throws BadLocationException, IOException {
        this.reader.configureForwardReader(this.document, this.offset, this.document.getLength(), true, true);
        int c = this.reader.read();
        this.offset = this.reader.getOffset();
        while (c != -1 && !this.contains(startChars, this.document.getChar(this.offset))) {
            c = this.reader.read();
            this.offset = this.reader.getOffset();
        }
        return c == -1;
    }

    private boolean backwardSeekChars(char[] startChars, int start) throws BadLocationException, IOException {
        this.reader.configureBackwardReader(this.document, this.offset, true, true);
        int c = this.reader.read();
        this.offset = this.reader.getOffset();
        while (this.offset > start && c != -1 && !this.contains(startChars, this.document.getChar(this.offset))) {
            c = this.reader.read();
            this.offset = this.reader.getOffset();
        }
        return c == -1;
    }

    private boolean contains(char[] chars, char test) {
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == test) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void createOrUpdateAnnotation(int newOffset, int newLength, boolean initiallyCollapsed) throws BadLocationException {
        boolean createAnnotation = true;
        HashMap<Annotation, Position> copy = new HashMap<Annotation, Position>(this.currentAnnotations);
        String text = this.document.get(newOffset, newLength);
        for (Map.Entry entry : copy.entrySet()) {
            if (!((Annotation)entry.getKey()).getText().equals(text)) continue;
            createAnnotation = false;
            Position oldPosition = (Position)entry.getValue();
            if (oldPosition.getOffset() != newOffset || oldPosition.getLength() != newLength) {
                Position newPosition = new Position(newOffset, newLength);
                this.modifiedAnnotations.put((Annotation)entry.getKey(), newPosition);
                this.currentAnnotations.put((Annotation)entry.getKey(), newPosition);
            }
            this.deletedAnnotations.remove(entry.getKey());
            break;
        }
        if (createAnnotation) {
            ProjectionAnnotation annotation = new ProjectionAnnotation(initiallyCollapsed);
            annotation.setText(text);
            Position position = new Position(newOffset, newLength);
            this.currentAnnotations.put((Annotation)annotation, position);
            this.addedAnnotations.put((Annotation)annotation, position);
        }
    }

    private void updateFoldingStructure() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                AtlReconcilingStrategy.this.editor.updateFoldingStructure(AtlReconcilingStrategy.this.addedAnnotations, AtlReconcilingStrategy.this.deletedAnnotations, AtlReconcilingStrategy.this.modifiedAnnotations);
            }
        });
    }
}

