/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.model;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.PseudoReference;

public class ThreadToLocalReference
extends PseudoReference {
    private static final long serialVersionUID = 1L;
    private int localObjectId;
    private GCRootInfo[] gcRootInfo;

    public ThreadToLocalReference(ISnapshot snapshot, long address, String name, int localObjectId, GCRootInfo[] gcRootInfo) {
        super(snapshot, address, name);
        this.localObjectId = localObjectId;
        this.gcRootInfo = gcRootInfo;
    }

    @Override
    public int getObjectId() {
        return this.localObjectId;
    }

    public GCRootInfo[] getGcRootInfo() {
        return this.gcRootInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadToLocalReference other = (ThreadToLocalReference)obj;
        return this.localObjectId == other.localObjectId && Arrays.equals(this.gcRootInfo, other.gcRootInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.gcRootInfo), this.localObjectId);
    }
}

