/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.runtime.Assert;
import org.eclipse.m2e.wtp.internal.StringUtils;

public class DomUtils {
    public static final String getChildValue(Xpp3Dom parent, String childName) {
        Xpp3Dom dom;
        String result = null;
        if (parent != null && childName != null && (dom = parent.getChild(childName)) != null && dom.getValue() != null) {
            result = dom.getValue().trim();
        }
        return result;
    }

    public static final String getChildValue(Xpp3Dom parent, String childName, String defaultValue) {
        String result = DomUtils.getChildValue(parent, childName);
        return org.codehaus.plexus.util.StringUtils.defaultString((Object)result, (String)defaultValue);
    }

    public static final boolean getBooleanChildValue(Xpp3Dom parent, String childName) {
        return Boolean.valueOf(DomUtils.getChildValue(parent, childName));
    }

    public static final void removeChildren(Xpp3Dom node) {
        if (node == null) {
            return;
        }
        int i = node.getChildCount() - 1;
        while (i > -1) {
            node.removeChild(i);
            --i;
        }
    }

    public static String[] getChildrenAsStringArray(Xpp3Dom root, String childName) {
        Xpp3Dom[] children;
        String[] values = null;
        if (root != null && (children = root.getChildren(childName)) != null) {
            values = new String[children.length];
            int i = 0;
            Xpp3Dom[] xpp3DomArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom child = xpp3DomArray[n2];
                values[i++] = child.getValue();
                ++n2;
            }
        }
        return values;
    }

    public static String[] getPatternsAsArray(Xpp3Dom config, String patternParameterName) {
        Xpp3Dom excl;
        if (config != null && (excl = config.getChild(patternParameterName)) != null) {
            return StringUtils.tokenizeToStringArray(excl.getValue(), ",");
        }
        return new String[0];
    }

    public static final Xpp3Dom getOrCreateChildNode(Xpp3Dom parent, String childName) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)childName);
        Xpp3Dom dom = parent.getChild(childName);
        if (dom == null) {
            dom = new Xpp3Dom(childName);
            parent.addChild(dom);
        }
        return dom;
    }
}

