/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.wtp.AbstractFilteringSupportMavenPlugin;
import org.eclipse.m2e.wtp.JEEPackaging;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class AcrPluginConfiguration
extends AbstractFilteringSupportMavenPlugin {
    private static final IProjectFacetVersion DEFAULT_APPCLIENT_FACET_VERSION = IJ2EEFacetConstants.APPLICATION_CLIENT_50;
    final IMavenProjectFacade mavenProjectFacade;

    public AcrPluginConfiguration(IMavenProjectFacade facade) {
        MavenProject mavenProject = facade.getMavenProject();
        if (JEEPackaging.APP_CLIENT != JEEPackaging.getValue(mavenProject.getPackaging())) {
            throw new IllegalArgumentException("Maven project must have app-client packaging");
        }
        this.mavenProjectFacade = facade;
        Plugin plugin = mavenProject.getPlugin("org.apache.maven.plugins:maven-acr-plugin");
        if (plugin != null) {
            this.setConfiguration((Xpp3Dom)plugin.getConfiguration());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProjectFacetVersion getFacetVersion() {
        IFile applicationClientXml = this.getApplicationClientXml();
        if (applicationClientXml != null && applicationClientXml.isAccessible()) {
            try {
                InputStream is = applicationClientXml.getContents();
                try {
                    JavaEEQuickPeek jqp = new JavaEEQuickPeek(is);
                    switch (jqp.getVersion()) {
                        case 12: {
                            IProjectFacetVersion iProjectFacetVersion = IJ2EEFacetConstants.APPLICATION_CLIENT_12;
                            return iProjectFacetVersion;
                        }
                        case 13: {
                            IProjectFacetVersion iProjectFacetVersion = IJ2EEFacetConstants.APPLICATION_CLIENT_13;
                            return iProjectFacetVersion;
                        }
                        case 14: {
                            IProjectFacetVersion iProjectFacetVersion = IJ2EEFacetConstants.APPLICATION_CLIENT_14;
                            return iProjectFacetVersion;
                        }
                        case 50: {
                            IProjectFacetVersion iProjectFacetVersion = IJ2EEFacetConstants.APPLICATION_CLIENT_50;
                            return iProjectFacetVersion;
                        }
                        case 60: {
                            IProjectFacetVersion iProjectFacetVersion = IJ2EEFacetConstants.APPLICATION_CLIENT_60;
                            return iProjectFacetVersion;
                        }
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        if (!WTPProjectsUtil.hasInClassPath(this.mavenProjectFacade.getProject(), "javax.servlet.annotation.WebServlet")) return DEFAULT_APPCLIENT_FACET_VERSION;
        return IJ2EEFacetConstants.APPLICATION_CLIENT_60;
    }

    public IFile getApplicationClientXml() {
        IProject project = this.mavenProjectFacade.getProject();
        String contentDir = null;
        IPath[] iPathArray = this.mavenProjectFacade.getResourceLocations();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            contentDir = String.valueOf(path.toPortableString()) + "/META-INF";
            IFile applicationClientXml = project.getFolder(contentDir).getFile("application-client.xml");
            if (applicationClientXml.exists()) {
                return applicationClientXml;
            }
            ++n2;
        }
        return null;
    }

    public String getContentDirectory(IProject project) {
        IPath[] resources = MavenProjectUtils.getResourceLocations((IProject)project, (List)this.mavenProjectFacade.getMavenProject().getResources());
        return resources[0].toPortableString();
    }

    protected String getFilteringAttribute() {
        return "filterDeploymentDescriptor";
    }
}

