/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.jax_rs;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.jax_rs.Jax_RSConstants;

public class ResourceMethodDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-jax_rs";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit != null) {
            String[] methodDesignators = (String[])ArrayUtils.addAll((Object[])Jax_RSConstants.SET_OF_METHOD_DESIGNATORS_ANNOTATIONS, (Object[])new String[]{"jakarta.ws.rs.Path"});
            try {
                IType[] alltypes;
                IType[] iTypeArray = alltypes = unit.getAllTypes();
                int n = alltypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod[] methods;
                    IType type = iTypeArray[n2];
                    IMethod[] iMethodArray = methods = type.getMethods();
                    int n3 = methods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMethod method = iMethodArray[n4];
                        IAnnotation[] methodAnnotations = method.getAnnotations();
                        boolean isResourceMethod = false;
                        boolean isValid = true;
                        boolean isPublic = Flags.isPublic((int)method.getFlags());
                        IAnnotation[] iAnnotationArray = methodAnnotations;
                        int n5 = methodAnnotations.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IAnnotation annotation = iAnnotationArray[n6];
                            String matchedAnnotation = ResourceMethodDiagnosticsCollector.getMatchedJavaElementName(type, annotation.getElementName(), methodDesignators);
                            if (matchedAnnotation != null) {
                                if (isValid && !isPublic) {
                                    isValid = false;
                                }
                                if (!"jakarta.ws.rs.Path".equals(matchedAnnotation)) {
                                    isResourceMethod = true;
                                    break;
                                }
                            }
                            ++n6;
                        }
                        if (!isValid) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, "Only public methods can be exposed as resource methods", "NonPublicResourceMethod", null, DiagnosticSeverity.Error));
                        }
                        if (isResourceMethod) {
                            ILocalVariable[] parameters;
                            int numEntityParams = 0;
                            ILocalVariable[] iLocalVariableArray = parameters = method.getParameters();
                            int n7 = parameters.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                IAnnotation[] annotations;
                                ILocalVariable param = iLocalVariableArray[n8];
                                boolean isEntityParam = true;
                                IAnnotation[] iAnnotationArray2 = annotations = param.getAnnotations();
                                int n9 = annotations.length;
                                int n10 = 0;
                                while (n10 < n9) {
                                    IAnnotation annotation = iAnnotationArray2[n10];
                                    String matchedAnnotation = ResourceMethodDiagnosticsCollector.getMatchedJavaElementName(type, annotation.getElementName(), Jax_RSConstants.SET_OF_NON_ENTITY_PARAM_ANNOTATIONS);
                                    if (matchedAnnotation != null) {
                                        isEntityParam = false;
                                        break;
                                    }
                                    ++n10;
                                }
                                if (isEntityParam) {
                                    ++numEntityParams;
                                }
                                ++n8;
                            }
                            if (numEntityParams > 1) {
                                diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, "Resource methods cannot have more than one entity parameter", "ResourceMethodMultipleEntityParams", null, DiagnosticSeverity.Error));
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot calculate JAX-RS diagnostics", e);
            }
        }
    }
}

