/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.beanvalidation;

import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.beanvalidation.BeanValidationConstants;

public class BeanValidationDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-bean-validation";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit != null) {
            try {
                IType[] alltypes;
                IType[] iTypeArray = alltypes = unit.getAllTypes();
                int n = alltypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String matchedAnnotation;
                    IAnnotation annotation;
                    int n3;
                    int n4;
                    IAnnotation[] iAnnotationArray;
                    IAnnotation[] annotations;
                    IField[] allFields;
                    IType type = iTypeArray[n2];
                    IField[] iFieldArray = allFields = type.getFields();
                    int n5 = allFields.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IField field = iFieldArray[n6];
                        iAnnotationArray = annotations = field.getAnnotations();
                        n4 = annotations.length;
                        n3 = 0;
                        while (n3 < n4) {
                            annotation = iAnnotationArray[n3];
                            matchedAnnotation = BeanValidationDiagnosticsCollector.getMatchedJavaElementName(type, annotation.getElementName(), BeanValidationConstants.SET_OF_ANNOTATIONS.toArray(new String[0]));
                            if (matchedAnnotation != null) {
                                this.validAnnotation((IMember)field, annotation, matchedAnnotation, diagnostics);
                            }
                            ++n3;
                        }
                        ++n6;
                    }
                    IMethod[] allMethods = type.getMethods();
                    iFieldArray = allMethods;
                    n5 = allMethods.length;
                    n6 = 0;
                    while (n6 < n5) {
                        IField method = iFieldArray[n6];
                        iAnnotationArray = annotations = method.getAnnotations();
                        n4 = annotations.length;
                        n3 = 0;
                        while (n3 < n4) {
                            annotation = iAnnotationArray[n3];
                            matchedAnnotation = BeanValidationDiagnosticsCollector.getMatchedJavaElementName(type, annotation.getElementName(), BeanValidationConstants.SET_OF_ANNOTATIONS.toArray(new String[0]));
                            if (matchedAnnotation != null) {
                                this.validAnnotation((IMember)method, annotation, matchedAnnotation, diagnostics);
                            }
                            ++n3;
                        }
                        ++n6;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot calculate diagnostics", e);
            }
        }
    }

    private void validAnnotation(IMember element, IAnnotation annotation, String matchedAnnotation, List<Diagnostic> diagnostics) throws JavaModelException {
        IType declaringType = element.getDeclaringType();
        if (declaringType != null) {
            boolean isMethod;
            String annotationName = annotation.getElementName();
            boolean bl = isMethod = element instanceof IMethod;
            if (Flags.isStatic((int)element.getFlags())) {
                String source = isMethod ? "methods" : "fields";
                diagnostics.add(this.createDiagnostic((IJavaElement)element, declaringType.getCompilationUnit(), "Constraint annotations are not allowed on static " + source, "MakeNotStatic", annotationName, DiagnosticSeverity.Error));
            } else {
                String type;
                String source = isMethod ? "methods." : "fields.";
                String string = type = isMethod ? ((IMethod)element).getReturnType() : ((IField)element).getTypeSignature();
                if (matchedAnnotation.equals("jakarta.validation.constraints.AssertFalse") || matchedAnnotation.equals("jakarta.validation.constraints.AssertTrue")) {
                    if (!type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Boolean")) && !type.equals("Z")) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)element, declaringType.getCompilationUnit(), "The @" + annotationName + " annotation can only be used on boolean and Boolean type " + source, "FixTypeOfElement", annotationName, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.DecimalMax") || matchedAnnotation.equals("jakarta.validation.constraints.DecimalMin") || matchedAnnotation.equals("jakarta.validation.constraints.Digits")) {
                    if (!(type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("BigDecimal")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("BigInteger")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("CharSequence")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Byte")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Short")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Integer")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Long")) || type.equals("B") || type.equals("S") || type.equals("I") || type.equals("J"))) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)element, declaringType.getCompilationUnit(), "The @" + annotationName + " annotation can only be used on: \n- BigDecimal \n- BigInteger \n- CharSequence" + "\n- byte, short, int, long (and their respective wrappers) \n type " + source, "FixTypeOfElement", annotationName, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.Email")) {
                    if (!type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("String")) && !type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("CharSequence"))) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)element, declaringType.getCompilationUnit(), "The @" + annotationName + " annotation can only be used on String and CharSequence type " + source, "FixTypeOfElement", annotationName, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.Future") || matchedAnnotation.equals("jakarta.validation.constraints.FutureOrPresent") || matchedAnnotation.equals("jakarta.validation.constraints.Past") || matchedAnnotation.equals("jakarta.validation.constraints.PastOrPresent")) {
                    String dataType = BeanValidationDiagnosticsCollector.getDataTypeName(type);
                    String dataTypeFQName = BeanValidationDiagnosticsCollector.getMatchedJavaElementName(declaringType, dataType, BeanValidationConstants.SET_OF_DATE_TYPES.toArray(new String[0]));
                    if (dataTypeFQName == null) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)element, declaringType.getCompilationUnit(), "The @" + annotationName + " annotation can only be used on: Date, Calendar, Instant, " + "LocalDate, LocalDateTime, LocalTime, MonthDay, OffsetDateTime, " + "OffsetTime, Year, YearMonth, ZonedDateTime, " + "HijrahDate, JapaneseDate, JapaneseDate, MinguoDate and " + "ThaiBuddhistDate type " + source, "FixTypeOfElement", annotationName, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.Min") || matchedAnnotation.equals("jakarta.validation.constraints.Max")) {
                    if (!(type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("BigDecimal")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("BigInteger")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Byte")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Short")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Integer")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Long")) || type.equals("B") || type.equals("S") || type.equals("I") || type.equals("J"))) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)element, declaringType.getCompilationUnit(), "The @" + annotationName + " annotation can only be used on \n- BigDecimal \n- BigInteger" + "\n- byte, short, int, long (and their respective wrappers) \n type " + source, "FixTypeOfElement", annotationName, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.Negative") || matchedAnnotation.equals("jakarta.validation.constraints.NegativeOrZero") || matchedAnnotation.equals("jakarta.validation.constraints.Positive") || matchedAnnotation.equals("jakarta.validation.constraints.PostiveOrZero")) {
                    if (!(type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("BigDecimal")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("BigInteger")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Byte")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Short")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Integer")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Long")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Float")) || type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("Double")) || type.equals("B") || type.equals("S") || type.equals("I") || type.equals("J") || type.equals("F") || type.equals("D"))) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)element, declaringType.getCompilationUnit(), "The @" + annotationName + " annotation can only be used on \n- BigDecimal \n- BigInteger" + "\n- byte, short, int, long, float, double (and their respective wrappers) \n type " + source, "FixTypeOfElement", annotationName, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.NotBlank")) {
                    if (!type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("String")) && !type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("CharSequence"))) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)element, declaringType.getCompilationUnit(), "The @" + annotationName + " annotation can only be used on String and CharSequence type " + source, "FixTypeOfElement", annotationName, DiagnosticSeverity.Error));
                    }
                } else if (matchedAnnotation.equals("jakarta.validation.constraints.Pattern") && !type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("String")) && !type.equals(BeanValidationDiagnosticsCollector.getSignatureFormatOfType("CharSequence"))) {
                    diagnostics.add(this.createDiagnostic((IJavaElement)element, declaringType.getCompilationUnit(), "The @" + annotationName + " annotation can only be used on String and CharSequence type " + source, "FixTypeOfElement", annotationName, DiagnosticSeverity.Error));
                }
            }
        }
    }

    private static String getSignatureFormatOfType(String type) {
        return "Q" + type + ";";
    }

    private static String getDataTypeName(String type) {
        int length = type.length();
        if (length > 0 && type.charAt(0) == 'Q' && type.charAt(length - 1) == ';') {
            return type.substring(1, length - 1);
        }
        return type;
    }
}

