/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.format;

import java.util.ConcurrentModificationException;
import java.util.concurrent.Executor;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.ServerMessageHandler;
import org.eclipse.lsp4e.internal.LSPDocumentAbstractHandler;
import org.eclipse.lsp4e.internal.ResourceUtil;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;

public class LSPFormatHandler
extends LSPDocumentAbstractHandler {
    private final LSPFormatter formatter = new LSPFormatter();

    static boolean setWritable(IFile file) {
        Shell shell = UI.getActiveShell();
        if (!MessageDialog.openQuestion((Shell)shell, (String)Messages.LSPFormatHandler_ReadOnlyEditor_title, (String)NLS.bind((String)Messages.LSPFormatHandler_ReadOnlyEditor_fileReadonly, (Object)file.getLocation().toFile()))) {
            return false;
        }
        try {
            ResourceUtil.setWritable(file);
            return true;
        }
        catch (CoreException ex) {
            MessageDialog.openError((Shell)UI.getActiveShell(), (String)Messages.LSPFormatHandler_ReadOnlyEditor_title, (String)NLS.bind((String)Messages.LSPFormatHandler_ReadOnlyEditor_makingWritableFailed, (Object)file.getLocation().toFile(), (Object)ex.getStatus().getMessage()));
            return false;
        }
    }

    @Override
    protected void execute(ExecutionEvent event, ITextEditor textEditor) {
        ITextSelection textSelection;
        ISelection selection;
        ITextEditorExtension editorExt = (ITextEditorExtension)Adapters.adapt((Object)textEditor, ITextEditorExtension.class);
        if (editorExt != null && editorExt.isEditorInputReadOnly()) {
            IFile file;
            IEditorInput input = textEditor.getEditorInput();
            if (input instanceof FileEditorInput) {
                FileEditorInput fileInput = (FileEditorInput)input;
                v0 = fileInput.getFile();
            } else {
                v0 = file = null;
            }
            if (file == null) {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.LSPFormatHandler_ReadOnlyEditor_title, (String)NLS.bind((String)Messages.LSPFormatHandler_ReadOnlyEditor_inputReadonly, (Object)input.getToolTipText()));
                return;
            }
            if (!LSPFormatHandler.setWritable(file)) {
                return;
            }
        }
        if ((selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof ITextSelection && !(textSelection = (ITextSelection)selection).isEmpty()) {
            IDocument doc = LSPEclipseUtils.getDocument(textEditor);
            if (doc == null) {
                return;
            }
            try {
                this.formatter.requestFormatting(doc, textSelection).thenAcceptAsync(result -> result.ifPresent(edits -> {
                    try {
                        edits.apply();
                    }
                    catch (ConcurrentModificationException ex) {
                        ServerMessageHandler.showMessage(Messages.LSPFormatHandler_DiscardedFormat, new MessageParams(MessageType.Error, Messages.LSPFormatHandler_DiscardedFormatResponse));
                    }
                    catch (BadLocationException e) {
                        LanguageServerPlugin.logError(e);
                    }
                }), (Executor)UI.getDisplay());
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        this.setEnabled(LSPFormatter::supportsFormatting, this::hasSelection);
    }
}

