/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.test.semanticTokens.SemanticTokensTestUtil;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SemanticHighlightReconcilerStrategyTest
extends AbstractTestWithProject {
    private Shell shell;

    @Before
    public void setUp() {
        this.shell = new Shell();
        List<String> tokenTypes = List.of("keyword");
        List<String> tokenModifiers = List.of("obsolete");
        SemanticTokensTestUtil.setSemanticTokensLegend(tokenTypes, tokenModifiers);
    }

    @Test
    public void testKeyword() throws CoreException {
        SemanticTokens semanticTokens = new SemanticTokens();
        semanticTokens.setData(SemanticTokensTestUtil.keywordSemanticTokens());
        MockLanguageServer.INSTANCE.getTextDocumentService().setSemanticTokens(semanticTokens);
        IFile file = TestUtils.createUniqueTestFile(this.project, "lsptm", "type foo {\n\t\n}\ntype bar extends foo {\n\t\n}\n");
        ITextViewer textViewer = TestUtils.openTextViewer(file);
        Display display = this.shell.getDisplay();
        DisplayHelper.sleep((Display)display, (long)2000L);
        StyleRange[] styleRanges = textViewer.getTextWidget().getStyleRanges();
        Color backgroundColor = textViewer.getTextWidget().getBackground();
        Assert.assertEquals((long)6L, (long)styleRanges.length);
        Assert.assertEquals((long)0L, (long)styleRanges[0].start);
        Assert.assertEquals((long)4L, (long)styleRanges[0].length);
        Assert.assertNotEquals((Object)styleRanges[0].foreground, (Object)backgroundColor);
        Assert.assertEquals((long)4L, (long)styleRanges[1].start);
        Assert.assertEquals((long)11L, (long)styleRanges[1].length);
        Assert.assertNotEquals((Object)styleRanges[1].foreground, (Object)backgroundColor);
        Assert.assertEquals((long)15L, (long)styleRanges[2].start);
        Assert.assertEquals((long)4L, (long)styleRanges[2].length);
        Assert.assertNotEquals((Object)styleRanges[2].foreground, (Object)backgroundColor);
        Assert.assertEquals((long)19L, (long)styleRanges[3].start);
        Assert.assertEquals((long)5L, (long)styleRanges[3].length);
        Assert.assertNotEquals((Object)styleRanges[3].foreground, (Object)backgroundColor);
        Assert.assertEquals((long)24L, (long)styleRanges[4].start);
        Assert.assertEquals((long)7L, (long)styleRanges[4].length);
        Assert.assertNotEquals((Object)styleRanges[4].foreground, (Object)backgroundColor);
        Assert.assertEquals((long)31L, (long)styleRanges[5].start);
        Assert.assertEquals((long)11L, (long)styleRanges[5].length);
        Assert.assertNotEquals((Object)styleRanges[5].foreground, (Object)backgroundColor);
    }
}

