/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.codeactions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.NoErrorLoggedRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CodeActionTests
extends AbstractTestWithProject {
    @Rule
    public final NoErrorLoggedRule noErrorLoggedRule = new NoErrorLoggedRule();

    @Test
    public void testCodeActionsClientCommandForTextEdit() throws CoreException {
        IFile f = TestUtils.createUniqueTestFile(this.project, "error");
        MockLanguageServer.INSTANCE.setCodeActions(List.of(Either.forLeft((Object)new Command("fixme", "edit", List.of(new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed"))))));
        MockLanguageServer.INSTANCE.setDiagnostics(List.of(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        try {
            IMarker m = CodeActionTests.assertDiagnostics(f, "error", "fixme");
            CodeActionTests.assertResolution(editor, m, "fixed");
        }
        finally {
            editor.close(false);
        }
    }

    @Test
    public void testCodeActionsClientCommandForWorkspaceEdit() throws CoreException {
        IFile f = TestUtils.createUniqueTestFile(this.project, "error");
        TextEdit tEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed");
        WorkspaceEdit wEdit = new WorkspaceEdit(Collections.singletonMap(f.getLocationURI().toString(), List.of(tEdit)));
        MockLanguageServer.INSTANCE.setCodeActions(List.of(Either.forLeft((Object)new Command("fixme", "edit", List.of(wEdit)))));
        MockLanguageServer.INSTANCE.setDiagnostics(List.of(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        IMarker m = CodeActionTests.assertDiagnostics(f, "error", "fixme");
        CodeActionTests.assertResolution(editor, m, "fixed");
    }

    private void checkCompletionContent(Table completionProposalList) {
        TestUtils.waitForAndAssertCondition("No item found", 100, () -> completionProposalList.getItemCount() > 0);
        Assert.assertEquals((long)1L, (long)completionProposalList.getItemCount());
        TableItem quickAssistItem = completionProposalList.getItem(0);
        Assert.assertTrue((String)"Missing quick assist proposal", (boolean)quickAssistItem.getText().contains("fixme"));
    }

    @Test
    public void testCodeActionsQuickAssist() throws CoreException {
        MockLanguageServer.reset();
        IFile f = TestUtils.createUniqueTestFile(this.project, "error");
        TextEdit tEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed");
        WorkspaceEdit wEdit = new WorkspaceEdit(Collections.singletonMap(f.getLocationURI().toString(), List.of(tEdit)));
        MockLanguageServer.INSTANCE.setCodeActions(List.of(Either.forLeft((Object)new Command("fixme", "edit", List.of(wEdit)))));
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        Set<Shell> beforeShells = Arrays.stream(editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        editor.selectAndReveal(3, 0);
        TextOperationAction action = (TextOperationAction)editor.getAction("QuickAssist");
        action.update();
        action.run();
        Shell completionShell = TestUtils.findNewShell(beforeShells, editor.getSite().getShell().getDisplay());
        Table completionProposalList = TestUtils.findCompletionSelectionControl((Widget)completionShell);
        this.checkCompletionContent(completionProposalList);
    }

    @Test
    public void testSlowCodeActionsQuickAssist() throws CoreException {
        MockLanguageServer.reset();
        IFile f = TestUtils.createUniqueTestFile(this.project, "error");
        TextEdit tEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed");
        WorkspaceEdit wEdit = new WorkspaceEdit(Collections.singletonMap(f.getLocationURI().toString(), List.of(tEdit)));
        MockLanguageServer.INSTANCE.setCodeActions(List.of(Either.forLeft((Object)new Command("fixme", "edit", List.of(wEdit)))));
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(1000L);
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        Set beforeShells = Arrays.stream(editor.getSite().getShell().getDisplay().getShells()).filter(Shell::isVisible).collect(Collectors.toSet());
        editor.selectAndReveal(3, 0);
        TextOperationAction action = (TextOperationAction)editor.getAction("QuickAssist");
        action.update();
        action.run();
        TestUtils.waitForAndAssertCondition(3000, () -> {
            Shell completionShell = TestUtils.findNewShell(beforeShells, editor.getSite().getShell().getDisplay());
            if (completionShell == null) {
                return false;
            }
            Table completionProposalList = TestUtils.findCompletionSelectionControl((Widget)completionShell);
            return completionProposalList.getItemCount() == 1 && "fixme".equals(completionProposalList.getItem(0).getText());
        });
        Assert.assertEquals((long)1L, (long)MockLanguageServer.INSTANCE.getTextDocumentService().codeActionRequests);
    }

    @Test
    public void testCodeActionLiteralWorkspaceEdit() throws CoreException {
        IFile f = TestUtils.createUniqueTestFile(this.project, "error");
        TextEdit tEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed");
        WorkspaceEdit wEdit = new WorkspaceEdit(Collections.singletonMap(f.getLocationURI().toString(), List.of(tEdit)));
        CodeAction codeAction = new CodeAction("fixme");
        codeAction.setEdit(wEdit);
        MockLanguageServer.INSTANCE.setCodeActions(List.of(Either.forRight((Object)codeAction)));
        MockLanguageServer.INSTANCE.setDiagnostics(List.of(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        IMarker m = CodeActionTests.assertDiagnostics(f, "error", "fixme");
        CodeActionTests.assertResolution(editor, m, "fixed");
    }

    @Test
    public void testNoCodeActionOnReadOnlySource() throws CoreException {
        IFile f = TestUtils.createUniqueTestFile(this.project, "error");
        f.setResourceAttributes(new ResourceAttributes(){

            public boolean isReadOnly() {
                return true;
            }
        });
        TextEdit tEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed");
        WorkspaceEdit wEdit = new WorkspaceEdit(Collections.singletonMap(f.getLocationURI().toString(), List.of(tEdit)));
        CodeAction codeAction = new CodeAction("fixme");
        codeAction.setEdit(wEdit);
        MockLanguageServer.INSTANCE.setCodeActions(List.of(Either.forRight((Object)codeAction)));
        MockLanguageServer.INSTANCE.setDiagnostics(List.of(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        TestUtils.openEditor(f);
        CodeActionTests.assertDiagnostics(f, "error", "fixme", false);
    }

    @Test
    public void testCodeActionLiteralWithClientCommand() throws CoreException {
        IFile f = TestUtils.createUniqueTestFile(this.project, "error");
        TextEdit tEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed");
        WorkspaceEdit wEdit = new WorkspaceEdit(Collections.singletonMap(f.getLocationURI().toString(), List.of(tEdit)));
        CodeAction codeAction = new CodeAction("fixme");
        codeAction.setCommand(new Command("editCommand", "mockEditCommand", List.of(wEdit)));
        MockLanguageServer.INSTANCE.setCodeActions(List.of(Either.forRight((Object)codeAction)));
        MockLanguageServer.INSTANCE.setDiagnostics(List.of(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        IMarker m = CodeActionTests.assertDiagnostics(f, "error", "fixme");
        CodeActionTests.assertResolution(editor, m, "fixed");
    }

    @Test
    public void testCodeActionWorkspaceEditlWithDifferentURI() throws CoreException {
        IFile sourceFile = TestUtils.createUniqueTestFile(this.project, "error");
        IFile targetFile = TestUtils.createUniqueTestFile(this.project, "fixme");
        TextEdit tEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 5)), "fixed");
        WorkspaceEdit wEdit = new WorkspaceEdit(Collections.singletonMap(targetFile.getLocationURI().toString(), List.of(tEdit)));
        CodeAction codeAction = new CodeAction("fixme");
        codeAction.setCommand(new Command("editCommand", "mockEditCommand", List.of(wEdit)));
        MockLanguageServer.INSTANCE.setCodeActions(List.of(Either.forRight((Object)codeAction)));
        MockLanguageServer.INSTANCE.setDiagnostics(List.of(new Diagnostic(new Range(new Position(0, 0), new Position(0, 5)), "error", DiagnosticSeverity.Error, null)));
        TestUtils.openEditor(sourceFile);
        IMarker m = CodeActionTests.assertDiagnostics(sourceFile, "error", "fixme");
        CodeActionTests.assertResolution(targetFile, m, "fixed");
        IEditorPart activeEditorPart = TestUtils.getActiveEditor();
        Assert.assertTrue((boolean)(activeEditorPart instanceof AbstractTextEditor));
        Assert.assertEquals((Object)new FileEditorInput(targetFile), (Object)((AbstractTextEditor)activeEditorPart).getEditorInput());
    }

    private static IMarker assertDiagnostics(IFile f, String markerMessage, String resolutionLabel) throws CoreException {
        return CodeActionTests.assertDiagnostics(f, markerMessage, resolutionLabel, true);
    }

    private static IMarker assertDiagnostics(IFile f, String markerMessage, String resolutionLabel, boolean resolutionExpected) throws CoreException {
        TestUtils.waitForAndAssertCondition(2000, () -> {
            IMarker[] markers = f.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
            return markers.length > 0 && markers[0].getAttribute("message") != null;
        });
        IMarker m = f.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)[0];
        Assert.assertEquals((Object)markerMessage, (Object)m.getAttribute("message"));
        Assert.assertEquals((String)(resolutionExpected ? "Resolution not found within expected time." : "Unexpected resolution found"), (Object)resolutionExpected, (Object)TestUtils.waitForCondition(2000, () -> IDE.getMarkerHelpRegistry().hasResolutions(m) && IDE.getMarkerHelpRegistry().getResolutions(m).length > 0 && IDE.getMarkerHelpRegistry().getResolutions(m)[0].getLabel().equals(resolutionLabel)));
        return m;
    }

    private static void assertResolution(AbstractTextEditor editor, IMarker m, String newText) {
        IDE.getMarkerHelpRegistry().getResolutions(m)[0].run(m);
        TestUtils.waitForCondition(1000, () -> newText.equals(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get()));
        Assert.assertEquals((Object)newText, (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
        TestUtils.waitForCondition(1000, () -> newText.equals(((StyledText)editor.getAdapter(Control.class)).getText()));
        Assert.assertEquals((Object)newText, (Object)((StyledText)editor.getAdapter(Control.class)).getText());
    }

    private static void assertResolution(IFile targetFile, IMarker m, String newText) {
        IDE.getMarkerHelpRegistry().getResolutions(m)[0].run(m);
        IEditorPart editorPart = TestUtils.getEditor(targetFile);
        Assert.assertTrue((boolean)(editorPart instanceof AbstractTextEditor));
        AbstractTextEditor editor = (AbstractTextEditor)editorPart;
        TestUtils.waitForCondition(1000, () -> newText.equals(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get()));
        Assert.assertEquals((Object)newText, (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
        TestUtils.waitForCondition(1000, () -> newText.equals(((StyledText)editor.getAdapter(Control.class)).getText()));
        Assert.assertEquals((Object)newText, (Object)((StyledText)editor.getAdapter(Control.class)).getText());
    }
}

