/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import org.eclipse.swtchart.extensions.barcharts.BarSeriesSettings;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.AbstractSeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.MappingsType;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.CircularSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.ScatterSeriesSettings;

public class MappingsSupport {
    public static MappingsType getMappingsType(ISeriesSettings seriesSettings) {
        if (seriesSettings instanceof IBarSeriesSettings) {
            return MappingsType.BAR;
        }
        if (seriesSettings instanceof ILineSeriesSettings) {
            return MappingsType.LINE;
        }
        if (seriesSettings instanceof IScatterSeriesSettings) {
            return MappingsType.SCATTER;
        }
        if (seriesSettings instanceof ICircularSeriesSettings) {
            return MappingsType.CIRCULAR;
        }
        return MappingsType.NONE;
    }

    public static MappingsType getMappingsType(String value) {
        try {
            return MappingsType.valueOf(value);
        }
        catch (Exception e) {
            return MappingsType.NONE;
        }
    }

    public static ISeriesSettings createSeriesSettings(MappingsType mappingsType) {
        AbstractSeriesSettings seriesSettings = null;
        switch (mappingsType) {
            case BAR: {
                seriesSettings = new BarSeriesSettings();
                break;
            }
            case LINE: {
                seriesSettings = new LineSeriesSettings();
                break;
            }
            case SCATTER: {
                seriesSettings = new ScatterSeriesSettings();
                break;
            }
            case CIRCULAR: {
                seriesSettings = new CircularSeriesSettings();
                break;
            }
            default: {
                seriesSettings = null;
            }
        }
        return seriesSettings;
    }

    public static ISeriesSettings copySettings(ISeriesSettings seriesSettings) {
        if (seriesSettings != null) {
            ISeriesSettings seriesSettingsCopy = seriesSettings.makeDeepCopy();
            MappingsSupport.transferSettings(seriesSettings, seriesSettingsCopy);
            return seriesSettingsCopy;
        }
        return null;
    }

    public static boolean transferSettings(ISeriesSettings seriesSettingsSource, ISeriesSettings seriesSettingsSink) {
        boolean success = MappingsSupport.transfer(seriesSettingsSource, seriesSettingsSink);
        if (success && !seriesSettingsSource.isHighlight() && !seriesSettingsSink.isHighlight()) {
            success = MappingsSupport.transfer(seriesSettingsSource.getSeriesSettingsHighlight(), seriesSettingsSink.getSeriesSettingsHighlight());
        }
        return success;
    }

    private static boolean transfer(ISeriesSettings seriesSettingsSource, ISeriesSettings seriesSettingsSink) {
        boolean success = false;
        if (seriesSettingsSource != null && seriesSettingsSink != null) {
            success = seriesSettingsSource.transfer(seriesSettingsSink);
        }
        return success;
    }
}

