/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.participants;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.lemminx.extensions.references.XMLReferencesPlugin;
import org.eclipse.lemminx.extensions.references.search.SearchEngine;
import org.eclipse.lemminx.extensions.references.search.SearchQuery;
import org.eclipse.lemminx.extensions.references.search.SearchQueryFactory;
import org.eclipse.lemminx.services.extensions.completion.CompletionParticipantAdapter;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class XMLReferencesCompletionParticipant
extends CompletionParticipantAdapter {
    private final XMLReferencesPlugin plugin;

    public XMLReferencesCompletionParticipant(XMLReferencesPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onXMLContent(ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        this.searchToNodes(request, response, cancelChecker);
    }

    @Override
    public void onAttributeValue(String valuePrefix, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        this.searchToNodes(request, response, cancelChecker);
    }

    private void searchToNodes(ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) {
        SearchQuery query = SearchQueryFactory.createFromQuery(request.getNode(), request.getOffset(), this.plugin.getReferencesSettings());
        if (query == null) {
            return;
        }
        query.setMatchNode(false);
        query.setSearchInIncludedFiles(true);
        AtomicReference<Object> replaceRange = new AtomicReference<Object>(null);
        SearchEngine.getInstance().search(query, (fromSearchNode, toSearchNode, expression) -> {
            CompletionItem item = new CompletionItem();
            String value = toSearchNode.getValue(fromSearchNode.getPrefix());
            String insertText = request.getInsertAttrValue(value);
            item.setLabel(value);
            item.setKind(CompletionItemKind.Value);
            item.setFilterText(insertText);
            Range fullRange = (Range)replaceRange.get();
            if (fullRange == null) {
                replaceRange.set(XMLPositionUtility.createRange(fromSearchNode));
                fullRange = (Range)replaceRange.get();
            }
            item.setTextEdit(Either.forLeft((Object)new TextEdit(fullRange, insertText)));
            response.addCompletionItem(item);
        }, cancelChecker);
    }
}

