/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions.commands;

import java.util.stream.Collectors;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.MockXMLLanguageServer;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommandServiceTest
extends AbstractCacheBasedTest {
    private final MockXMLLanguageServer languageServer = new MockXMLLanguageServer();

    private void registerCommand(String command) {
        this.languageServer.registerCommand(command, (params, sharedSettings, cancelChecker) -> params.getCommand() + (String)(params.getArguments().isEmpty() ? "" : ": " + params.getArguments().stream().map(a -> a.toString()).collect(Collectors.joining(" "))));
    }

    @Test
    public void testCommandExecution() throws Exception {
        this.registerCommand("my-cmd");
        Assertions.assertEquals((Object)"my-cmd: arg1 arg2", (Object)this.languageServer.executeCommand("my-cmd", "arg1", "arg2").get());
    }

    @Test
    public void testCommandRegistration() throws Exception {
        Assertions.assertThrows(ResponseErrorException.class, () -> this.languageServer.executeCommand("my-cmd", "arg1", "arg2").get());
        this.registerCommand("my-cmd");
        Assertions.assertEquals((Object)"my-cmd", (Object)this.languageServer.executeCommand("my-cmd", new Object[0]).get());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.registerCommand("my-cmd"));
        this.languageServer.unregisterCommand("cmd");
        this.languageServer.unregisterCommand("my-cmd");
        Assertions.assertThrows(ResponseErrorException.class, () -> this.languageServer.executeCommand("my-cmd", new Object[0]).get());
    }
}

