/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.xpath.matcher;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.xpath.matcher.IXPathNodeMatcher;
import org.eclipse.lemminx.xpath.matcher.XPathMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Node;

public class XPathMatcherTest {
    @Test
    public void emptyXPathMatcher() {
        XPathMatcher matcher = new XPathMatcher(null);
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertEquals((Object)IXPathNodeMatcher.MatcherType.ELEMENT, (Object)matcher.getNodeSelectorType());
        matcher = new XPathMatcher("");
        Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertEquals((Object)IXPathNodeMatcher.MatcherType.ELEMENT, (Object)matcher.getNodeSelectorType());
    }

    @Test
    public void matchAnyAttr() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        DOMDocument document = DOMParser.getInstance().parse(xml, "test.xml", null);
        DOMElement bar = XPathMatcherTest.getElementByTagName(document.getDocumentElement(), "bar");
        DOMAttr attr1OfBar = bar.getAttributeAtIndex(0);
        XPathMatcher matcher = new XPathMatcher("//@*");
        Assertions.assertTrue((boolean)matcher.match((Node)attr1OfBar));
        matcher = new XPathMatcher("//bar/@*");
        Assertions.assertTrue((boolean)matcher.match((Node)attr1OfBar));
        matcher = new XPathMatcher("/foo/bar/@*");
        Assertions.assertTrue((boolean)matcher.match((Node)attr1OfBar));
        matcher = new XPathMatcher("//baz/@*");
        Assertions.assertFalse((boolean)matcher.match((Node)attr1OfBar));
        matcher = new XPathMatcher("/foo/baz/@*");
        Assertions.assertFalse((boolean)matcher.match((Node)attr1OfBar));
    }

    @Test
    public void matchOneAttr() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        DOMDocument document = DOMParser.getInstance().parse(xml, "test.xml", null);
        DOMElement bar = XPathMatcherTest.getElementByTagName(document.getDocumentElement(), "bar");
        DOMAttr attr1OfBar = bar.getAttributeAtIndex(0);
        XPathMatcher matcher = new XPathMatcher("//@attr1");
        Assertions.assertTrue((boolean)matcher.match((Node)attr1OfBar));
        matcher = new XPathMatcher("//bar/@attr1");
        Assertions.assertTrue((boolean)matcher.match((Node)attr1OfBar));
        matcher = new XPathMatcher("/foo/bar/@attr1");
        Assertions.assertTrue((boolean)matcher.match((Node)attr1OfBar));
        matcher = new XPathMatcher("//@attr2");
        Assertions.assertFalse((boolean)matcher.match((Node)attr1OfBar));
        matcher = new XPathMatcher("//bar/@attr2");
        Assertions.assertFalse((boolean)matcher.match((Node)attr1OfBar));
        matcher = new XPathMatcher("/foo/bar/@attr2");
        Assertions.assertFalse((boolean)matcher.match((Node)attr1OfBar));
    }

    @Test
    public void matchAnyText() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        DOMDocument document = DOMParser.getInstance().parse(xml, "test.xml", null);
        DOMElement bar = XPathMatcherTest.getElementByTagName(document.getDocumentElement(), "bar");
        DOMText textOfBar = (DOMText)bar.getFirstChild();
        XPathMatcher matcher = new XPathMatcher("//text()");
        Assertions.assertTrue((boolean)matcher.match((Node)textOfBar));
        matcher = new XPathMatcher("//bar/text()");
        Assertions.assertTrue((boolean)matcher.match((Node)textOfBar));
        matcher = new XPathMatcher("/foo/bar/text()");
        Assertions.assertTrue((boolean)matcher.match((Node)textOfBar));
        matcher = new XPathMatcher("//baz/text()");
        Assertions.assertFalse((boolean)matcher.match((Node)textOfBar));
        matcher = new XPathMatcher("/foo/baz/text()");
        Assertions.assertFalse((boolean)matcher.match((Node)textOfBar));
    }

    private static DOMElement getElementByTagName(DOMElement parent, String tagName) {
        List children = parent.getChildren();
        if (children != null) {
            for (DOMNode node : children) {
                if (!node.isElement() || !((DOMElement)node).isSameTag(tagName)) continue;
                return (DOMElement)node;
            }
        }
        return null;
    }
}

