/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.function.Consumer;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XMLFileAssociationsCompletionTest
extends AbstractCacheBasedTest {
    @Test
    public void completionOnRootWithXSD() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationsCompletionTest.createXSDAssociationsNoNamespaceSchemaLocationLike("src/test/resources/xsd/"));
        };
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n  <|";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Configuration", "<Configuration></Configuration>"));
        xml = "|";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Configuration", "<Configuration></Configuration>"));
        xml = " |";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Configuration", "<Configuration></Configuration>"));
    }

    @Test
    public void completionAfterRootWithXSD() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationsCompletionTest.createXSDAssociationsNoNamespaceSchemaLocationLike("src/test/resources/xsd/"));
        };
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Configuration>\r\n  <|";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Controls", "<Controls></Controls>"), XMLAssert.c("DefaultSettings", "<DefaultSettings></DefaultSettings>"), XMLAssert.c("SelectionSets", "<SelectionSets></SelectionSets>"), XMLAssert.c("ViewDefinitions", "<ViewDefinitions></ViewDefinitions>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Configuration>\r\n  |";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Controls", "<Controls></Controls>"), XMLAssert.c("DefaultSettings", "<DefaultSettings></DefaultSettings>"), XMLAssert.c("SelectionSets", "<SelectionSets></SelectionSets>"), XMLAssert.c("ViewDefinitions", "<ViewDefinitions></ViewDefinitions>"));
    }

    @Test
    public void rootURIEndsWithSlashWithXSD() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setRootURI("src/test/resources/xsd/");
            contentModelManager.setFileAssociations(XMLFileAssociationsCompletionTest.createXSDAssociationsNoNamespaceSchemaLocationLike(""));
        };
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n  <|";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Configuration", "<Configuration></Configuration>"));
        xml = "|";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Configuration", "<Configuration></Configuration>"));
        xml = " |";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Configuration", "<Configuration></Configuration>"));
    }

    @Test
    public void rootURIEndsWithNoSlashWithXSD() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setRootURI("src/test/resources/xsd");
            contentModelManager.setFileAssociations(XMLFileAssociationsCompletionTest.createXSDAssociationsNoNamespaceSchemaLocationLike(""));
        };
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n  <|";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Configuration", "<Configuration></Configuration>"));
        xml = "|";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Configuration", "<Configuration></Configuration>"));
        xml = " |";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/Test.Format.ps1xml", configuration, XMLAssert.c("Configuration", "<Configuration></Configuration>"));
    }

    private static XMLFileAssociation[] createXSDAssociationsNoNamespaceSchemaLocationLike(String baseSystemId) {
        XMLFileAssociation format = new XMLFileAssociation();
        format.setPattern("**/*.Format.ps1xml");
        format.setSystemId(baseSystemId + "Format.xsd");
        XMLFileAssociation resources = new XMLFileAssociation();
        resources.setPattern("**/*resources*.xml");
        resources.setSystemId(baseSystemId + "resources.xsd");
        return new XMLFileAssociation[]{format, resources};
    }

    @Test
    public void completionOnRootWithXSDAndNS() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationsCompletionTest.createXSDAssociationsSchemaLocationLike("src/test/resources/xsd/"));
        };
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n>\r\n\t<|</project>";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/pom.xml", configuration, XMLAssert.c("modelVersion", XMLAssert.te(2, 1, 2, 2, "<modelVersion></modelVersion>"), "<modelVersion"), XMLAssert.c("parent", "<parent></parent>", "<parent"));
    }

    @Test
    public void completionWithXSDAndDocType() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationsCompletionTest.createXSDAssociationsSchemaLocationLike("src/test/resources/xsd/"));
        };
        String xml = "<!DOCTYPE opt [\r\n  <!ENTITY size \"short\">\r\n]>\r\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n>\r\n\t<|</project>";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/pom.xml", configuration, XMLAssert.c("modelVersion", XMLAssert.te(5, 1, 5, 2, "<modelVersion></modelVersion>"), "<modelVersion"), XMLAssert.c("parent", "<parent></parent>", "<parent"));
    }

    private static XMLFileAssociation[] createXSDAssociationsSchemaLocationLike(String baseSystemId) {
        XMLFileAssociation maven = new XMLFileAssociation();
        maven.setPattern("**/pom.xml");
        maven.setSystemId(baseSystemId + "maven-4.0.0.xsd");
        return new XMLFileAssociation[]{maven};
    }

    @Test
    public void completionOnRootWithDTD() throws BadLocationException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationsCompletionTest.createDTDAssociations("src/test/resources/dtd/"));
        };
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n  <|";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/web.xml", configuration, XMLAssert.c("web-app", "<web-app></web-app>"));
        xml = "|";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/web.xml", configuration, XMLAssert.c("web-app", "<web-app></web-app>"));
        xml = " |";
        XMLFileAssociationsCompletionTest.testCompletionFor(xml, "file:///test/web.xml", configuration, XMLAssert.c("web-app", "<web-app></web-app>"));
    }

    private static XMLFileAssociation[] createDTDAssociations(String baseSystemId) {
        XMLFileAssociation webApp = new XMLFileAssociation();
        webApp.setPattern("web.xml");
        webApp.setSystemId(baseSystemId + "web-app_2_3.dtd");
        return new XMLFileAssociation[]{webApp};
    }

    private static void testCompletionFor(String xml, String fileURI, Consumer<XMLLanguageService> configuration, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, null, configuration, fileURI, null, true, expectedItems);
    }
}

