/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.colors.participants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.extensions.colors.XMLColorsPlugin;
import org.eclipse.lemminx.extensions.colors.settings.XMLColorExpression;
import org.eclipse.lemminx.extensions.colors.settings.XMLColors;
import org.eclipse.lemminx.extensions.colors.settings.XMLColorsSettings;
import org.eclipse.lemminx.extensions.colors.utils.ColorUtils;
import org.eclipse.lemminx.services.extensions.IDocumentColorParticipant;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLDocumentColorParticipant
implements IDocumentColorParticipant {
    private final XMLColorsPlugin xmlColorsPlugin;

    public XMLDocumentColorParticipant(XMLColorsPlugin xmlColorsPlugin) {
        this.xmlColorsPlugin = xmlColorsPlugin;
    }

    @Override
    public void doDocumentColor(DOMDocument xmlDocument, List<ColorInformation> colors, CancelChecker cancelChecker) {
        List<XMLColorExpression> expressions = this.findColorExpression(xmlDocument);
        if (expressions.isEmpty()) {
            return;
        }
        this.doDocumentColor(xmlDocument, expressions, colors, cancelChecker);
    }

    private void doDocumentColor(DOMNode node, List<XMLColorExpression> expressions, List<ColorInformation> colors, CancelChecker cancelChecker) {
        DOMText text;
        Color color;
        if (node.isElement()) {
            DOMElement element = (DOMElement)node;
            if (element.hasAttributes()) {
                List<DOMAttr> attributes = element.getAttributeNodes();
                for (DOMAttr attr : attributes) {
                    Color color2;
                    if (!XMLDocumentColorParticipant.isColorNode(attr, expressions) || (color2 = ColorUtils.getColorValue(attr.getValue())) == null) continue;
                    Range range = XMLPositionUtility.selectAttributeValue(attr, true);
                    ColorInformation colorInformation = new ColorInformation(range, color2);
                    colors.add(colorInformation);
                }
            }
        } else if (node.isText() && XMLDocumentColorParticipant.isColorNode(node, expressions) && (color = ColorUtils.getColorValue((text = (DOMText)node).getData())) != null) {
            Range range = XMLPositionUtility.selectText(text);
            ColorInformation colorInformation = new ColorInformation(range, color);
            colors.add(colorInformation);
        }
        List<DOMNode> children = node.getChildren();
        for (DOMNode child : children) {
            cancelChecker.checkCanceled();
            this.doDocumentColor(child, expressions, colors, cancelChecker);
        }
    }

    @Override
    public void doColorPresentations(DOMDocument xmlDocument, ColorPresentationParams params, List<ColorPresentation> presentations, CancelChecker cancelChecker) {
        Color color = params.getColor();
        Range replace = params.getRange();
        presentations.add(ColorUtils.toRGB(color, replace));
        presentations.add(ColorUtils.toHexa(color, replace));
    }

    private static boolean isColorNode(DOMNode node, List<XMLColorExpression> expressions) {
        DOMText text;
        DOMAttr attr;
        if (node.isAttribute() ? (attr = (DOMAttr)node).getValue() == null || attr.getValue().isEmpty() : node.isText() && !(text = (DOMText)node).hasData()) {
            return false;
        }
        for (XMLColorExpression expression : expressions) {
            if (!expression.match(node)) continue;
            return true;
        }
        return false;
    }

    private List<XMLColorExpression> findColorExpression(DOMDocument xmlDocument) {
        XMLColorsSettings settings = this.xmlColorsPlugin.getColorsSettings();
        if (settings == null) {
            return Collections.emptyList();
        }
        List<XMLColors> colorsDef = settings.getColors();
        if (colorsDef == null) {
            return Collections.emptyList();
        }
        ArrayList<XMLColorExpression> expressions = new ArrayList<XMLColorExpression>();
        for (XMLColors xmlColors : colorsDef) {
            if (!xmlColors.matches(xmlDocument.getDocumentURI())) continue;
            expressions.addAll(xmlColors.getExpressions());
        }
        return expressions;
    }
}

