/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.as.servicies.action.popup;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.domain.Activator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.ArchitectureFramework;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationGraph;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationGraphCycle;

public class CheckCyclesAction
extends BaseSelectionListenerAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;

    public CheckCyclesAction() {
        super("Check cycle");
    }

    public void run(IAction action) {
        URI uri = CheckCyclesAction.getDomainURI(this.selection);
        ArchitectureFramework afdescription = this.getAFSpecification(uri);
        GenerationGraph generationGraph = new GenerationGraph(afdescription);
        if (!generationGraph.isEmpty()) {
            GenerationGraphCycle cycleDetect = new GenerationGraphCycle(generationGraph);
            cycleDetect.analyse();
            String message = "No cycles are detected";
            int status = 0;
            if (cycleDetect.exist()) {
                message = String.valueOf(cycleDetect.count()) + " cycle(s) \n" + cycleDetect.cyclesToString();
                status = 4;
            }
            Activator.getDefault().log((IStatus)new Status(status, Activator.getDefault().getPluginID(), message));
        }
    }

    public ArchitectureFramework getAFSpecification(URI uri) {
        ArchitectureFramework result = null;
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.getResource(uri, true);
        EList content = resource.getContents();
        if (content != null && content.size() > 0) {
            result = (ArchitectureFramework)content.get(0);
        }
        return result;
    }

    public static URI getDomainURI(IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj instanceof IResource) {
            IFile vpSpecFile = null;
            if (obj instanceof IFile) {
                vpSpecFile = (IFile)obj;
            }
            return URI.createPlatformResourceURI((String)vpSpecFile.getFullPath().toString(), (boolean)true);
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = (IStructuredSelection)selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

