/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.selection;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.polarsys.kitalpha.massactions.core.helper.CellSelectionHelper;

public class RowCellSelectionProvider<T>
extends RowSelectionProvider<T> {
    protected SelectionLayer selectionLayer;

    public RowCellSelectionProvider(SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider, boolean fullySelectedRowsOnly, boolean handleSameRowSelection) {
        super(selectionLayer, rowDataProvider, fullySelectedRowsOnly, handleSameRowSelection);
        this.selectionLayer = selectionLayer;
    }

    public ISelection getSelection() {
        int[] rows = this.selectionLayer.getFullySelectedRowPositions();
        if (rows != null && rows.length > 0) {
            return super.getSelection();
        }
        List<Object> cellObjects = CellSelectionHelper.getSelectedCellObjects(this.selectionLayer);
        if (!cellObjects.isEmpty()) {
            return new StructuredSelection(cellObjects);
        }
        return StructuredSelection.EMPTY;
    }
}

