/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Version;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;

public class ViewpointManagerLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private ResourceSet context;

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        ViewpointManager.Description vp = (ViewpointManager.Description)element;
        if (this.context != null && ViewpointManager.getInstance((ResourceSet)this.context).isUsed(vp.getId())) {
            return Activator.getDefault().getImage("icons/runningVP.gif");
        }
        return Activator.getDefault().getImage("icons/VP.gif");
    }

    public String getColumnText(Object element, int columnIndex) {
        ViewpointManager.Description vp = (ViewpointManager.Description)element;
        switch (columnIndex) {
            case 0: {
                return vp.getLabel();
            }
            case 2: {
                if (this.context == null) {
                    return "N/A";
                }
                ViewpointManager instance = ViewpointManager.getInstance((ResourceSet)this.context);
                if (instance.isReferenced(vp.getId())) {
                    return instance.isInactive(vp.getId()) ? "Inactive" : "Active";
                }
                return "Unreferenced";
            }
            case 1: {
                Version version = vp.getVersion();
                return version == null ? "no version" : version.toString();
            }
        }
        return "";
    }

    public void setContext(ResourceSet context) {
        this.context = context;
    }
}

