/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius;

import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.ExpressionKind;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.IExpressionFormat;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.SiriusExpressionHelper;

public enum ExpressionInterpreter implements IExpressionFormat
{
    Feature,
    Service,
    Variable;


    @Override
    public String format(String expression) {
        if (this.isFormated(expression)) {
            return expression;
        }
        switch (this) {
            case Feature: {
                return ExpressionInterpreter.getExpression_I_Feature(expression);
            }
            case Service: {
                return ExpressionInterpreter.getExpression_I_Service(expression);
            }
            case Variable: {
                return ExpressionInterpreter.getExpression_I_Var(expression);
            }
        }
        throw new RuntimeException("Expression Interpreter not supported");
    }

    @Override
    public boolean isFormated(String expression) {
        switch (this) {
            case Feature: 
            case Service: {
                return this.containsPrefix(8, expression);
            }
            case Variable: {
                return this.containsPrefix(9, expression);
            }
        }
        return false;
    }

    private static String getExpression_I_Feature(String expression) {
        return "feature:" + expression;
    }

    private static String getExpression_I_Service(String expression) {
        if (SiriusExpressionHelper.getCurrentExpressionKind().equals(ExpressionKind.QueryLegacy)) {
            expression = expression.replaceAll("\\$", "");
        }
        return "service:" + expression;
    }

    private static String getExpression_I_Var(String expression) {
        return "var:" + expression;
    }

    private boolean containsPrefix(int prefixLenght, String expression) {
        if (expression.length() < prefixLenght) {
            return false;
        }
        String firstCharacters = expression.substring(0, prefixLenght);
        switch (this) {
            case Feature: {
                return firstCharacters.equals(String.valueOf(Feature.name()) + ":");
            }
            case Service: {
                return firstCharacters.equals(String.valueOf(Service.name()) + ":");
            }
            case Variable: {
                return firstCharacters.equals(String.valueOf(Variable.name()) + ":");
            }
        }
        return false;
    }

    public static boolean isInterpreterExpression(String expression) {
        String firstCharacters;
        return expression.length() > 4 ? (firstCharacters = expression.substring(0, 4)).equals(String.valueOf(Variable.name().toLowerCase()) + ":") : expression.length() > 8 && ((firstCharacters = expression.substring(0, 8)).equals(String.valueOf(Feature.name().toLowerCase()) + ":") || firstCharacters.equals(String.valueOf(Service.name().toLowerCase()) + ":"));
    }
}

