/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.nebula.widget;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarButton;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.polarsys.kitalpha.richtext.common.impl.BrowserBasedMDERichTextWidgetImpl;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaRichTextConfiguration;
import org.polarsys.kitalpha.richtext.nebula.widget.toolbar.MDERichTextToolbarItemHandler;
import org.polarsys.kitalpha.richtext.nebula.widget.toolbar.MDEToolbarItem;

public class MDENebulaBasedRichTextWidgetImpl
extends BrowserBasedMDERichTextWidgetImpl
implements MDENebulaBasedRichTextWidget {
    private static final String SLASH_CHARACTER = "/";
    private static final String FILE_PROTOCOL = "file://";
    private final RichTextEditor editor;
    private final RichTextEditorConfiguration configuration;
    public static final String WIDGET_DIRTY_STATE_UPDATED = "dirtyStateUpdated";
    private boolean editorReady = false;
    private String baseHrefPath = null;
    private boolean dirtyStateUpdated;

    public MDENebulaBasedRichTextWidgetImpl(Composite parent) {
        super(parent);
        this.editor = this.createRichTextEditor(parent, null, -1);
        this.configuration = this.getEditorConfiguration();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editor);
        this.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.installListeners();
        this.dirtyStateUpdated = false;
        this.customizeRichTextConfiguration(this.configuration);
    }

    public MDENebulaBasedRichTextWidgetImpl(Composite parent, MDENebulaRichTextConfiguration configuration) {
        super(parent);
        this.configuration = configuration;
        ((MDENebulaRichTextConfiguration)this.configuration).createToolbar();
        this.editor = this.createRichTextEditor(parent, configuration, -1);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editor);
        this.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.installListeners();
        this.dirtyStateUpdated = false;
        this.customizeRichTextConfiguration(this.configuration);
    }

    public MDENebulaBasedRichTextWidgetImpl(Composite parent, int style) {
        super(parent);
        this.editor = this.createRichTextEditor(parent, null, style);
        this.configuration = this.getEditorConfiguration();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editor);
        this.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.installListeners();
        this.dirtyStateUpdated = false;
        this.customizeRichTextConfiguration(this.configuration);
    }

    public MDENebulaBasedRichTextWidgetImpl(Composite parent, MDENebulaRichTextConfiguration configuration, int style) {
        super(parent);
        this.configuration = configuration;
        ((MDENebulaRichTextConfiguration)this.configuration).createToolbar();
        this.editor = this.createRichTextEditor(parent, null, style);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editor);
        this.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.installListeners();
        this.dirtyStateUpdated = false;
        this.customizeRichTextConfiguration(this.configuration);
    }

    protected RichTextEditor createRichTextEditor(Composite parent, RichTextEditorConfiguration editorConfig, int style) {
        if (editorConfig == null && style == -1) {
            return new RichTextEditor(parent);
        }
        if (editorConfig == null) {
            return new RichTextEditor(parent, style);
        }
        if (style == -1) {
            return new RichTextEditor(parent, editorConfig);
        }
        return new RichTextEditor(parent, editorConfig, style);
    }

    protected RichTextEditorConfiguration getEditorConfiguration() {
        return this.editor.getEditorConfiguration();
    }

    @Override
    public void setDirtyStateUpdated(boolean dirtyStateUpdated) {
        this.dirtyStateUpdated = dirtyStateUpdated;
        PropertyChangeEvent event = new PropertyChangeEvent(this, WIDGET_DIRTY_STATE_UPDATED, null, null);
        this.firePropertyChangeEvent(event);
    }

    @Override
    public boolean isDirtyStateUpdated() {
        return this.dirtyStateUpdated;
    }

    protected void installListeners() {
        if (this.getBrowser() != null) {
            this.getBrowser().addProgressListener(new ProgressListener(){

                public void completed(ProgressEvent event) {
                    MDENebulaBasedRichTextWidgetImpl.this.editorReady = true;
                    MDENebulaBasedRichTextWidgetImpl.this.installListenersOnReadyInstance();
                }

                public void changed(ProgressEvent event) {
                }
            });
        }
    }

    protected void installListenersOnReadyInstance() {
    }

    public Browser getBrowser() {
        return this.getEditorConfiguration().getBrowser();
    }

    public void setBaseHrefPath(String baseHref) {
        boolean forceEditorUpdate = false;
        baseHref = this.getBaseHref(baseHref);
        if (this.baseHrefPath == null || this.baseHrefPath.isEmpty()) {
            this.baseHrefPath = baseHref;
        }
        if (baseHref != null) {
            forceEditorUpdate = this.setBaseHref(baseHref);
        }
        if (forceEditorUpdate) {
            this.updateEditor();
        }
    }

    public boolean isDirty() {
        if (this.isReady()) {
            return super.isDirty();
        }
        return false;
    }

    public boolean isReady() {
        return this.editorReady;
    }

    private String getBaseHref(String baseHref) {
        if (baseHref != null) {
            if (!baseHref.endsWith(SLASH_CHARACTER)) {
                baseHref = String.valueOf(baseHref) + SLASH_CHARACTER;
            }
            baseHref = FILE_PROTOCOL + baseHref;
        }
        return baseHref;
    }

    private boolean setBaseHref(String baseHref) {
        boolean result = false;
        Map conf = this.configuration.getAllOptions();
        if (conf.containsKey("baseHref")) {
            Object oldValue = conf.get("baseHref");
            result = oldValue == null || !oldValue.equals(this.baseHrefPath) || !this.baseHrefPath.equals(baseHref);
        }
        this.configuration.setOption("baseHref", (Object)baseHref);
        this.baseHrefPath = baseHref;
        return result;
    }

    public void setVisible(boolean visible) {
        if (this.isReady()) {
            this.setVisible(visible);
        }
    }

    public String getText() {
        if (this.isReady()) {
            return this.editor.getText();
        }
        return "";
    }

    public void setText(String text) {
        if (text != null) {
            text = this.escapeSpecialCharacters(text);
            this.editor.setText(text);
        }
    }

    public void insertText(String text) {
        if (text != null && this.isReady()) {
            text = this.escapeSpecialCharacters(text);
            this.editor.insertText(text);
        }
    }

    public void insertRawText(String html) {
        if (html != null && this.isReady()) {
            html = this.escapeSpecialCharacters(html);
            this.editor.insertHTML(html);
        }
    }

    public String getSelectedText() {
        if (this.isReady()) {
            return this.editor.getSelectedText();
        }
        return "";
    }

    public String getSelectedRawText() {
        if (this.isReady()) {
            return this.editor.getSelectedHTML();
        }
        return "";
    }

    public boolean isEditable() {
        if (this.isReady()) {
            return this.editor.isEditable();
        }
        return false;
    }

    public void setEditable(boolean editable) {
        if (this.isReady()) {
            this.editor.setEditable(editable);
        }
    }

    public void updateToolbar() {
        if (this.isReady()) {
            this.editor.updateToolbar();
        }
    }

    public boolean setToolbarItemState(String command, String state) {
        if (this.isReady()) {
            StringBuilder updateStateScript = this.getCommand(command).append(".setState(").append(state).append(");");
            return this.executeScript(updateStateScript.toString());
        }
        return false;
    }

    protected final StringBuilder getCommand(String command) {
        return new StringBuilder("CKEDITOR.instances.editor.getCommand('").append(command).append("')");
    }

    public void updateEditor() {
        if (this.isReady()) {
            this.editor.updateEditor();
        }
    }

    public boolean setFocus() {
        return this.editor.setFocus();
    }

    public boolean forceFocus() {
        return this.editor.forceFocus();
    }

    public boolean hasFocus() {
        Browser browser = this.editor.getEditorConfiguration().getBrowser();
        return !browser.isDisposed() && this.editor.isFocusControl();
    }

    public void addFocusListener(FocusListener listener) {
        this.editor.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.editor.removeFocusListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.editor.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.editor.removeModifyListener(listener);
    }

    public void dispose() {
        super.dispose();
        this.editor.dispose();
    }

    @Override
    public void addToolbarItem(String name, String command, String label, String toolbar, URL iconPath, MDERichTextToolbarItemHandler handler) {
        MDEToolbarItem item = new MDEToolbarItem(this, name, command, label, toolbar, iconPath, handler);
        this.configuration.addToolbarButton((ToolbarButton)item);
    }

    @Override
    public void addToolbarItem(MDERichTextWidget richtext, String name, String command, String label, String toolbar, URL iconPath, MDERichTextToolbarItemHandler handler) {
        this.addToolbarItem(name, name, label, toolbar, iconPath, handler);
    }

    @Override
    public void addToolbarItem(MDERichTextWidget richtext, String name, String command, String label, String toolbar, URL iconPath) {
        this.addToolbarItem(name, command, label, toolbar, iconPath, null);
    }

    protected void customizeRichTextConfiguration(RichTextEditorConfiguration configuration) {
        configuration.setOption("startupFocus", (Object)false);
    }

    @Override
    public boolean isEditorDisposed() {
        return this.editor.isDisposed();
    }

    public void setParent(Composite parent) {
        this.editor.setParent(parent);
    }

    public Composite getParent() {
        return this.editor.getParent();
    }
}

