/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.listeners;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.concern.ConcernDescription;
import org.eclipse.sirius.diagram.description.concern.ConcernFactory;
import org.eclipse.sirius.diagram.description.concern.ConcernSet;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.filter.FilterFactory;
import org.eclipse.sirius.diagram.description.filter.FilterKind;
import org.eclipse.sirius.diagram.description.filter.MappingFilter;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.JavaExtension;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class ViewEnhancer
extends SessionManagerListener.Stub {
    public void notifyAddSession(final Session session) {
        Job updateJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                UpdateDescriptionCommand command = new UpdateDescriptionCommand(session.getTransactionalEditingDomain(), session, this);
                session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.setUser(false);
        updateJob.schedule();
        super.notifyAddSession(session);
    }

    private final class UpdateDescriptionCommand
    extends RecordingCommand {
        private static final String SERVICE_CLASSNAME = "org.polarsys.kitalpha.ad.integration.sirius.ModelExtensionServices";
        private static final String FILTER_NAME = "Hide Model Extension";
        private static final String DEFAULT_NAME = "default";
        private final Session session;
        private final Job containerJob;

        private UpdateDescriptionCommand(TransactionalEditingDomain domain, Session session, Job containerJob) {
            super(domain);
            this.session = session;
            this.containerJob = containerJob;
        }

        protected void doExecute() {
            Collection ownedViews = this.session.getOwnedViews();
            if (ownedViews.isEmpty()) {
                this.containerJob.schedule(1000L);
                return;
            }
            for (DView v : ownedViews) {
                if (v.getViewpoint() == null || v.getViewpoint().eResource() == null) continue;
                for (RepresentationDescription representation : v.getViewpoint().getOwnedRepresentations()) {
                    if (!(representation instanceof DiagramDescription)) continue;
                    DiagramDescription spec = (DiagramDescription)representation;
                    this.addJavaExtension(v);
                    if (!this.needFilter(spec)) continue;
                    CompositeFilterDescription compositeFilterDescription = FilterFactory.eINSTANCE.createCompositeFilterDescription();
                    compositeFilterDescription.setName(FILTER_NAME);
                    MappingFilter mappingFilter = FilterFactory.eINSTANCE.createMappingFilter();
                    mappingFilter.setFilterKind(FilterKind.HIDE_LITERAL);
                    mappingFilter.setViewConditionExpression("<%isExtensionModelActive()%>");
                    compositeFilterDescription.getFilters().add((Object)mappingFilter);
                    spec.getFilters().add((Object)compositeFilterDescription);
                    ConcernSet concerns = spec.getConcerns();
                    if (concerns == null) {
                        concerns = ConcernFactory.eINSTANCE.createConcernSet();
                        ConcernDescription defaultConcern = ConcernFactory.eINSTANCE.createConcernDescription();
                        defaultConcern.setLabel(DEFAULT_NAME);
                        defaultConcern.setName(DEFAULT_NAME);
                        spec.setConcerns(concerns);
                        spec.setDefaultConcern(defaultConcern);
                        concerns.getOwnedConcernDescriptions().add((Object)defaultConcern);
                    }
                    for (ConcernDescription desc : concerns.getOwnedConcernDescriptions()) {
                        desc.getFilters().add((Object)compositeFilterDescription);
                    }
                }
            }
        }

        private boolean needFilter(DiagramDescription spec) {
            for (FilterDescription desc : spec.getFilters()) {
                if (!FILTER_NAME.equals(desc.getName())) continue;
                return false;
            }
            return true;
        }

        private void addJavaExtension(DView view) {
            JavaExtension javaExt2;
            for (JavaExtension javaExt2 : view.getViewpoint().getOwnedJavaExtensions()) {
                if (!SERVICE_CLASSNAME.equals(javaExt2.getQualifiedClassName())) continue;
                return;
            }
            javaExt2 = DescriptionFactory.eINSTANCE.createJavaExtension();
            javaExt2.setQualifiedClassName(SERVICE_CLASSNAME);
            view.getViewpoint().getOwnedJavaExtensions().add((Object)javaExt2);
        }
    }
}

