/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.integration.services;

import java.util.Iterator;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Service;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.RuleProvider;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.Rules;
import org.polarsys.kitalpha.ad.viewpoint.integration.services.ServiceImplementation;
import org.polarsys.kitalpha.ad.viewpoint.utils.ModelAccessor;

public class DefaultServiceImplementation
implements ServiceImplementation {
    @Override
    public void run(Service service, ModelAccessor accessor, Object[] selection) {
        for (Rule rule : service.getRelatedRules()) {
            RuleProvider provider = Rules.getProvider((rule = accessor.resolveRule(rule.getId())).getType());
            if (provider == null) {
                String message = "Cannot find provider: " + rule.getType() + " for rule '" + rule.getId() + "'";
                AD_Log.getDefault().logError(message);
                continue;
            }
            provider.execute(rule, accessor, selection);
        }
    }

    @Override
    public boolean canRun(Service service, ModelAccessor accessor, Object[] selection) {
        Iterator iterator = service.getRelatedRules().iterator();
        if (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            String id = rule.getId();
            if ((rule = accessor.resolveRule(id)) == null) {
                AD_Log.getDefault().logError("Cannot find rule '" + id + "' in service '" + service.getId() + "'");
                return false;
            }
            RuleProvider provider = Rules.getProvider(rule.getType());
            if (provider == null) {
                String message = "Cannot find provider: " + rule.getType() + " for rule '" + id + "'";
                AD_Log.getDefault().logError(message);
                return false;
            }
            return provider.canExecute(rule, accessor, selection);
        }
        return true;
    }
}

