/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.visualize.data.accessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.massactions.core.column.IMAColumn;
import org.polarsys.kitalpha.massactions.core.data.accessor.AbstractMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.extensionpoint.columnprovider.IMAColumnProvider;
import org.polarsys.kitalpha.massactions.core.extensions.columnprovider.MABasicColumnProvider;
import org.polarsys.kitalpha.massactions.core.helper.CommonFeaturesHelper;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;
import org.polarsys.kitalpha.massactions.visualize.extensions.columnprovider.QueryColumnProvider;
import org.polarsys.kitalpha.massactions.visualize.helpers.container.UnfoldedRowObject;
import org.polarsys.kitalpha.massactions.visualize.unfold.MVPerspectiveManager;

public class MVColumnPropertyAccessor
extends AbstractMAColumnPropertyAccessor {
    private Log log = LogFactory.getLog(MVColumnPropertyAccessor.class);
    protected MVPerspectiveManager perspectiveManager;

    public MVColumnPropertyAccessor(IMABodyLayer bodyLayer) {
        super(bodyLayer);
        this.perspectiveManager = new MVPerspectiveManager(bodyLayer);
        this.columnProperties = Collections.emptyList();
        this.prevColumnProperties = Collections.emptyList();
        this.initializeColumnProviders();
        this.dataChanged(bodyLayer.getData());
    }

    private void initializeColumnProviders() {
        LinkedList<IMAColumnProvider> localColumnProviders = new LinkedList<IMAColumnProvider>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = extensionRegistry.getConfigurationElementsFor("org.polarsys.kitalpha.massactions.core.columnprovider");
        IMAColumnProvider basicColumnProvider = null;
        IMAColumnProvider queryColumnProvider = null;
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                String kind;
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object o = element.createExecutableExtension("class");
                if (o instanceof IMAColumnProvider && "visualization".equals(kind = element.getAttribute("kind"))) {
                    IMAColumnProvider columnProvider = (IMAColumnProvider)o;
                    columnProvider.setBodyLayer(this.bodyLayer);
                    if (o instanceof MABasicColumnProvider) {
                        basicColumnProvider = columnProvider;
                    } else if (o instanceof QueryColumnProvider) {
                        queryColumnProvider = columnProvider;
                    } else {
                        localColumnProviders.add(columnProvider);
                    }
                }
                ++n2;
            }
            if (basicColumnProvider != null) {
                localColumnProviders.addFirst(basicColumnProvider);
            }
            if (queryColumnProvider != null) {
                localColumnProviders.addLast(queryColumnProvider);
            }
        }
        catch (CoreException e) {
            this.log.error((Object)e.getMessage());
        }
        this.columnProviders = new ArrayList(localColumnProviders);
    }

    public void dataChanged(Collection<EObject> data) {
        Collection possibleFeatures = CommonFeaturesHelper.getCommonPossibleFeatures(data);
        int columnIndex = 0;
        this.columnList = new ArrayList();
        this.prevColumnProperties = this.columnProperties;
        this.columnProperties = new ArrayList();
        this.columnPropertiesIndex = new HashMap();
        for (IMAColumnProvider columnProvider : this.columnProviders) {
            Collection extensionColumns = columnProvider.getColumnValues(possibleFeatures, data);
            for (IMAColumn column : extensionColumns) {
                column.setIndex(columnIndex++);
                column.dataChanged(data);
                column.setEditable(false);
                this.columnProperties.add(column.getName());
                this.columnPropertiesIndex.put(column.getName(), column.getIndex());
                this.columnList.add(column);
            }
        }
        this.perspectiveManager.dataChanged(data);
        if (!this.perspectiveManager.isFolded()) {
            this.perspectiveManager.unfold(this.columnList);
        }
    }

    public Object getDataValue(EObject rowObject, int columnIndex) {
        if (rowObject instanceof UnfoldedRowObject) {
            UnfoldedRowObject unfoldedEObject = (UnfoldedRowObject)rowObject;
            return unfoldedEObject.getDataValue(columnIndex);
        }
        return ((IMAColumn)this.columnList.get(columnIndex)).getDataValue(rowObject);
    }

    public void setDataValue(EObject rowObject, int columnIndex, Object newValue) {
    }

    public void switchPerspective() {
        this.perspectiveManager.switchPerspective(this.columnList);
        this.bodyLayer.notifyListeners();
    }

    public Collection<EObject> getCurrentDataRepresentation() {
        return this.perspectiveManager.getCurrentPerspectiveData();
    }

    public MVPerspectiveManager getPerspectiveManager() {
        return this.perspectiveManager;
    }
}

