/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.api.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.kitalpha.composer.Activator;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceNotFoundException;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class LibraryReuseHelper {
    public static LibraryReuseHelper INSTANCE = new LibraryReuseHelper();
    public String DOMAIN = "Allocation";
    private ResourceHelper helper = ResourceReuse.createHelper();

    private LibraryReuseHelper() {
    }

    public Resource[] getLibraries() {
        SearchCriteria criteria = new SearchCriteria();
        criteria.setDomain(this.DOMAIN);
        return this.helper.getResources(criteria);
    }

    public Resource[] getLibraries(List<String> tags_p) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.setDomain(this.DOMAIN);
        if (tags_p != null) {
            criteria.getTags().addAll(tags_p);
        }
        return this.helper.getResources(criteria);
    }

    public List<Resource> getResourcesFromIds(List<String> list_p) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (list_p != null) {
            for (String id : list_p) {
                try {
                    Resource res = this.helper.getResource(id);
                    resources.add(res);
                }
                catch (ResourceNotFoundException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.composer.core", e.getMessage()));
                }
            }
        }
        return resources;
    }
}

