/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.kitalpha.report.model.LogEntry;
import org.polarsys.kitalpha.report.model.ReportList;
import org.polarsys.kitalpha.report.registry.ReportRegistry;
import org.polarsys.kitalpha.report.ui.description.ColumnDescription;
import org.polarsys.kitalpha.report.ui.description.ReportsUI;
import org.polarsys.kitalpha.report.ui.views.DeleteAllReportsAction;
import org.polarsys.kitalpha.report.ui.views.DeleteReportsAction;
import org.polarsys.kitalpha.report.ui.views.LoadReportListAction;
import org.polarsys.kitalpha.report.ui.views.ManageColumnsAction;
import org.polarsys.kitalpha.report.ui.views.ReportContentProvider;
import org.polarsys.kitalpha.report.ui.views.ReportTableSorter;
import org.polarsys.kitalpha.report.ui.views.SaveReportListAction;
import org.polarsys.kitalpha.report.ui.views.SelectReportDropDownAction;
import org.polarsys.kitalpha.report.ui.views.SetSeverityFilterAction;

public class ReportsView
extends ViewPart
implements Observer {
    private static final String DESCRIPTION_KEY = "description";
    protected int severityThreshold = -1;
    protected MyTreeViewer viewer;
    private ReportRegistry.Listener listener = new ReportRegistry.Listener(){

        public void reportListUpdated(ReportList list) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if ((this).ReportsView.this.viewer != null && !(this).ReportsView.this.viewer.getControl().isDisposed()) {
                        ReportsView.this.refreshView();
                    }
                }
            });
        }
    };
    private final DeleteReportsAction deleteReportAction = new DeleteReportsAction(this);
    private final DeleteAllReportsAction deleteAllReportAction = new DeleteAllReportsAction();
    private final Map<String, TreeViewerColumn> columns = new HashMap<String, TreeViewerColumn>();
    private StyledText detailText;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm comp1a = new SashForm(parent, 256);
        this.createTreeViewer((Composite)comp1a);
        this.createTextViewer((Composite)comp1a);
        comp1a.setWeights(new int[]{5, 1});
        this.contributeToActionBars();
        ReportsUI.addObserver(this);
    }

    private void createTextViewer(Composite parent) {
        this.detailText = new StyledText(parent, 2816);
        this.detailText.setEditable(false);
        this.detailText.setText("");
    }

    public void selectAndReveal(LogEntry entry) {
        ReportsUI.showList((ReportList)entry.eContainer());
        this.viewer.refresh();
        StructuredSelection selection = new StructuredSelection((Object)entry);
        this.viewer.setSelection((ISelection)selection, true);
    }

    private void createTreeViewer(Composite parent) {
        this.viewer = new MyTreeViewer(parent, 68354);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setHeaderVisible(true);
        for (String id : ReportsUI.getDisplayedColumns()) {
            this.createColumn(id);
        }
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                LogEntry entry = (LogEntry)element;
                return ReportsView.this.severityThreshold == -1 || entry.getSeverity().getCode() <= ReportsView.this.severityThreshold;
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ReportContentProvider());
        this.viewer.setSorter(new ReportTableSorter(DESCRIPTION_KEY));
        this.viewer.getTree().setSortDirection(1024);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.viewer.getTree().setLayoutData((Object)gridData);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (ss.size() == 1) {
                    LogEntry entry = (LogEntry)ss.getFirstElement();
                    ReportsView.this.detailText.setText(entry.getMessage() == null ? "" : entry.getMessage());
                } else {
                    ReportsView.this.detailText.setText("");
                }
                ReportsView.this.deleteReportAction.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.viewer.setInput(ReportRegistry.INSTANCE);
        this.deleteReportAction.setEnabled(false);
        this.refreshView();
        ReportRegistry.INSTANCE.addListener(this.listener);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = bars.getToolBarManager();
        toolBarManager.add((IAction)new ManageColumnsAction(this));
        toolBarManager.add((IAction)new SetSeverityFilterAction(this));
        toolBarManager.add((IContributionItem)new Separator("grp1"));
        toolBarManager.add((IAction)new LoadReportListAction(this));
        toolBarManager.add((IAction)new SaveReportListAction(this));
        toolBarManager.add((IContributionItem)new Separator("grp2"));
        toolBarManager.add((IAction)this.deleteReportAction);
        toolBarManager.add((IAction)this.deleteAllReportAction);
        toolBarManager.add((IContributionItem)new Separator("grp3"));
        toolBarManager.add((IAction)new SelectReportDropDownAction());
    }

    public int getSeverityThreshold() {
        return this.severityThreshold;
    }

    public void setSeverityThreshold(int severityThreshold) {
        this.severityThreshold = severityThreshold;
        if (this.viewer != null && !this.viewer.getTree().isDisposed()) {
            this.refreshView();
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        ReportsUI.removeObserver(this);
        super.dispose();
    }

    void refreshView() {
        this.viewer.refresh();
        this.deleteAllReportAction.setEnabled(this.viewer.getTree().getItems().length > 0);
    }

    void deleteColumn(String id) {
        TreeViewerColumn treeViewerColumn = this.columns.remove(id);
        if (treeViewerColumn != null) {
            treeViewerColumn.getColumn().dispose();
        }
    }

    void createColumn(String id) {
        final ColumnDescription desc = ReportsUI.getColumnDescription(id);
        TreeViewerColumn treeColumn = new TreeViewerColumn((TreeViewer)this.viewer, desc.getAlignment());
        this.columns.put(id, treeColumn);
        treeColumn.getColumn().setData(DESCRIPTION_KEY, (Object)desc);
        treeColumn.getColumn().setText(desc.getLabel());
        treeColumn.getColumn().setWidth(desc.getWidth());
        treeColumn.getColumn().setMoveable(true);
        treeColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                desc.update(cell);
            }
        });
        treeColumn.getColumn().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn selectedColumn = (TreeColumn)e.widget;
                int sortDirection = ReportsView.this.viewer.getTree().getSortDirection();
                if (selectedColumn.equals(ReportsView.this.viewer.getTree().getSortColumn())) {
                    ReportsView.this.viewer.getTree().setSortDirection(sortDirection == 128 ? 1024 : 128);
                } else {
                    ReportsView.this.viewer.getTree().setSortColumn(selectedColumn);
                }
                ReportsView.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    public List<LogEntry> getDisplayedReports() {
        Object[] filteredChildren = this.viewer.getFilteredChildren(this.viewer.getInput());
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        Object[] objectArray = filteredChildren;
        int n = filteredChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            result.add((LogEntry)obj);
            ++n2;
        }
        return result;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof String) {
            String id = (String)arg;
            if (ReportsUI.getColumnDescription(id) == null) {
                this.deleteColumn(id);
            } else if (ReportsUI.getDisplayedColumns().contains(id) && !this.columns.containsKey(id)) {
                this.createColumn(id);
            }
        }
        this.viewer.refresh();
    }

    static class MyTreeViewer
    extends TreeViewer {
        public MyTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public Object[] getFilteredChildren(Object parent) {
            return super.getFilteredChildren(parent);
        }
    }
}

