/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.share.modelresources.helpers;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DetachmentHelper {
    private static Map<URI, Resource> loadedResources = new HashMap<URI, Resource>();
    private static final Logger _LOGGER = Logger.getLogger(DetachmentHelper.class);

    public static URI getPlatformURIFromNSURI(URI uri) {
        Resource r = null;
        r = loadedResources.get(uri);
        if (r == null) {
            ResourceSetImpl rs = new ResourceSetImpl();
            URI genmodelURI = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap().get(uri.toString());
            if (genmodelURI != null && genmodelURI.isPlatformPlugin()) {
                r = rs.createResource(genmodelURI);
                loadedResources.put(uri, r);
            }
        }
        if (r != null) {
            EList genmodels;
            Iterator iterator;
            EList genContents;
            try {
                if (!r.isLoaded()) {
                    r.load(null);
                }
            }
            catch (IOException e) {
                _LOGGER.error((Object)("Unable to load resource " + uri), (Throwable)e);
            }
            if ((genContents = r.getContents()) != null && !genContents.isEmpty() && (iterator = (genmodels = ((GenModel)genContents.get(0)).getGenPackages()).iterator()).hasNext()) {
                GenPackage genPackage = (GenPackage)iterator.next();
                return genPackage.getEcorePackage().eResource().getURI();
            }
        }
        return null;
    }

    public static URI getPlatformResourceURIFromEObject(EObject eObject) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)eObject);
        if (rootContainer instanceof EPackage) {
            String nsURI2 = ((EPackage)rootContainer).getNsURI();
            if (nsURI2 == null) {
                return null;
            }
            return DetachmentHelper.getPlatformURIFromNSURI(URI.createURI((String)nsURI2));
        }
        String nsURI = eObject.eClass().getEPackage().getNsURI();
        return DetachmentHelper.getPlatformURIFromNSURI(URI.createURI((String)nsURI));
    }

    public static Collection<String> getRefrencedModelURIFromAirdResource(Resource airdResource) {
        Collection<String> result = null;
        try {
            URI uri = airdResource.getURI();
            String projectName = uri.segment(1);
            String airdRelativePath = DetachmentHelper.getRelativePath(uri);
            IFile airdFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).findMember(airdRelativePath);
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(false);
            SAXModelsElementsParser modelEltParser = new SAXModelsElementsParser();
            SAXParser saxParser = saxFactory.newSAXParser();
            saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(modelEltParser);
            InputSource is = new InputSource();
            is.setByteStream(airdFile.getContents());
            xmlReader.parse(is);
            return modelEltParser.getMelodyModellers();
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
            _LOGGER.error((Object)e);
            return result;
        }
    }

    private static String getRelativePath(URI uri) {
        StringBuilder buf = new StringBuilder();
        String[] segments = uri.segments();
        if (segments.length > 1) {
            int i = 2;
            while (i < segments.length - 1) {
                buf.append(segments[i]).append("/");
                ++i;
            }
        }
        buf.append(uri.lastSegment());
        return buf.toString();
    }

    public static Collection<Resource> getRefrencedModelResources(Resource resource, Collection<String> refrencedModels) {
        HashSet<Resource> refrencedResources = new HashSet<Resource>();
        ResourceSet resourceSet = resource.getResourceSet();
        EList resources = resourceSet.getResources();
        for (Resource resource2 : resources) {
            String resourceName = resource2.getURI().lastSegment();
            if (!refrencedModels.contains(resourceName)) continue;
            refrencedResources.add(resource2);
        }
        return refrencedResources;
    }

    public static Collection<Resource> getRefrencedModelResources(Resource resource) {
        HashSet<Resource> refrencedResources = new HashSet<Resource>();
        Collection<String> refrencedModels = DetachmentHelper.getRefrencedModelURIFromAirdResource(resource);
        ResourceSet resourceSet = resource.getResourceSet();
        EList resources = resourceSet.getResources();
        for (Resource resource2 : resources) {
            String resourceName = resource2.getURI().lastSegment();
            if (refrencedModels == null || !refrencedModels.contains(resourceName)) continue;
            refrencedResources.add(resource2);
        }
        return refrencedResources;
    }

    public static class SAXModelsElementsParser
    extends DefaultHandler {
        Collection<String> melodyModellers;

        @Override
        public void startDocument() throws SAXException {
            this.melodyModellers = new HashSet<String>();
        }

        @Override
        public void startElement(String namespaceURI, String name, String qname, Attributes attr) throws SAXException {
            String fileModelName;
            if (qname != null && qname.equals("models") && (fileModelName = attr.getValue("href")) != null && !fileModelName.isEmpty()) {
                if (fileModelName.contains("#")) {
                    fileModelName = fileModelName.substring(0, fileModelName.indexOf("#"));
                }
                this.melodyModellers.add(fileModelName);
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        public Collection<String> getMelodyModellers() {
            return this.melodyModellers;
        }
    }
}

